<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * The template for displaying Search Results pages.
 *
 * @package WordPress
 * @subpackage Seja_Framework
 *
 * ------------------------------------------------------------------------ */

get_header(); ?>
<!-- search.php -->
<?php seja_layout( array('type' => 'spage') ); ?>

<?php if ( have_posts() ) : ?>
	<h1 class="page-title"><?php printf( __( 'Search Results for: %s', 'seja_framework' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
	<?php  get_template_part( 'loop', 'search' ); ?>
<?php else : ?>
	<div id="post-0" class="post no-results not-found">
		<h2 class="entry-title"><?php _e( 'Nothing Found', 'seja_framework' ); ?></h2>
		<div class="entry-content">
			<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'seja_framework' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>
<?php seja_layout( array('type' => 'epage') ); ?>

<?php get_footer(); ?>