// JavaScript Document
(function() {
    tinymce.create('tinymce.plugins.mylink', {
        init : function(ed, url) {
			
			// popup for mosaic 
			ed.addCommand('mosaic_popup', function(ui, v) {
				// defaults
				var mosaic_type = 'bar';
				if (v.mosaic_type)
					mosaic_type = v.mosaic_type;
				var mosaic_title = '';
				if (v.mosaic_title)
					mosaic_title = v.mosaic_title;
				var mosaic_url = '';
				if (v.mosaic_url)
					mosaic_url = v.mosaic_url;
				var mosaic_subtext = '';
				if (v.mosaic_subtext)
					mosaic_subtext = v.mosaic_subtext;
				
				// open the popup
				ed.windowManager.open({
					title: 'Add Mosaic Image Tile',
					body: [
						{ // type
							type: 'listbox',
							name: 'type',
							label: 'Rollover Type',
							value: mosaic_type,
							'values': [
								{text: 'Circle', value: 'circle'},
								{text: 'Fade', value: 'fade'},
								{text: 'Bar', value: 'bar'},
								{text: 'Bar 1', value: 'bar1'},
								{text: 'Bar 2', value: 'bar2'}
							],
							tooltip: 'Default is Bar'
						},
						{ // title
							type: 'textbox',
							name: 'title',
							label: 'Title',
							value: mosaic_title,
							data: mosaic_title,
							tooltip: 'Add your Title Text'
						},
						{ // url
							type: 'textbox',
							name: 'url',
							label: 'Link',
							value: mosaic_url,
							tooltip: 'Paste the target URL here'
						},
						{ // subtext
							type: 'textbox',
							name: 'subtext',
							label: 'Subtext (optional)',
							value: mosaic_subtext,
                       		multiline: true,
                        	minWidth: 300,
                        	minHeight: 100
						}
					], // #25
					onsubmit: function( e ) {
						var output_html = '<div class="mosaic-wrapper"><div class="mosaic-block ' + e.data.type + '"><div class="mosaic-overlay link-div"><div class="details"><h3><a href="' + e.data.url + '" target="_blank">' + e.data.title + '</h3>';
						// check subtext
						if (typeof e.data.subtext != 'undefined' && e.data.subtext.length)
							output_html += '<p>' + e.data.subtext + '</p>';
						output_html += '</div></div><div class="mosaic-backdrop"><img src="http://buildinternet.s3.amazonaws.com/projects/mosaic/mosaic.jpg" /></div></div></div><p><strong class="highlight">Remove:</strong> This line has been added to make it easier to add content after inserting the tile</p>';
						
						// insert html
						ed.insertContent( output_html );
						//console.log( e.data ); 
						
					} // #65
				}); // #23
			});// #7			
			
			ed.addButton('youtube', {
                title : 'Embed YouTube Video',
                image : url+'/../images/mce/youtube.png',
                onclick : function() {
                    idPattern = /(?:(?:[^v]+)+v.)?([^&=]{11})(?=&|$)/;
                    var vidId = prompt("YouTube Video", "Enter the id or url for your video");
                    var m = idPattern.exec(vidId);
                    if (m != null && m != 'undefined')
                        ed.execCommand('mceInsertContent', false, '[youtube video="'+m[1]+'"]');
                }
            });
			ed.addButton('facebook', {
                title : 'Add Facebook like button',
                image : url+'/../images/mce/facebook.png',
                onclick : function() {
					var fbl_layout = 'standard';
					var fbl_width = '450';
					var fbl_height = '25';
					var fbl_faces = 'false';
					var fbl_colorscheme = 'light';
					var fbl_action = 'like';
                    //ed.selection.setContent('[facebook]');
 					ed.selection.setContent('<iframe src="http://www.facebook.com/plugins/like.php?href=' + window.location.href  + '&amp;layout=' + fbl_layout + '&amp;show_faces=' + fbl_faces + '&amp;width=' + fbl_width + '&amp;action=' + fbl_action + '&amp;colorscheme=' + fbl_colorscheme + '" scrolling="no" frameborder="0" allowTransparency="true" style="border:none; overflow:hidden; width:' + fbl_width + 'px; height:' + fbl_height + 'px"></iframe>');
 
 
 
 
 
 
                }
            });
			// to be depreciated 2.9
		ed.addButton('clearfloat', {
                title : 'Clear floating elements in a line-break (Depreciated, use  Formats > Other Layouts > Clear Float',
                image : url+'/../images/mce/clearfloat.png',
                onclick : function() {
                     ed.selection.setContent('[clearfloat]');
                }
            });
		
		ed.addButton('divanchor', {
                title : 'Adds a named div for #hyperlinks',
                image : url+'/../images/mce/anchor.png',
                onclick : function() {
					var sel = prompt("Enter anchor name", " ");
                    //var sel = ed.selection.getContent();
					ed.execCommand('mceInsertContent', false, '[anchor name="'+sel+'"]');
                }
            });
			ed.addButton('mosaic', {
				image : url+'/../images/mce/mosaic.png',
				tooltip: 'Create a Mosaic Image Block',
				onclick : function() {
					ed.execCommand('mosaic_popup','',{
						mosaic_type : 'bar',
						mosaic_title : 'Change this to your title',
						mosaic_url : '#',
						mosaic_subtext: ''
					});	
				}
			});
        }, //#4
		
        createControl : function(n, cm) {
            return null;
        },
		
		
		
				
    }); // #2
		
    tinymce.PluginManager.add('mylink', tinymce.plugins.mylink);
		
})();