<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Theme Options Page - Setting Registration 
 * ------------------------------------------------------------------------ */
 
function seja_initialise_theme_options() { 
/* ------------------------------------------------------------------------ * 
 * 1.1 - General Options
 * ------------------------------------------------------------------------ */

    add_settings_section(  
        'seja_general_options_section',
        'Display Options',
        'seja_general_options_callback',
        'seja_general_options'
    ); 
	
	// Template Width
	add_settings_field(
        'seja_template_width',                      
        '<i class="fas fa-arrows-alt-h fa-2x"></i> Template Width',               
        'seja_template_width_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            'Recommended setting 1200px' 
        ) 
    );
	// Responsive Width
	add_settings_field(  
        'seja_responsive_point',                      
        '<i class="fas fa-expand fa-2x"></i> Responsive Change Point',               
        'seja_responsive_point_callback',   
        'seja_general_options',                     
        'seja_general_options_section',         
         array(                               
            'Changes where responsive resizing occurs in menu and other page elements<br>Recommended minimum size: 800px' 
        ) 
    );
	// Site Offline Mode
	add_settings_field(
        'seja_maintenance_mode',                      
        '<span class="fa-stack fa-xs"><i class="far fa-file fa-stack-2x"></i><i class="fas fa-times fa-stack-2x" style="color:#f90"></i></span> Site Offline',               
        'seja_maintenance_mode_callback',   
        'seja_general_options',                     
        'seja_general_options_section'
    );
	// Enable Debug Mode
	add_settings_field(
        'seja_theme_debug',                      
        '<i class="fas fa-wrench fa-2x"></i> Debug Theme',               
        'seja_theme_debug_callback',   
        'seja_general_options',                     
        'seja_general_options_section'
    );
	// Enable WooCommerce Support
	add_settings_field(   
        'seja_woocommerce_support',      
        '<i class="fas fa-shopping-cart fa-2x"></i> WooCommerce Support', 
        'seja_woocommerce_support_callback',
        'seja_general_options',
        'seja_general_options_section',
        array(                               
            '<strong>Add Theme Support for WooCommerce</strong>' 
        ) 
    );
	// Enable Accordion
	add_settings_field(  
        'seja_enable_accordion',                       
        '<i class="far fa-map fa-2x"></i> Enable Accordion shortcode',                
        'seja_enable_accordion_callback',    
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<strong>Enables the jquery accordion shortcode. </strong><br>
             <i class="fa fa-exclamation-triangle"></i> To reduce unnecessary code you should not enable this unless you intend to use it' 
        ) 
    );
	// Enable Scroll to Top
	add_settings_field(  
        'seja_enable_toplink',                       
        '<i class="far fa-caret-square-up fa-2x"></i> Link to Top',                
        'seja_enable_toplink_callback',    
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<strong>Enable the "link to top" button</strong>' 
        ) 
    );
	add_settings_field(  
        'seja_seo_override',                       
        '<span class="fa-stack fa-xs"><i class="fas fa-search fa-stack-2x"></i><i class="fas fa-times fa-stack-2x" style="color:#f90"></i></span>Override Framework SEO',                
        'seja_seo_override_callback',    
        'seja_general_options',         
        'seja_general_options_section',          
        array(                               
            '<strong>Click if you\'re using a third party plugin</strong><br>
			(such as <a href="https://yoast.com/">Yoast</a>)'
        )
    );
	add_settings_field(  
        'seja_seo_sitemap',                       
        '<i class="fas fa-sitemap fa-2x"></i> View Sitemap',                
        'seja_seo_sitemap_callback',    
        'seja_general_options',         
        'seja_general_options_section',          
        ''
    );
	
	add_settings_field(  
        'seja_seo_robots',                       
        '<i class="fas fa-robot fa-2x"></i> Edit robots.txt',                
        'seja_seo_robots_callback',    
        'seja_general_options',         
        'seja_general_options_section',          
        ''
    );
	// Bullet Style
	add_settings_field(  
        'seja_bullet_type',                      
        '<i class="fas fa-circle"></i> Bulletpoint Type',               
        'seja_bullet_type_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>Set the default bullet type<br>This can be individually overwritten</em>' 
        ) 
    );
	add_settings_field(   
        'seja_google_varification',      
        '<i class="fas fa-heading fa-2x"></i><i class="fas fa-arrow-up" style="color:#f90;"></i> Insert header code<br>(top of header)</em>', 
        'seja_google_varification_callback',
        'seja_general_options',
        'seja_general_options_section',
        ''
    ); 
	
	add_settings_field(  
        'seja_google_analytics',                       
        '<i class="fas fa-heading fa-2x"></i><i class="fas fa-arrow-down" style="color:#f90;"></i> Insert header code<br>(bottom of header)</em>',                
        'seja_google_analytics_callback',    
        'seja_general_options',         
        'seja_general_options_section',          
        ''
    );
	// Site Logo
	add_settings_field(  
        'seja_site_logo',                      
        '<i class="fas fa-image fa-2x"></i> Header Logo',               
        'seja_site_logo_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>Logo file name</em>' 
        ) 
    );
if( SEJA_LOGO_EXT == 'svg' ):	
	// Site Logo Width
	add_settings_field(  
        'seja_logo_width',                      
        '',               
        'seja_logo_width_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>Logo width</em>' 
        ) 
    );
	// Site Logo Height
	add_settings_field(  
        'seja_logo_height',                      
        '',               
        'seja_logo_height_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>Logo height</em>' 
        ) 
    );
endif;	
	// Parallax Image
	add_settings_field(  
        'seja_parallax_file',                      
        '<i class="far fa-image fa-2x"></i> Parallax Image',               
        'seja_parallax_file_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>Parallax Header Image file name</em>' 
        ) 
    );
	// Parallax Usage
	add_settings_field(  
        'seja_parallax_usage',                      
        '',               
        'seja_parallax_usage_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>Parallax File can be used for Parallax of banner.</em>' 
        ) 
    );
	// Enable Mobile Menu
	add_settings_field(  
        'seja_mobile_menu',                      
        '<i class="fas fa-mobile-alt fa-2x"></i>  <strong>Mobile Menu</strong>',               
        'seja_mobile_menu_callback',   
        'seja_general_options',                     
        'seja_general_options_section',         
        array(                               
            '<strong>Adds a second menu location</strong>'
			 
        ) 
    ); 
	// Disable Responsive Menu
	add_settings_field(  
        'seja_responsive_menu',                      
        '<span class="fa-stack"><i class="fas fa-mobile fa-stack-2x"></i><i class="fas fa-inverse fa-times fa-stack-1x" style="color:#f90"></i></span> <strong>Disable</strong> Responsive Menu',               
        'seja_responsive_menu_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<strong>Disable Responsive Menu</strong>' 
        ) 
    );	
	// Index Column Position
	add_settings_field(  
        'seja_index_columns',                      
        '<i class="fas fa-columns fa-2x"></i> Blog Column Layout',               
        'seja_index_columns_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>index.php (This is the main page for blog posts)</em>' 
        ) 
    );

	// Single Post Column Position
	add_settings_field(  
        'seja_single_columns',                      
        '',               
        'seja_single_columns_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>single.php (The layout for a single post)</em>' 
        ) 
    ); 
	// Archive and Category Column Position
	add_settings_field(  
        'seja_category_columns',                      
        '',               
        'seja_category_columns_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>archive.php|category.php (The layout for archive and category listings)</em>' 
        ) 
    ); 
	// Column Width 
	add_settings_field(   
        'seja_column_width',      
        '<i class="fas fa-arrows-alt-h fa-2x"></i> Sidebar Width', 
        'seja_column_width_callback',
        'seja_general_options',                     
        'seja_general_options_section',
        array(                               
            '<em>Define the sidebar column width if a sidebar is used</em>' 
        ) 
    );
	// Footer Layout 
	add_settings_field(  
        'seja_footer_layout',                       
        '<i class="fas fa-columns fa-2x"></i> Footer Layout',                
        'seja_footer_layout_callback',    
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<em>//define the footer widget layout. </em><br>
             <img src="' . get_bloginfo( 'template_url' ) . '/images/admin/admin-footer-layouts.png">' 
        ) 
    );
	// Theme Colour
	add_settings_field(  
        'seja_bullet_colour',                      
        '<i class="fas fa-paint-brush fa-2x"></i> Theme Colour',               
        'seja_bullet_colour_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>Adjusts colour for bullet-points, blockquote, pagination, h1 - h6</em>' 
        ) 
    );
	// Text Colour
	add_settings_field(  
        'seja_text_colour',                      
        '<i class="fas fa-paint-brush fa-2x"></i> Text Colour',               
        'seja_text_colour_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>Adjusts main text colour (paragraphs, forms)</em>' 
        ) 
    );
	// Anchor Colour
	add_settings_field(  
        'seja_link_colour',                      
        '<i class="fas fa-link fa-2x"></i><span style="position:relative;left:-10px"><i class="fas fa-paint-brush fa-2x" style="color:#476ee5"></i> Link Colour</span>',               
        'seja_link_colour_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>Hyperlink Colour</em>' 
        ) 
    );
	// Hover Colour
	add_settings_field(  
        'seja_hover_colour',                      
        '<i class="fas fa-link fa-2x"></i><span style="position:relative;left:-10px"><i class="fas fa-paint-brush fa-2x" style="color:#f90"></i> Hover Colour</span>',               
        'seja_hover_colour_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
         array(                               
            '<em>Default hover colour</em>' 
        ) 
    );	
	// Copyright Colour
	add_settings_field(  
        'seja_copyright_colour',                       
        '<i class="far fa-copyright fa-2x"></i> Copyright Colour',                
        'seja_copyright_colour_callback',    
        'seja_general_options',                     
        'seja_general_options_section' 
    );
	// Auto-Update - WordPress Core
	add_settings_field(
        'seja_update_core',                      
        '<i class="fas fa-cog fa-2x"></i> Automatic Updates',               
        'seja_update_core_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<strong>Enable WordPress Core Update</strong>' 
        ) 
    );
	// Auto-Update -Plugins
	add_settings_field(  
        'seja_update_plugins',                      
        '',               
        'seja_update_plugins_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<strong>Enable WordPress Plugins updates</strong>' 
        ) 
    );
	// Auto-Update - Themes
	add_settings_field(  
        'seja_update_themes',                      
        '',               
        'seja_update_themes_callback',   
        'seja_general_options',                     
        'seja_general_options_section',          
        array(                               
            '<strong>Enable WordPress theme updates</strong>' 
        ) 
    );

/* ------------------------------------------------------------------------ * 
 * 1.2 - WooCommerce
 * ------------------------------------------------------------------------ */
	
	add_settings_section (
		'seja_woocommerce_options_section',
		'WooCommerce Options',
		'seja_woocommerce_options_callback',
		'seja_woocommerce_options'
	);
	
	add_settings_field(  
        'seja_woopage_columns',                      
        '<i class="fas fa-columns fa-2x"></i> Sidebar',               
        'seja_woopage_columns_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<em>Set the sidebar position</em>' 
        ) 
    );
	
	add_settings_field(  
        'seja_woo_columns',                      
        '<i class="fas fa-columns fa-2x"></i> Columns',               
        'seja_woo_columns_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<em>Number of columns per product</em>' 
        ) 
    ); 
	
	add_settings_field(  
        'seja_woo_rows',                      
        '<i class="fas fa-bars fa-2x"></i> Rows',               
        'seja_woo_rows_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<em>Number of product rows per page</em>' 
        ) 
    );
	
	add_settings_field(  
        'seja_woo_haspadding',                      
        '<i class="fas fa-arrows-alt-h fa-2x"></i> Padding',               
        'seja_woo_haspadding_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<strong>Adds padding to the product catelogue.</strong>' 
        ) 
    ); 
	
	add_settings_field(  
        'seja_woo_disable_pricerange',                      
        '<span class="fa-stack"><i class="fas fa-dollar-sign fa-stack-2x"></i><i class="fas fa-times fa-stack-1x" style="color:#f90"></i></span> Disable Price Range',               
        'seja_woo_disable_pricerange_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<strong>Disable price range on variable products</strong>' 
        ) 
    ); 
	
	add_settings_field(  
        'seja_woo_remove_related',                      
        '<span class="fa-stack"><i class="fas fa-exchange-alt fa-stack-2x"></i><i class="fas fa-times fa-stack-1x" style="color:#f90"></i></span> Disable Related',               
        'seja_woo_remove_related_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<strong>Disable related products</strong>' 
        ) 
    ); 
	
	add_settings_field(  
        'seja_woo_remove_additionaltab',                      
        '<span class="fa-stack"><i class="fas fa-info fa-stack-2x"></i><i class="fas fa-times fa-stack-1x" style="color:#f90"></i></span> Disable Additional Info',               
        'seja_woo_remove_additionaltab_callback',   
        'seja_woocommerce_options',                     
        'seja_woocommerce_options_section',          
        array(                               
            '<strong>Disable the additional info tab on products page</strong>' 
        ) 
    ); 
	
if ( SEJA_DEBUG_MODE == '1'):	
	add_settings_field(   
        'seja_woocommerce_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_woocommerce_debug_callback',
        'seja_woocommerce_options',
        'seja_woocommerce_options_section',
        ''
    );
endif;

/* ------------------------------------------------------------------------ * 
 * 3.1 - Facebook
 * ------------------------------------------------------------------------ */

    add_settings_section(  
        'seja_facebook_options_section',
        'Facebook Feed Options',
        'seja_facebook_options_callback',
        'seja_facebook_options'
    );  
      
    add_settings_field(   
        'seja_facebook_url',      
        '<i class="fab fa-facebook-f fa-2x"></i> Facebook URL <em><strong>Required</strong></em>', 
        'seja_facebook_url_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        ''
    ); 

    add_settings_field(   
        'seja_facebook_width',      
        '<i class="fas fa-arrows-alt-h fa-2x"></i> Width', 
        'seja_facebook_width_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
         array(                               
            '<em>Default 300 pixels</em>' 
        ) 
    ); 

	add_settings_field(   
        'seja_facebook_height',      
        '<i class="fas fa-arrows-alt-v fa-2x"></i> Height', 
        'seja_facebook_height_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            '<em>optional' 
        ) 
    ); 

	add_settings_field(   
        'seja_facebook_showfaces',      
        '<i class="fas fa-cogs fa-2x"></i> Additional Settings', 
        'seja_facebook_showfaces_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            '<strong>Show Faces</strong>' 
        ) 
    ); 

	add_settings_field(   
        'seja_facebook_showstream',      
        '', 
        'seja_facebook_showstream_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            '<strong>Show Stream</strong>' 
        )
    ); 

	add_settings_field(   
        'seja_facebook_showheader',      
        '', 
        'seja_facebook_showheader_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            '<strong>Show Header</strong>' 
        )
    );

	add_settings_field(   
        'seja_facebook_colourscheme',      
        '', 
        'seja_facebook_colourscheme_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            'Colour Scheme' 
        )
    ); 
    add_settings_field(   
        'seja_facebook_bordercolour',      
        '', 
        'seja_facebook_bordercolour_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        array(                               
            'Border Colour' 
        )
    ); 
	add_settings_field(  
        'seja_fb_pixel',                       
        '<i class="fab fa-facebook fa-2x"></i> Enable facebook Pixel<br>(leave empty to disable)',                
        'seja_fb_pixel_callback',    
        'seja_facebook_options',         
        'seja_facebook_options_section',          
        ''
    );
if ( SEJA_DEBUG_MODE == '1'):	
	add_settings_field(   
        'seja_facebook_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_facebook_debug_callback',
        'seja_facebook_options',
        'seja_facebook_options_section',
        ''
    );
endif;
	
/* ------------------------------------------------------------------------ * 
 * 3.2 - Google +
 * ------------------------------------------------------------------------ */
	
    add_settings_section(  
        'seja_googleplus_options_section',
        'Google +',
        'seja_googleplus_options_callback',
        'seja_googleplus_options'
    ); 
	
	add_settings_field(   
        'seja_googleplus_url',      
        '<i class="fab fa-google-plus-g fa-2x"></i> Google + URL', 
        'seja_googleplus_url_callback',
        'seja_googleplus_options',
        'seja_googleplus_options_section',
        ''
    );
	
if ( SEJA_DEBUG_MODE == '1'):	
	add_settings_field(   
        'seja_googleplus_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_googleplus_debug_callback',
        'seja_googleplus_options',
        'seja_googleplus_options_section',
        ''
    );
endif;

/* ------------------------------------------------------------------------ * 
 * 3.3 - Twitter
 * ------------------------------------------------------------------------ */
	
    add_settings_section(  
        'seja_twitter_options_section',
        'Twitter Feed Shortcode',
        'seja_twitter_options_callback',
        'seja_twitter_options'
    ); 
	
	add_settings_field(   
        'seja_twitter_iframe',      
        '<i class="fab fa-twitter fa-2x"></i> Twitter Code', 
        'seja_twitter_iframe_callback',
        'seja_twitter_options',
        'seja_twitter_options_section',
        ''
    );
	
if ( SEJA_DEBUG_MODE == '1'):
	
	add_settings_field(   
        'seja_twitter_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_twitter_debug_callback',
        'seja_twitter_options',
        'seja_twitter_options_section',
        ''
    );
endif;
      
/* ------------------------------------------------------------------------ * 
 * 3.4 - YouTube
 * ------------------------------------------------------------------------ */
 
    add_settings_section(  
        'seja_youtube_options_section',
        'Default YouTube Settings',
        'seja_youtube_options_callback',
        'seja_youtube_options'
    );  
	
	 add_settings_field(   
        'seja_youtube_rel',      
        '<i class="fab fa-youtube fa-2x"></i> Suggested', 
        'seja_youtube_rel_callback',
        'seja_youtube_options',
        'seja_youtube_options_section',
        array(                               
            '<strong>Display suggested videos</strong>' 
        )
    ); 
      
    add_settings_field(   
        'seja_youtube_width',      
        '<i class="fas fa-arrows-alt-h fa-2x"></i> Width', 
        'seja_youtube_width_callback',
        'seja_youtube_options',
        'seja_youtube_options_section',
        ''
    ); 

    add_settings_field(   
        'seja_youtube_height',      
        '<i class="fas fa-arrows-alt-v fa-2x"></i> Height', 
        'seja_youtube_height_callback',
        'seja_youtube_options',
        'seja_youtube_options_section',
        ''
    ); 

if ( SEJA_DEBUG_MODE == '1'):	
	add_settings_field(   
        'seja_youtube_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_youtube_debug_callback',
        'seja_youtube_options',
        'seja_youtube_options_section',
        ''
    );
endif;


/* ------------------------------------------------------------------------ * 
 * 3.5 - Weather Widget
 * ------------------------------------------------------------------------ */
 
 	add_settings_section(  
        'seja_weather_options_section',
        'Weather Widget Settings',
        'seja_weather_options_callback',
        'seja_weather_options'
    );
	
	add_settings_field(   
        'seja_weather_json_location',      
        '<i class="far fa-sun fa-2x"></i> Current Temperature', 
        'seja_weather_json_location_callback',
        'seja_weather_options',
        'seja_weather_options_section',
        array(                               
            '<em>Display current temperature in your location.</em>' 
        )
    ); 
	
	add_settings_field(   
        'seja_weather_json_apparent',      
        '<i class="fas fa-thermometer-empty fa-2x"></i> Feels Like', 
        'seja_weather_json_apparent_callback',
        'seja_weather_options',
        'seja_weather_options_section',
        array(                               
            '<strong>Display\'s the apparent temperature.</strong>' 
        )
    );
	
	add_settings_field(   
        'seja_weather_json_graph',      
        '<i class="far fa-chart-bar fa-2x"></i> Temperature Graph', 
        'seja_weather_json_graph_callback',
        'seja_weather_options',
        'seja_weather_options_section',
        array(                               
            '<em>Display a graph of the current temperature.</em>' 
        )
    );

if ( SEJA_DEBUG_MODE == '1'):	
	add_settings_field(   
        'seja_weather_debug',      
        '<i class="fas fa-wrench fa-2x"></i> DEBUG', 
        'seja_weather_debug_callback',
        'seja_weather_options',
        'seja_weather_options_section',
        ''
    );
endif;

/* ------------------------------------------------------------------------ * 
 * 4.1 - Theme Help - Basic Shortcode
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_basic_shortcode_options_section',
        'Basic Shortcode',
        'seja_basic_shortcode_options_callback',
        'seja_basic_shortcode_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_basic_shortcode_anchordiv',      
        '<i class="fas fa-anchor fa-2x"></i> Anchor Div', 
        'seja_basic_shortcode_anchordiv_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_basic_shortcode_clearfloat',      
        '<i class="fas fa-th fa-2x"></i> Clear Float', 
        'seja_basic_shortcode_clearfloat_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_basic_shortcode_separator',      
        '<i class="fas fa-minus fa-2x"></i> Separator', 
        'seja_basic_shortcode_separator_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_basic_shortcode_facebookone',      
        '<i class="fab fa-facebook-f fa-2x"></i> Facebook Like Button', 
        'seja_basic_shortcode_facebookone_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_basic_shortcode_facebooktwo',      
        '<i class="fab fa-facebook-f fa-2x"></i> Facebook News Feed', 
        'seja_basic_shortcode_facebooktwo_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_basic_shortcode_google',      
        '<i class="fab fa-google-plus-g fa-2x"></i> Google +', 
        'seja_basic_shortcode_google_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_basic_shortcode_twitter',      
        '<i class="fab fa-twitter fa-2x"></i> Twitter Feed', 
        'seja_basic_shortcode_twitter_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_basic_shortcode_youtube',      
        '<i class="fab fa-youtube fa-2x"></i> Embed YouTube video', 
        'seja_basic_shortcode_youtube_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_basic_shortcode_pagewidget',      
        '<i class="fas fa-cogs fa-2x"></i> Place a widget in a page', 
        'seja_basic_shortcode_pagewidget_callback',
        'seja_basic_shortcode_options',
        'seja_basic_shortcode_options_section',
        ''
    );

/* ------------------------------------------------------------------------ * 
 * 4.2 - Theme Help - Advanced Shortcode
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_advanced_shortcode_options_section',
        'Advanced Shortcode',
        'seja_advanced_shortcode_options_callback',
        'seja_advanced_shortcode_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_advanced_shortcode_accordion',      
        'Accordion Block', 
        'seja_advanced_shortcode_accordion_callback',
        'seja_advanced_shortcode_options',
        'seja_advanced_shortcode_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_advanced_shortcode_post_excerpts',      
        'Post Excerpts', 

        'seja_advanced_shortcode_post_excerpts_callback',
        'seja_advanced_shortcode_options',
        'seja_advanced_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_advanced_shortcode_inline_menu',      
        'Inline Menu', 
        'seja_advanced_shortcode_inline_menu_callback',
        'seja_advanced_shortcode_options',
        'seja_advanced_shortcode_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_advanced_shortcode_html',      
        'Insert External Page', 
        'seja_advanced_shortcode_html_callback',
        'seja_advanced_shortcode_options',
        'seja_advanced_shortcode_options_section',
        ''
    );
	
/* ------------------------------------------------------------------------ * 
 * 4.3 - Theme Help - Formatting (in editor) Options
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_formatting_options_section',
        'Formatting in the Editor',
        'seja_formatting_options_callback',
        'seja_formatting_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_formatting_dropdown',      
        'Dropdown Options', 
        'seja_formatting_dropdown_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_formatting_formatting',      
        'Formatting Sub-Menu', 
        'seja_formatting_formatting_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_formatting_layout',      
        'Layout Sub-Menu\'s', 
        'seja_formatting_layout_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_formatting_template',      
        'Template Options', 
        'seja_formatting_template_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_formatting_other',      
        'Other Options', 
        'seja_formatting_other_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    );
	
	add_settings_field(   
        'seja_formatting_mobilemenu',      
        'Mobile Menu', 
        'seja_formatting_mobilemenu_callback',
        'seja_formatting_options',
        'seja_formatting_options_section',
        ''
    ); 
	
/* ------------------------------------------------------------------------ * 
 * 4.4 - Theme Help - Scroll Page
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_scrollpage_options_section',
        'Create a Scrolling Page',
        'seja_scrollpage_options_callback',
        'seja_scrollpage_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_scrollpage_content',      
        'Understanding Structure', 
        'seja_scrollpage_content_callback',
        'seja_scrollpage_options',
        'seja_scrollpage_options_section',
        ''
    );
	add_settings_field(   
        'seja_scrollpage_styles',      
        'CSS Styles', 
        'seja_scrollpage_styles_callback',
        'seja_scrollpage_options',
        'seja_scrollpage_options_section',
        ''
    ); 	
/* ------------------------------------------------------------------------ * 
 * 4.5 - Theme Help - Customising the layout
 * ------------------------------------------------------------------------ */
	 add_settings_section(  
        'seja_customising_options_section',
        'Changing the layout order (Developers only)',
        'seja_customising_options_callback',
        'seja_customising_options'
    );  
	
	add_settings_field(   
        'seja_developers_content',      
        'Usage - seja_layout()', 
        'seja_developers_content_callback',
        'seja_customising_options',
        'seja_customising_options_section',
        ''
    );
	add_settings_field(   
        'seja_developers_header',      
        'Header Examples', 
        'seja_developers_header_callback',
        'seja_customising_options',
        'seja_customising_options_section',
        ''
    );

// not really settings - just text for support
	
/* ------------------------------------------------------------------------ * 
 * 4.6 - Theme Help - Font Awesome
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_font_awesome_options_section',
        'Formatting Solutions',
        'seja_font_awesome_options_callback',
        'seja_font_awesome_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_font_awesome_options_usage',      
        'Font Awesome Usage Examples', 
        'seja_font_awesome_options_usage_callback',
        'seja_font_awesome_options',
        'seja_font_awesome_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_font_awesome_options_list',      
        'Font Awesome Icon List', 
        'seja_font_awesome_options_list_callback',
        'seja_font_awesome_options',
        'seja_font_awesome_options_section',
        ''
    ); 

/* ------------------------------------------------------------------------ * 
 * 4.7 - Theme Help - Formating solutions seja_solution_options
 * ------------------------------------------------------------------------ */
 
	 add_settings_section(  
        'seja_solutions_options_section',
        'Formatting Solutions',
        'seja_solutions_options_callback',
        'seja_solutions_options'
    );  

// not really settings - just text for support

	 add_settings_field(   
        'seja_solutions_options_default',      
        'Multi-Column default', 
        'seja_solutions_options_default_callback',
        'seja_solutions_options',
        'seja_solutions_options_section',
        ''
    ); 
	
	add_settings_field(   
        'seja_solutions_options_sidebar',      
        'Multi-Column using a sidebar', 
        'seja_solutions_options_sidebar_callback',
        'seja_solutions_options',
        'seja_solutions_options_section',
        ''
    ); 


















/* ------------------------------------------------------------------------ * 
 * Theme Options Page - Register settings
 * ------------------------------------------------------------------------ */
 
	register_setting( 'seja_general_options', 'seja_template_width'  ); 
	register_setting( 'seja_general_options', 'seja_site_logo'  );
	register_setting( 'seja_general_options', 'seja_logo_width'  );
	register_setting( 'seja_general_options', 'seja_logo_height'  );
	register_setting( 'seja_general_options', 'seja_parallax_file'  ); 
	register_setting( 'seja_general_options', 'seja_parallax_usage'  );
	register_setting( 'seja_general_options', 'seja_mobile_menu'  ); 
	register_setting( 'seja_general_options', 'seja_responsive_menu'  );
	register_setting( 'seja_general_options', 'seja_responsive_point'  );
	register_setting( 'seja_general_options', 'seja_index_columns'  );
	register_setting( 'seja_general_options', 'seja_single_columns' );
	register_setting( 'seja_general_options', 'seja_category_columns' );
	register_setting( 'seja_general_options', 'seja_column_width' );
	register_setting( 'seja_general_options', 'seja_footer_layout'  );
	register_setting( 'seja_general_options', 'seja_maintenance_mode'  );
	register_setting( 'seja_general_options', 'seja_theme_debug'  );
	register_setting( 'seja_general_options', 'seja_woocommerce_support'  );
	register_setting( 'seja_general_options', 'seja_enable_accordion'  ); 
	register_setting( 'seja_general_options', 'seja_enable_toplink'  );
	register_setting( 'seja_general_options', 'seja_bullet_colour'  );
	register_setting( 'seja_general_options', 'seja_text_colour'  );
	register_setting( 'seja_general_options', 'seja_link_colour'  );
	register_setting( 'seja_general_options', 'seja_hover_colour'  );
	register_setting( 'seja_general_options', 'seja_bullet_type'  );
	register_setting( 'seja_general_options', 'seja_copyright_colour'  );
	register_setting( 'seja_general_options', 'seja_update_core'  );
	register_setting( 'seja_general_options', 'seja_update_plugins'  );
	register_setting( 'seja_general_options', 'seja_update_themes'  );
	register_setting( 'seja_general_options', 'seja_debug_output'  );
	
	register_setting( 'seja_woocommerce_options', 'seja_woopage_columns' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_columns' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_rows' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_haspadding' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_disable_pricerange' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_remove_related' );
	register_setting( 'seja_woocommerce_options', 'seja_woo_remove_additionaltab' );
	register_setting( 'seja_woocommerce_options', 'seja_woocommerce_debug' );
	/*
	register_setting( 'seja_footer_options', 'seja_footer_widget_facebook' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_twitter' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_linkedin' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_youtube' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_instagram' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_pinterest' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_rss' );
	register_setting( 'seja_footer_options', 'seja_footer_widget_icon' );
	*/
	register_setting( 'seja_seo_options', 'seja_seo_google_varification' );
	register_setting( 'seja_seo_options', 'seja_seo_google_analytics' );
	register_setting( 'seja_seo_options', 'seja_fb_pixel' );
	register_setting( 'seja_seo_options', 'seja_seo_override' );
	register_setting( 'seja_seo_options', 'seja_seo_sitemap' );
	register_setting( 'seja_seo_options', 'seja_seo_robots' ); 
	register_setting( 'seja_seo_options', 'seja_gzip_compression' );
	register_setting( 'seja_seo_options', 'seja_seo_debug' );
	
	register_setting( 'seja_facebook_options', 'seja_facebook_options_url' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_width' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_height' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_showfaces' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_showheader' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_showstream' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_colorscheme' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_bordercolor' );
	register_setting( 'seja_facebook_options', 'seja_facebook_options_debug' );
	
	register_setting( 'seja_googleplus_options', 'seja_googleplus_url' );
	register_setting( 'seja_googleplus_options', 'seja_googleplus_debug' );
	
	register_setting( 'seja_twitter_options', 'seja_twitter_options_code' );
	register_setting( 'seja_twitter_options', 'seja_twitter_debug' );
	 
	register_setting( 'seja_youtube_options', 'seja_youtube_options_rel' );
	register_setting( 'seja_youtube_options', 'seja_youtube_options_width' );
	register_setting( 'seja_youtube_options', 'seja_youtube_options_height' );
	register_setting( 'seja_youtube_options', 'seja_youtube_debug' );
	
	register_setting( 'seja_weather_options', 'seja_weather_json_location' );
	register_setting( 'seja_weather_options', 'seja_weather_json_apparent' );
	register_setting( 'seja_weather_options', 'seja_weather_json_graph' );
	register_setting( 'seja_weather_options', 'seja_weather_debug' );
	
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_anchordiv' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_clearfloat' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_separator' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_facebookone' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_facebooktwo' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_google' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_twitter' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_youtube' );
	register_setting( 'seja_basic_shortcode_options', 'seja_basic_shortcode_pagewidget' );
	
	register_setting( 'seja_advanced_shortcode_options', 'seja_advanced_shortcode_accordion' );
	register_setting( 'seja_advanced_shortcode_options', 'seja_advanced_shortcode_post_excerpts' );
	register_setting( 'seja_advanced_shortcode_options', 'seja_advanced_shortcode_inline_menu' );
	register_setting( 'seja_advanced_shortcode_options', 'seja_advanced_shortcode_html' );
	
	register_setting( 'seja_formatting_options', 'seja_formatting_dropdown' );
	register_setting( 'seja_formatting_options', 'seja_formatting_formatting' );
	register_setting( 'seja_formatting_options', 'seja_formatting_layout' );
	register_setting( 'seja_formatting_options', 'seja_formatting_template' );
	register_setting( 'seja_formatting_options', 'seja_formatting_other' );
	register_setting( 'seja_formatting_options', 'seja_formatting_mobilemenu' );
	
	register_setting( 'seja_scrollpage_options', 'seja_scrollpage_content' );
	
	register_setting( 'seja_customising_options', '' );
	
	register_setting( 'seja_font_awesome_options', 'seja_font_awesome_options_usage' );
	register_setting( 'seja_font_awesome_options', 'seja_font_awesome_options_list' );
	
	register_setting( 'seja_solutions_options', 'seja_solutions_options_default' );
	register_setting( 'seja_solutions_options', 'seja_solutions_options_sidebar' );
     
} // end seja_initialise_theme_options
add_action('admin_init', 'seja_initialise_theme_options'); 

 
/* ------------------------------------------------------------------------ * 
 * EOF
 * ------------------------------------------------------------------------ */
?>