<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * 4.1 - Theme Help - Basic Shortcode
 * ------------------------------------------------------------------------ */
 
 function seja_basic_shortcode_anchordiv_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[anchor name=X"]</strong><br><span style="font-size:0.9em;color:#a31100;"><em>This shortcode has a quick-use icon</em></span> <img src="<?php get_bloginfo( 'template_url' ) ?>/images/admin/anchor.png" width="20" height="20" alt="anchor"></p>
	<p>Creates a named anchor point - A point on the page that a link points to, instead of the top.<br> This is most commonly used in FAQ pages where there are a list of questions at the top of a page, with links to content lower down</p>
	<p><strong>Example of use</strong><br>
	[anchor name="jump-to-here"]<br>
    This creates an anchor point on the page that can be directly linked to. To create a link simply click on the Edit Link button and add the link name after a hash</p>
	<p><img src="<?php get_bloginfo( 'template_url' ) ?>/images/help/anchor-link-example.png" width="392" height="201" alt="screenshot"></p>
	
    <?php
 }
 
 function seja_basic_shortcode_clearfloat_callback($args) { 
    	 
    ?>
	<p><strong style="font-size:1.3em">[clearfloat]</strong><br><span style="font-size:0.9em;color:#a31100;"><em>This shortcode has a quick-use icon</em></span> <img src="<?php get_bloginfo( 'template_url' ) ?>/images/admin/clearfloat.png" width="20" height="20" alt="clearfloat"></p>
	<p>Forces a break after a floating element</p>
	<p>Div and Image elements on a page are often floated to create columns or create a text wrap-around effect. The problem is, sometimes these elements can cause elements below to move up and sit in the wrong place.</p>
	<p>There are two ways to correct this, the easiest being to create a &lt;hr&gt; (Horizontal Rule) tag, however a line across the page is not always the best solution. Using [clearfloat] will create a forced break between the floating element and the content below</p>
	<p>Note: This can also be achieved with a 100% div block (see Dropdown Options on the <a href="<?php get_bloginfo( 'url' ) ?>/wp-admin/admin.php?page=seja-help-page&tab=framework-elements">Custom Framework Elements</a> page</p>
	
    <?php
 }
 
 function seja_basic_shortcode_separator_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[separator]</strong></p>
	<p>An alternative to the &lt;hr&gt; tag <span style="font-size:0.9em">(This may not be styled on your theme)</span></p>
	<p>This shortcode is used when your theme's design requires a graphical element in place of the standard &lt;hr&gt; tag</p>
	
    <?php
 }
 
 function seja_basic_shortcode_facebookone_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[facebook]</strong><br><span style="font-size:0.9em;color:#a31100;"><em>This shortcode has a quick-use icon</em></span> <img src="<?php get_bloginfo( 'template_url' ) ?>/images/admin/facebook.png" width="20" height="20" alt="clearfloat"></p>
	<p>Adds the Facebook "Like" button to the page</p>
	
    <?php
 }
 
 function seja_basic_shortcode_facebooktwo_callback($args) { 
    	 
    ?>
	<p><strong style="font-size:1.3em">[facebookfeed]</strong></p>
	<p>Inserts the Facebook News Feed into a post or page. The feed needs to be configured prior to use in the <a href="<?php get_bloginfo( 'url' ) ?>/wp-admin/admin.php?page=seja-social-settings&tab=facebook">Social Media</a> section
	
    <?php
 }
 
 function seja_basic_shortcode_google_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[googleplusone]</strong></p>
	<p>Adds the Google + one button to the page</p>

	<?php
 }
 
 function seja_basic_shortcode_twitter_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[twitter]</strong></p>
	<p>Embed your Twitter feed on the page. The feed needs to be configured prior to use in the <a href="<?php get_bloginfo( 'url' ) ?>/wp-admin/admin.php?page=seja-social-settings&tab=twitter">Social Media</a> section
	
    <?php
 }
 
 function seja_basic_shortcode_youtube_callback($args) { 
    	 
    ?>
	<p><strong style="font-size:1.3em">[youtube]</strong><br><span style="font-size:0.9em;color:#a31100;"><em>This shortcode has a quick-use icon</em></span> <img src="<?php get_bloginfo( 'template_url' ) ?>/images/admin/youtube.png" width="20" height="20" alt="clearfloat"></p>
	<p><em>Note: WordPress now supports direct embedding of media simply by pasting the URL into the editor however this shortcode allows a little more control over settings.</em></p>
	<p><img src="<?php get_bloginfo( 'template_url' ) ?>'/images/help/anchor-link-youtube.png" width="703" height="220" alt="screenshot" /></p>
	<p>Adding a YouTube URL to the dialogue box will add it to the shortcode call. Default height and width options can be configured in the <a href="<?php get_bloginfo( 'url' ) ?>/wp-admin/admin.php?page=seja-social-settings&tab=youtube">Social Media</a> section
	<p><strong>Extended Use</strong><br>
	While the settings page will set the standard default size, each video can be adjusted to suit the needs of the page. Simply add the additional calls within the square brackets<br>
	<strong>title</strong> Adds a title to the frame above the video.<br>
	<strong>rel</strong> Toggle related videos (rel=1 to show rel=0 to hide)<br>
	<strong>height</strong> and <strong>width</strong> are used to set height and width of the video<br>
	<strong>Example</strong><br>
	[youtube video=xxxxxxxxxxx rel=1 width=415 height=337]</p>
	
    <?php
 }

 function seja_basic_shortcode_pagewidget_callback($args) {
	 
	?>
    <p><strong style="font-size:1.3em">[pagewidget]</strong></p>
    <p>Need to add a shopping cart onto your page? Perhaps a custom login button or search-bar?</p>
    <p>[pagewidget] allows you to use widgitized content on a page.</p>
    <pre>[pagewidget widget_name="X"]</pre>
    <h3>Widget names</h3>
    <p>This is a list of active widgets on your site.</p>
    
    <?php $widgets = array_keys( $GLOBALS['wp_widget_factory']->widgets );
   // print '<pre>$widgets = ' . esc_html( var_export( $widgets, TRUE ) ) . '</pre>';
   echo ( '<ol>' );
   foreach ( $widgets as $var) {
	   echo ( '<li>' . $var . '</li>' );
   }
   echo ( '</ul>' );
   //print_r ( $widgets );
    
 }
 

?>