<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * 4.2 - Advanced Shortcode
 * ------------------------------------------------------------------------ */
 
 function seja_advanced_shortcode_accordion_callback($args) { 
    	 
    ?>
    <p><strong style="font-size:1.3em">[accordion]</strong></p>
	<p><a href="http://www.presshost.com.au/2016/02/accordion-pages/">An example of this feature can be viewed here</a></p>
	<p>The accordion requires content to be correctly nested in a definition list and is rendered using jQuery. It is also important to correctly class the first and last item or the shortcode will not correctly render the list and the desired results will not be achieved.</p>
	
	<h3>Understanding the Definition List</h3>
	<p>This shortcode ouputs the following:</p>
	<pre>&lt;dl id=&quot;accordion&quot; class=&quot;accordion&gt;<br>&lt;dt&gt;This is the visible title block&lt;/dt&gt;<br>&lt;dd&gt;This is the text that is hidden from view until you click on the title block&lt;/dd&gt;<br>&lt;/dl&gt;</pre>
	
	<h3>Basic Use</h3>
	<p>At its simplist the accordion call needs a minimum of a title and wrapped content</p>
	<pre><strong><span style="color:#a31100;">[accordion title="This is the visible title block"]</span></strong>This is the text that is hidden from view until you click on the title block<strong><span style="color:#a31100;">[/accordion]</span></strong></pre>
	<p>Note the way that the content is wrapped by the shortcode. This is a different method to most other shortcode calls and allows for full html content to be parsed by the shortcode.</p>
	<p>It is important for the first and the last block to be marked within the class variable. Failing to do this will break the html structure and the accordion will not work. <br>An example of a three section accordion follows to demonstrate</p>
	<pre><strong>[accordion title="First Title" <span style="color:#a31100;">class="first" name="my-accordion"</span>]</strong>This is my first block of text. The first block also accepts a name variable which can be used to target formatting in the stylesheet.<strong>[/accordion]</strong><br>
	<strong>[accordion title="Second block"]</strong>The second (and any subsequent block other than the final block just requires the basic elements<strong>[/accordion]</strong><br>
	<strong>[accordion title="This is the final block" <span style="color:#a31100;">class="last"</span>]</strong>The final block also closes the accordion &lt;dl&gt; tag. <strong>[/accordion]</strong></pre>
	
	<h3>Additional variables</h3>
	<pre><strong>{accordion title="example" <span style="color:#a31100;">titleclass="some-class" class="another-class"</span>]</strong>block text here<strong>[/accordion]</strong></pre>
	<p>You can call <strong>titleclass</strong> in any accordion call. This allows you to create a custom class within the &lt;dt&gt; tag for formatting within the stylesheet.<br>By default all &lt;dd&gt; contain the class <strong>"block"</strong> however you can change that to a different class if required, however the first and last blocks must always use the <strong>"first"</strong> and <strong>"last"</strong> class calls otherwise the html structure will render incorrectly. </p>
	
    <?php
 }
 
 function seja_advanced_shortcode_post_excerpts_callback($args) { 
    	 
    ?>
	<p><strong style="font-size:1.3em">[post_excerpt]</strong></p>
	<p><strong style="font-size:0.9em;color:#a31100;">Use with caution</strong></p>
	<p>This shortcode embeds a number of posts <strong>within a widget</strong>. You can configure the number of posts you wish to see by adding it into the shortcode call
	<p><strong>Usage</strong><br>
	[post_excerpt number="3"]</p>
	<p>Not adding a number call will return the latest post only.</p>
	<p><strong style="font-size:0.9em;color:#a31100;">This cannot be placed within a page or in any element that is rendered before the page loop is run or it will duplicate or cause the page to break.</strong></p>
	
    <?php
 }
 
 function seja_advanced_shortcode_inline_menu_callback($args) { 
    	 
    ?>
	<p><strong style="font-size:1.3em">[inlinemenu]</strong></p>
	<p>Inline menu allows you to create a menu within normal text. It works in the same way as the Custom Menu Widget but can be added into the content of the page.</p>
	<p>Another application is if you require different sidebar menu\'s depending on the page. The shortcode can be added to the <strong>Custom Sidebar Text</strong> to achieve this result</p>
	<h3>Usage</h3>
	<p>First create a custom menu within the <a href="<?php get_bloginfo( 'url' ) ?>/wp-admin/nav-menus.php">nav-menu</a> page and give it a unique title. This title will be used in the shortcode to link the menu.</p>
	<pre>[inlinemenu menu="title of the menu"]</pre>
	<p>This shortcode will accept all parameters that can be parsed through the wp_nav_menu() function except the theme_location parameter. For more details, please read the <a href="https://codex.wordpress.org/Function_Reference/wp_nav_menu">WordPress Codex</a> on this subject</p>
	<p>By default, the following parameters are set</p>
	<pre>menu_class => \'menu\'<br>echo => \'true\'<br>fallback_cb => \'wp_page_menu\'<br>depth => \'0\'</pre>
	
    <?php
	
 }
 
 function seja_advanced_shortcode_html_callback($args) { 
    	 
	?>
    <p><strong style="font-size:1.3em">[include_html]</strong></p>
	<p>If you need to deal with complex formatting within the page, or you need to create a page that needs its own custom scripting the limitations in the WordPress editor make this difficult. To get around this you can create a custom file and link it to your page.	</p>
	<p><strong>Important</strong><br />
    For security purposes you cannot link to files outside this folder and it is recommended you create a new file rather than use the existing 'index.php' file that sits in the directory. You should also upload the new file first to avoid any 'file not found' errors.</p>
	<h3>Usage	</h3>
	<p>Create a new file and upload it to the <a href="<?php bloginfo( 'template_url' ) ?>/custom/html">custom/html/</a> folder <em>(e.g. foo.php)</em></p>
	<pre>[include_html url=&quot;foo.php&quot;]</pre>
	
    <?php
 }

?>