<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * This is the layout function that formats all pages
 * ------------------------------------------------------------------------ */
 
 if ( ! defined( 'ABSPATH' ) ) { exit; }
 
/* ------------------------------------------------------------------------ * 
 * pre_footer
 * ------------------------------------------------------------------------ */
  	function seja_pre_footer() {
		echo '<div style="clear:both"></div>';
		if ( SEJA_TOPLINK == 1 ) :
			echo '<div id="back-to-top"><a href="#top" class="hashlink">Top</a></div>';
		endif;
	}

/* ------------------------------------------------------------------------ * 
 * seja_Layout (the main structure file
 * ------------------------------------------------------------------------ */
	
function seja_layout( $args = array () ) {
	$defaults = array( 'type' => '', 'uri' => '', 'class' => '', 'id' => '', 'option' => '' );
	$args = wp_parse_args( $args, $defaults );
				
// header = creates the header div		
	if( $args['type'] == 'header' ) :

		$output = '<div class="';
		if ( !empty ( $args['class'] ) ) :
			$output .= $args['class'];
		else : 
			$output .= 'inner-wrapper';
		endif;
		//$output .= ' seja-headertype-' . SEJA_HEADER_IMAGE_OPTION . '"'; // depreciated version (updated line below)
		$output .= '"'; 
		if (!empty ( $args['id'] ) ) 
			$output .= ' id="' . $args['id'] . '"';
		$output .= '>';
	endif;
	
// logo = creates the logo block
	if( $args['type'] == 'logo' ) :
		if ( !empty ( $args['class'] ) ) $class .= ' ' . $args['class'];
			
		$output = '<div class="header-img ' . $class . '">';
		$output .= '<a href="' . get_bloginfo( 'url' ) . '">';
		if( $args[ 'option' ] != '' ) :
			$output .= '<h2 class="branding">' . $args[ 'option' ] . '</h2>';
		else:
			$output .= '<img src="' . SEJA_LOGO_URL . '" width="' . SEJA_LOGO_WIDTH . '" height="' . SEJA_LOGO_HEIGHT . '" alt="logo" class="seja-theme-logo">';
		endif;
		$output .= '</a>';
		$output .= '</div><!-- .header-img -->';
		
	endif;
		
// widget = header contact widget block
	if( $args['type'] == 'hwidget' ) : 
		echo '<div class="header-contact';
		if( !empty( $args['class'] ) ) echo ' ' . $args['class'];
		if( !empty( $args['id'] ) ) echo '" id="' . $args['id'];
		echo '">';

		if ( is_active_sidebar( 'header-widget-area' ) ) :
			echo '<div class="widget-area"><ul class="xoxo no-bullet">';
				dynamic_sidebar( 'header-widget-area' ); 
			echo '</ul></div>'; 
		endif;
		echo '</div>';
	endif;
		
// navigation = primary navigation or walker navigation 
	if( ( $args['type'] == 'navigation' ) || ( $args['type'] == 'walker' ) ) :
		$nav_type = $args['type'];
		include ( get_template_directory() . '/includes/structure/header/navigation.php' );
	endif;
			
// content = closes header and starts content block
	if( $args['type'] == 'content' ) :
			
		$output = '</div><!-- .inner-wrapper (header block) -->';
		$output .= '</div><!-- .outer-wrapper (header block) -->';
		$output .= '<div id="content-shell">';  // i want to rename this section
		
	endif;
		
// top content = top content area
	if( $args['type'] == 'top-content' ) :		
		if ( get_post_meta($args['option'], 'seja_customfield_sidebar_text_1', true) ) : 
			echo '<div id="top-content-block"';
			if( !empty( $args['class'] ) )
				echo ' class="' . $args['class'] . '"';
			echo '>';
			echo do_shortcode(get_post_meta($args['option'], 'seja_customfield_sidebar_text_1', true) );
			echo '</div>';
		endif;			
	endif;
		
// main content - start of content
	if( $args['type'] == 'spage' ) : 
		
		$output = '<div id="content" class="inner-wrapper">';
		if ( ( $args['option'] == 'single' ) || ( $args['option'] == '' ) ) :
			$output .= '<div class="single-column">';
		else :
			$output .= '<div class="colmask two-' . $args['option'] . '-' . SEJA_COLUMN_WIDTH . '">'; 
				$output .= '<div class="colmid"><div class="colleft"><div class="col1">';
		endif;
	endif;
// main content - end of content		
	if( $args['type'] == 'epage' ) :	  
		if ( $args['option'] != '' ) :
			echo '</div><!-- end col --><div class="col2">';
				get_sidebar( $args['option'] );
			echo'</div><!-- end col 2 --></div><!--.colleft--></div><!-- .colmid-->
</div><!--.colmask-->';
		else:
			echo '</div><!-- end col -->';
		endif;
		seja_pre_footer();
		echo '</div><!-- .content -->';
	endif;
	
// start of footer		
	if( $args['type'] == 'sfoot' ) :
		echo '</div><!-- end #content-shell-->';
  		echo '<div id="footer-shell">';
   		echo '<div id="footer">';
	endif;

//footer widget area	
	if( $args['type'] == 'fwidget' ):
		$qty = array( 'first', 'second', 'third' );
		if ( ( SEJA_FOOTER_LAYOUT != 'default' ) && ( SEJA_FOOTER_LAYOUT != 'horizontal3' ) )
			array_push( $qty, 'fourth' );
		
		echo '<div id="colophon" class="layout-type-' . SEJA_FOOTER_LAYOUT . '">';
		echo '<div id="footer-widget-area">';
		
		foreach($qty as $item) {
			
			$widget_area = $item . '-footer-widget-area';
			if ( is_active_sidebar( $widget_area ) ) :
			
				echo '<div id="' . $item . '" class="widget-area">';
				echo '<ul class="xoxo">';
				dynamic_sidebar( $widget_area );
				echo '</ul>';
				echo '</div><!-- end #' . $item . ' .widget-area -->';
			endif;
		}
		echo '</div>';
		echo '<div class="clear"></div>';
        echo '</div><!-- end #colophon -->';
		
				
	endif;	
	
// copyright
	if(	$args['type'] == 'copyright' ) :
		echo '<div id="copyright-wrapper">';
		echo '<div class="site-info">';
		echo '<a href="' . home_url( '/' ) . '" title="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '" rel="home"> &copy; ' . (date( 'Y' ) ) . bloginfo( 'name' ) . '</a>';
		echo '</div><!-- end #site-info -->';
		echo '<div class="copyright"><a href="http://wordpress.org/" title="Semantic Personal Publishing Platform"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15"><path class="seja-svg" d="M11.1 2.7c0.2 0.2 0.4 0.3 0.6 0.5 -0.2 0-0.4 0-0.6 0.1V2.7L11.1 2.7zM11.1 5.6C11.5 6.3 12 7.2 11.4 9L11.1 10V5.6L11.1 5.6zM11.1 14c2.2-1.3 3.6-3.6 3.6-6.3s-1.5-5-3.6-6.3V2c1.9 1.2 3.2 3.4 3.2 5.8 0 2.4-1.3 4.6-3.2 5.8V14L11.1 14zM11.1 12.8c1.6-1.1 2.6-3 2.6-5.1 0-1.1-0.3-2.1-0.7-3l0 0c0 0.9-0.2 2.1-0.5 2.9l-1.3 3.8V12.8zM7.6 1.5c1.3 0 2.5 0.4 3.5 1.1v0.6c-0.3 0.2-0.5 0.5-0.5 0.9 0 0.6 0.2 1 0.5 1.4V10l-0.5 1.6L8.4 5c0-0.1 0-0.2 0.1-0.2h0.6c0 0 0.1 0 0.1-0.1V4.4c0 0 0-0.1-0.1-0.1 -0.5 0-1 0-1.5 0V1.5L7.6 1.5zM11.1 1.5c-1-0.6-2.2-0.9-3.5-1v0.4c1.3 0 2.5 0.4 3.5 1V1.5L11.1 1.5zM11.1 11.5l-0.6 1.7c0.2-0.1 0.4-0.2 0.6-0.4V11.5L11.1 11.5zM11.1 13.5V14c-1 0.6-2.2 0.9-3.5 1v-0.4C8.9 14.5 10.1 14.2 11.1 13.5L11.1 13.5zM7.6 14c0.7 0 1.3-0.1 2-0.4l0 0 -2-5.3V14zM7.5 1.5c0 0 0.1 0 0.1 0v2.8c-0.7 0-1.4 0-2.1 0 0 0-0.1 0-0.1 0.1v0.4c0 0 0 0.1 0.1 0.1h0.6c0.1 0 0.2 0 0.2 0.1l0.9 2.5L6 11.6 3.7 4.9c0-0.1 0-0.1 0.1-0.1h0.7c0 0 0.1 0 0.1-0.1V4.4c0 0 0-0.1-0.1-0.1 -0.3 0-0.6 0-0.9 0V2.9C4.6 2 6 1.5 7.5 1.5L7.5 1.5 7.5 1.5zM7.6 0.5c0 0-0.1 0-0.1 0l0 0C6 0.5 4.7 0.9 3.5 1.7v0.5C4.7 1.4 6 0.9 7.5 0.9l0 0c0 0 0.1 0 0.1 0V0.5L7.6 0.5zM7.6 8.3L7.6 8.3l-1.9 5.4C6.3 13.9 6.9 14 7.5 14c0 0 0.1 0 0.1 0V8.3L7.6 8.3zM7.6 14.6V15c0 0-0.1 0-0.1 0 -1.5 0-2.8-0.4-3.9-1.2v-0.5c1.1 0.8 2.5 1.3 3.9 1.3C7.5 14.6 7.6 14.6 7.6 14.6L7.6 14.6zM3.5 12.6c0.4 0.3 0.8 0.6 1.3 0.8l0 0L3.5 9.9V12.6zM3.5 4.3c-0.4 0-0.9 0-1.3 0 0.4-0.5 0.8-1 1.3-1.4V4.3L3.5 4.3zM3.5 1.7C1.6 3 0.3 5.2 0.3 7.7c0 2.5 1.3 4.8 3.3 6.1v-0.5C1.8 12.1 0.7 10 0.7 7.7c0-2.3 1.1-4.3 2.9-5.6V1.7L3.5 1.7zM3.5 9.9v2.7c-1.4-1.1-2.3-2.9-2.3-4.8 0-0.9 0.2-1.8 0.6-2.6L3.5 9.9z"/></svg> WordPress</a>, template by <a href="https://www.seja-design.com.au/" title="WordPress Design Perth | Wordpress Perth"><svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 15 15"><path class="seja-svg" d="M12.7 9.3c0 5.6-13.7 5.5-8.7 5.5 6.1 0 10.8-2.5 10.8-5.6 0-3.2-7.1-5.6-13.2-5.6C-4 3.6 12.7 3.3 12.7 9.3z"/><path class="seja-svg" d="M0.3 13.3l2.1-1.4c0.1 0.3 0.5 0.6 1 0.8C3.9 12.9 4.4 13 5 13c0.4 0 0.8-0.1 1.1-0.2 0.3-0.1 0.5-0.3 0.5-0.5l0.1-0.4c0-0.6-1-1.1-3-1.3 -2-0.2-3-0.5-3-0.9 0-0.1 0.1-0.2 0.1-0.4C1 9.2 1 9 1.2 8.7c0.3-0.6 0.9-1.1 2-1.8 1.1-0.6 2.2-1 3.5-1 1.1 0 2.1 0.2 3 0.6L7.5 8C7.3 7.7 6.8 7.5 6.2 7.3 5.6 7.2 5 7.1 4.5 7.1c-0.4 0-0.7 0-1 0.1C3.2 7.3 3.1 7.5 3.1 7.7c0 0.6 1.1 1.1 3.3 1.5 2.2 0.3 3.3 0.9 3.3 1.6 0 0.5-0.8 1.1-2.4 2C5.8 13.6 4.3 14 2.8 14c-0.5 0-1 0-1.4-0.1C1.1 13.8 0.7 13.6 0.3 13.3z"/></svg> Seja Design</a></div>
        </div><!-- end #copyright-wrapper -->';
		
	endif;
	
// end of footer
	if( $args['type'] == 'efoot' ) :
		echo '</div><!-- #footer -->';
		echo '</div><!-- #footer-shell -->';
		wp_footer();
		echo '</body>';
		echo '</html><!-- end of seja framework page -->';
	endif;
		
	echo $output; 
}

/* ------------------------------------------------------------------------ * 
 * Post Excerpts Length
 * ------------------------------------------------------------------------ */

	function seja_excerpt_length( $length ) {
		return SEJA_EXCERPT_LENGTH;
	}
	add_filter( 'excerpt_length', 'seja_excerpt_length', 999 );
	
/* ------------------------------------------------------------------------ * 
 * Post Excerpts Continue Reading
 * ------------------------------------------------------------------------ */	
	
	function seja_continue_reading() {
		return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <i class="far fa-hand-point-right"></i>', 'seja_framework' ) . '</a>';
	}
	
	function seja_excerpt_more( $more ) {
		return ' &hellip;' . seja_continue_reading();
	}
	add_filter( 'excerpt_more', 'seja_excerpt_more' );
	
/* ------------------------------------------------------------------------ * 
 * Post Excerpts // this one may be history
 * ------------------------------------------------------------------------ */		
	
	function seja_custom_excerpt_more( $output ) {
		if ( has_excerpt() && ! is_attachment() ) {
			$output .= seja_continue_reading();
		}
		return $output;
	}
	add_filter( 'get_the_excerpt', 'seja_custom_excerpt_more' );
	
/* ------------------------------------------------------------------------ * 
 * Post meta HTML
 * ------------------------------------------------------------------------ */
 
 /* Part 1 - Posted On (the top entry-meta) */
 
 	if ( ! function_exists( 'seja_excerpt_posted_on' ) ) :
	
	function seja_excerpt_posted_on() {
		printf( __( '<span class="%1$s">%2$s</span>', 'twentyten' ),
		//printf( __( '<span class="%1$s">Posted on</span> %2$s <span class="meta-sep">by</span> %3$s', 'twentyten' ), OLD - FOR REFERENCE in posted in
			'meta-prep meta-prep-author entry-date-excerpt',
			sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date"><i class="far fa-calendar-alt"></i> %3$s</span></a>',
				get_permalink(),
				esc_attr( get_the_time() ),
				get_the_date()
			)
		);
	}
		
	endif;
 
	if ( ! function_exists( 'seja_full_posted_on' ) ) :
	
	function seja_full_posted_on() {
		printf( __( '<span class="%1$s">Posted on</span> %2$s <span class="meta-sep">by</span> %3$s', 'twentyten' ),
			'meta-prep meta-prep-author',
			sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span></a>',
				get_permalink(),
				esc_attr( get_the_time() ),
				get_the_date()
			),
			sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
				get_author_posts_url( get_the_author_meta( 'ID' ) ),
				esc_attr( sprintf( __( 'View all posts by %s', 'twentyten' ), get_the_author() ) ),
				get_the_author()
			)
		);
	}
	
	endif;
	
 
 /* Part 2 - Posted In (the bottom meta-utility) */
 	
	if ( ! function_exists( 'seja_full_posted_in' ) ) :

	function seja_full_posted_in() {
		// Retrieves tag list of current post, separated by commas.
		$tag_list = get_the_tag_list( '', ', ' );
		if ( $tag_list ) {
			$posted_in = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'twentyten' );
		} elseif ( is_object_in_taxonomy( get_post_type(), 'category' ) ) {
			$posted_in = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'twentyten' );
		} else {
			$posted_in = __( 'Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'twentyten' );
		}
		// Prints the string, replacing the placeholders.
		printf(
			$posted_in,
			get_the_category_list( ', ' ),
			$tag_list,
			get_permalink(),
			the_title_attribute( 'echo=0' )
		);
	}
	endif;
	
/* ------------------------------------------------------------------------ * 
 * Insert content within post (i.e. advertising)
 * ------------------------------------------------------------------------ */


if( SEJA_ADVERTISING !== '0' ) :
	add_filter ('the_content', 'seja_insert_advertising');
endif;

function seja_insert_advertising($content) {
	
	if( is_single() || ( is_page() && SEJA_ADVERTISING == '2')  ) :
		
		// extract ad code from file
		$ad_code = file_get_contents( get_template_directory() . '/custom/templates/advertising.php' );
		
		// abandon if we've disabled advertising in this post
		if( get_post_meta($GLOBALS['current_id'], 'seja_customfield_advertising', true ) == 'yes' ) :
			return $content;
			
		// min length is zero, so we're going to display the ad at the end
		elseif( SEJA_ADVERTISING_MINLENGTH == '0' ) : // and blah blah seja customfield advertising !== yes
			return $content . $ad_code;
		
		else :
			
			// if the content is not too short, break the content and display the ad
			if (strlen($content) > SEJA_ADVERTISING_MINLENGTH ) :
				
				// avoid putting the ad too close to the start
				$part_a = substr($content, 0, SEJA_ADVERTISING_MINLENGTH ); 
				$part_b = substr($content, SEJA_ADVERTISING_MINLENGTH );
				
				
				
				// find our first closing paragraph (or div, table or list) failing back to any closing tag and finally a line break
				if( strpos( $part_b, '</p>' ) !== false ) :
					$pos = strpos( $part_b, '</p>' );
					$adj = 4;
				elseif( strpos( $part_b, '</div>' ) !== false ) :
					$pos = strpos( $part_b, '</div>' );
					$adj = 6;
				elseif( strpos( $part_b, '</table>' ) !== false ) :
					$pos = strpos( $part_b, '</table>' );
					$adj = 8;
				elseif( strpos( $part_b, '</ul>' ) !== false ) :
					$pos = strpos( $part_b, '</ul>' );
					$adj = 5;
				elseif( strpos( $part_b, '</ol>' ) !== false ) :
					$pos = strpos( $part_b, '</ol>' );
					$adj = 5;
				elseif( strpos( $part_b, '>' ) !== false ) :
					$pos = strpos( $part_b, '>' );
					$adj = 1;
				else :
					$pos = strpos( $part_b, "\n\n" );
				endif;
				// and insert the ad code
				$content = $part_a . substr( $part_b, 0, $pos + $adj ) . $ad_code . substr($part_b, $pos + $adj );
		  
			endif;
		endif;		 
   endif;
   return $content;
}