<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * General Functions file
 * ------------------------------------------------------------------------ */
 
 if ( ! defined( 'ABSPATH' ) ) { exit; }
 
 /* ------------------------------------------------------------------------ * 
 * Seja Theme Setup - SOF
 * ------------------------------------------------------------------------ */
	add_action( 'after_setup_theme', 'sejaframework_setup' );
	if ( ! function_exists( 'sejaframework_setup' ) ):
		function sejaframework_setup() {

	/* ------------------------------------------------------------------------ * 
	 * Theme Setup - GENERAL SETTINGS
	 * ------------------------------------------------------------------------ */
		add_editor_style();
		add_theme_support( 'post-formats', array( 'aside', 'gallery' ) );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		//add_theme_support( 'html5', array( 'search-form' ) ); THIS APPEARS TO BE BREATKING THE LAYOUT
	/* ------------------------------------------------------------------------ * 
	 * Theme Setup - MENU REGISTRATION
	 * ------------------------------------------------------------------------ */
		
		if( SEJA_MOBILE_MENU == 1 ) : 
			register_nav_menus( array( 'primary' => 'Primary Navigation', 'mobile'  => 'Mobile Navigation', ) );
		else:  
			register_nav_menus( array( 'primary' => 'Primary Navigation' ) );
		endif;

		} // END OF SETUP FUNCTION
	endif;
	

/* ------------------------------------------------------------------------ * 
 * Theme Title - Overwrites the default title if set within the custom fields 
 *               (works on pages only)
 * ------------------------------------------------------------------------ */	
 	
	function seja_the_title( $url, $h_size='h1' ) {
		// firstly, if the overwritten title is a non-breaking space we won't return a title at all.
		if( $url != '&nbsp;' ) :
			// now check to see if we have a custom title
			if(!empty( $url ) ) : 
				$output = $url;
			// if not, use the default title
			else :
				$output = get_the_title();
			endif;
			// some custom classes to target css
			if ( is_front_page() ) :
				$pagetype = 'frontpage';
			else :
				$pagetype = 'otherpage';
			endif;
			// now return the title
			echo '<' . $h_size . ' class="entry-title seja-loop-page-' . $pagetype . 'page">' . $output . '</' . $h_size . '>';
		endif;
	}
 /* ------------------------------------------------------------------------ * 
 *  Gallery Style 
 * ------------------------------------------------------------------------ */
 
 	add_filter( 'use_default_gallery_style', '__return_false' );

/* ------------------------------------------------------------------------ * 
 * Script Registrations 
 * ------------------------------------------------------------------------ */
 
 function seja_framework_register_scripts() {

	wp_register_script( 'seja_jq', get_template_directory_uri() . '/js/seja-framework.js', 'jquery' );
	wp_register_script( 'seja_res', get_template_directory_uri() . '/js/seja-responsive-menu.js', 'jquery' );
	wp_register_script( 'seja_mos', get_template_directory_uri() . '/js/mosaic.1.0.1.min.js', 'jquery' );
	
	wp_enqueue_script('jquery');
	wp_enqueue_script('seja_mos'); // should this be enabled by default?
	wp_enqueue_script('seja_jq');
	if ( SEJA_WOO_SUPPORT == '1' ) wp_enqueue_script('seja_woo_jq');
	if ( SEJA_RESPONSIVE_MENU != 1 ) wp_enqueue_script('seja_res');
 }
 
 add_action ( 'wp_enqueue_scripts', 'seja_framework_register_scripts' );

/* ------------------------------------------------------------------------ * 
 * Style Registrations 
 * ------------------------------------------------------------------------ */
 	
	function register_formatting_css() {
		// this is separate because it's designed to load (as close to) last
		$formatting_css = get_template_directory_uri() . '/custom/css/theme-style.css';
		wp_enqueue_style( 'formatting', $formatting_css, __FILE__);
	}
	add_action('wp_enqueue_scripts', 'register_formatting_css', 50);
	
	function seja_admin_css() {
        wp_register_style( 'font_awesome_css', get_template_directory_uri() . '/css/font-awesome.css', false, '5.0.13' );
		wp_register_style( 'admin_styles_css', get_template_directory_uri() . '/css/admin-styles.css', false, '2.16' );
        wp_enqueue_style ( 'admin_styles_css' );
		wp_enqueue_style ( 'font_awesome_css' );
		wp_enqueue_script( 'jquery-ui-accordion' );
	}
	add_action( 'admin_enqueue_scripts', 'seja_admin_css' );
		
	if( SEJA_DEBUG_MODE == '1' ) :
	
		$debug_css = get_template_directory_uri() . '/css/debug.css';
		wp_enqueue_style( 'debug', $debug_css, __FILE__);
		
	endif;
/* ------------------------------------------------------------------------ * 
 * Get first image for post thumbnail
 * ------------------------------------------------------------------------ */

	function seja_thumbnail_excerpt() {
		
		global $post, $posts;
		$seja_first_img = '';
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		$seja_first_img = $matches [1] [0];
	
		if(empty($seja_first_img)){ //Defines a default image
			$seja_first_img = get_bloginfo( 'template_url' ) . '/images/no-image.svg';
		}
		
		return '<img src="' . $seja_first_img . '" width="150" height="150">';
	} 
	
 
/* ------------------------------------------------------------------------ * 
 * Theme Customisations - EOS
 * ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ * 
* // Google Sitemap
* ------------------------------------------------------------------------ */

add_action("save_post", "seja_create_sitemap");

function seja_create_sitemap() {
	$postsForSitemap = get_posts(array(
		'numberposts' => -1,
		'orderby' => 'modified',
		'post_type'  => array('post','page'),
		'order'    => 'DESC'
	));

	$sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
	$sitemap .= "\n".'<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'."\n";

	foreach($postsForSitemap as $post) {
		setup_postdata($post);

		$postdate = explode(" ", $post->post_modified);

		$sitemap .= "\t".'<url>'."\n".
		"\t\t".'<loc>'. get_permalink($post->ID) .'</loc>'.
		"\n\t\t".'<lastmod>'. $postdate[0] .'</lastmod>'.
		"\n\t\t".'<changefreq>monthly</changefreq>'.
		"\n\t".'</url>'."\n";
	}

	$sitemap .= '</urlset>';
	
	$fp = fopen(ABSPATH . "sitemap.xml", 'w');
	fwrite($fp, $sitemap);
	fclose($fp);
}

/* ------------------------------------------------------------------------ * 
 * Widgets - WIDGET FILTERS
 * ------------------------------------------------------------------------ */
add_filter( 'widget_text', 'shortcode_unautop');
add_filter( 'widget_text', 'do_shortcode');

/* ------------------------------------------------------------------------ * 
 * Widgets - WIDGET AREA REGISTRATION
 * ------------------------------------------------------------------------ */
function seja_widgets_init() {

	// Widget Area - HEADER
	register_sidebar( array(
		'name' => __( 'Header Contact', 'seja_framework' ),
		'id' => 'header-widget-area',
		'description' => 'Enable the default header layout (or call the contact block in a custom header) to use this widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Widget Area - PAGE
	register_sidebar( array(
		'name' => __( 'Page Sidebar', 'seja_framework' ),
		'id' => 'page-widget-area',
		'description' => 'Use this Widget area for sidebars on Pages',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// SWidget Area - POST
	register_sidebar( array(
		'name' => __( 'Post Sidebar', 'seja_framework' ),
		'id' => 'post-widget-area',
		'description' => 'Use this Widget area for sidebars on Posts',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	if ( SEJA_WOO_SUPPORT == '1' ):
	
	// Widget Area - WOOCOMMERCE
	register_sidebar( array(
		'name' => __( 'Shop Sidebar', 'seja_framework' ),
		'id' => 'shop-widget-area',
		'description' => 'Add your WooCommerce widgets here',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	endif;

	// Widget Area - FOOTER 1
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', 'seja_framework' ),
		'id' => 'first-footer-widget-area',
		'description' => 'The first footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Widget Area - FOOTER 2
	register_sidebar( array(
		'name' => __( 'Second Footer Widget Area', 'seja_framework' ),
		'id' => 'second-footer-widget-area',
		'description' => 'The second footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	// Widget Area - FOOTER 3
	register_sidebar( array(
		'name' => __( 'Third Footer Widget Area', 'seja_framework' ),
		'id' => 'third-footer-widget-area',
		'description' => 'The third footer widget area',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	// Widget Area - FOOTER 4
	register_sidebar( array(
		'name' => __( 'Fourth Footer Widget Area', 'seja_framework' ),
		'id' => 'fourth-footer-widget-area',
		'description' => 'The fourth footer widget area (You must have a four widget footer layout enabled for this widget area to display)',
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}

add_action( 'widgets_init', 'seja_widgets_init' );

/* ------------------------------------------------------------------------ * 
 * Widgets - Sidebar Widget
 * ------------------------------------------------------------------------ */
class seja_sidebar_text extends WP_Widget {
	
	function seja_sidebar_text() {
		// Instantiate the parent object
		parent::__construct( false, 'Sidebar Text' );
	}
	function widget( $args, $instance ) {
		// Widget output
		echo '<li><div id="side-block-text">';
		echo do_shortcode(get_post_meta($GLOBALS['current_id'], 'seja_customfield_sidebar_text_2', true));
		echo '</div></li>';
	}
	function update( $new_instance, $old_instance ) {
		// Save widget options
	}
	function form( $instance ) {
		// Output admin widget options form
	}
}
/* ------------------------------------------------------------------------ * 
 * Widgets - Simple Meta
 * ------------------------------------------------------------------------ */
class seja_simplemeta extends WP_Widget {

	function seja_simplemeta() {
		// Instantiate the parent object
		parent::__construct( false, 'Simple Meta' );
	}
	function widget( $args, $instance ) {
		// Widget output
		echo '<ul class="seja-simple-meta">';
		echo wp_register();
		echo '<li>';
		echo wp_loginout();
		echo '</li></ul>';
		echo '</li>';
	}
	function update( $new_instance, $old_instance ) {
		// Save widget options
	}
	function form( $instance ) {
		// Output admin widget options form
	}
}
/* ------------------------------------------------------------------------ * 
 * Widgets - Register Widgets
 * ----------------------------------------------------------------------- */
 
function seja_register_widgets() {
	register_widget( 'seja_simplemeta' );
	register_widget( 'seja_sidebar_text' );
}
add_action( 'widgets_init', 'seja_register_widgets' );


/* ------------------------------------------------------------------------ * 
 * Widgets - Social Media Footer Widget
 * ------------------------------------------------------------------------ */
 
 // No - this should end up as a plugin

/* ------------------------------------------------------------------------ * 
 * Widgets - END OF SECTION
 * ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ * 
 * Formatting - Meta Description
 * ------------------------------------------------------------------------ */ 
 
	function seja_meta_description ( $var ) {
		
		if ( SEJA_SEO_OVERRIDE != '1' ) :
		
			echo '<meta name="description" content="';

			if( !empty ( get_post_meta( $var, 'seja_customfield_meta_description', true ) ) ) : 
				$return = get_post_meta( $var, 'seja_customfield_meta_description', true ); 
			else :
				if ( (is_home()) || (is_front_page()) ) :
					$return = 'Welcome to ' . get_bloginfo( 'name' ) . ', ' . get_bloginfo( 'description' );
				elseif ( is_category() ) :
					$return = category_description();
				elseif ( is_tag() ) :
					$return = '-tag archive page for this blog' . single_tag_title();
				elseif (is_month() ) :
					$return = 'archive page for this blog' . the_time('F, Y');
				else :
					$return = get_bloginfo( 'description' ) . ' | ' . get_the_title();
				endif;			
			endif; 

			echo $return . '">' . "\n";
		endif;
	}

/* ------------------------------------------------------------------------ * 
 * Formatting - Meta Keywords
 * ------------------------------------------------------------------------ */
 	
	function seja_meta_keywords( $var ) {
		
		if ( SEJA_SEO_OVERRIDE != '1' ) :
		
			if( !empty ( get_post_meta( $var, "seja_customfield_meta_keywords", true) ) )
				echo '<meta name="keywords" content="' . get_post_meta( $var, "seja_customfield_meta_keywords", true) . '">' . "\n";
			
		endif;
	}
 
/* ------------------------------------------------------------------------ * 
 * Formatting - Meta Author 
 * ------------------------------------------------------------------------ */ 
 
 	function seja_meta_author() {
		
		$html = '';
	
		if ( SEJA_GOOGLEPLUS_URL != '' ) /* and SEJA_SEO_OVERRIDE !== 1... <-- better option, surely*/ : 
			$html = '<link rel="author" href="' . SEJA_GOOGLEPLUS_URL . '">' . "\n";
			$html .= '<link rel="publisher" href="' . SEJA_GOOGLEPLUS_URL . '">' . "\n";
			$html .= '<link rel="author" href="' . SEJA_GOOGLEPLUS_URL . '">' . "\n";
			$html .= '<link rel="publisher" href="' . SEJA_GOOGLEPLUS_URL . '">' . "\n";
		endif;
			
		if ( SEJA_SEO_OVERRIDE != '1' ) :	
			echo $html;
			
		endif;
		
	}

/* ------------------------------------------------------------------------ * 
 * Formatting - Header Title
 * ------------------------------------------------------------------------ */ 
 
	function seja_header_title( $var ) {
		 
		echo '<title>';
		// custom title  
		if( !empty ( get_post_meta( $var, "seja_customfield_additional_title", true) )) : 
			echo( get_post_meta( $var, "seja_customfield_additional_title", true) ); 
		else :
		// no custom title tag - We'll display the default instead
			// first the page title
			wp_title( '|', true, 'right' );
			// and then the blog name
			bloginfo( 'name' );
			// and the blog description on the home/front page
			$site_description = get_bloginfo( 'description', 'display' );
			if ( $site_description && ( is_home() || is_front_page() ) )
				echo " | $site_description";
			endif; 
		
		echo '</title>';
	}

/* ------------------------------------------------------------------------ * 
 * Formatting - Gallery Zero Column Option
 * ------------------------------------------------------------------------ */
 
	function seja_gallery_zero_columns_script(){
		?>
		<script type="text/javascript">
		jQuery(function(){
			if(wp.media.view.Settings.Gallery){
				wp.media.view.Settings.Gallery = wp.media.view.Settings.extend({
					className: "collection-settings gallery-settings",
					template: wp.media.template("gallery-settings"),
					render:	function() {
						wp.media.View.prototype.render.apply( this, arguments );
						// Append an option for 0 (zero) columns if not already present...
						var $s = this.$('select.columns');
						if(!$s.find('option[value="0"]').length){
							$s.append('<option value="0">0</option>');
						}
						// Select the correct values.
						_( this.model.attributes ).chain().keys().each( this.update, this );
						return this;
					}
				});
			}
		});
		</script><?php
	}
	
	function seja_gallery_zero_columns(){
		add_action( 'admin_print_footer_scripts', 'seja_gallery_zero_columns_script', 999);
	}

	add_action( 'wp_enqueue_media', 'seja_gallery_zero_columns' );

/* ------------------------------------------------------------------------ * 
 * Formatting - Pagination
 * ------------------------------------------------------------------------ */
	function seja_pagination($pages = '', $range = 2) {  
		$showitems = ( $range * 2 ) +1;  
		
		global $paged;
		if( empty( $paged ) ) $paged = 1;
		
		if($pages == '') :
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if(!$pages) $pages = 1; // if there's an error, this if statement was previously wrapped in brackets
		endif;   
			
		if( 1 != $pages ) :
			echo "<div class='pagination'>";
			if( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) echo '<a href="' . get_pagenum_link( 1 ) . '">&laquo;</a>';
			if( $paged > 1 && $showitems < $pages ) echo '<a href="' . get_pagenum_link( $paged - 1 ) . '">&lsaquo;</a>';
		
			for( $i = 1; $i <= $pages; $i++) {
				if( 1 != $pages &&( !( $i >= $paged+$range+1 || $i <= $paged-$range-1 ) || $pages <= $showitems ) ) :
					echo ( $paged == $i )? '<span class="current">' . $i . '</span>':'<a href="' . get_pagenum_link( $i ) . '" class="inactive" >' . $i . '</a>';
				endif;
			}

			if( $paged < $pages && $showitems < $pages ) echo '<a href="' . get_pagenum_link( $paged + 1 ) . '">&rsaquo;</a>';  
			if( $paged < $pages -1 &&  $paged + $range -1 < $pages && $showitems < $pages ) echo '<a href="' . get_pagenum_link( $pages ) . '">&raquo;</a>';
			echo '</div>' . "\n";
		endif;
	}
		
/* ------------------------------------------------------------------------ * 
 * Formatting - Colour picker
 * ------------------------------------------------------------------------ */		

	function seja_admin_color_picker( $hook_suffix ) {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script('seja-admin-js', get_bloginfo('template_url').'/js/seja-admin.js', array('wp-color-picker'));
	}	
	add_action( 'admin_enqueue_scripts', 'seja_admin_color_picker' );

/* ------------------------------------------------------------------------ * 
 * Formatting - Comments (unchanged since the original 2012 derivative)
 * ------------------------------------------------------------------------ */
if ( ! function_exists( 'seja_comment' ) ) :
function seja_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment-block">
		<div class="comment-author vcard"><p class="comment-meta">
			<?php echo get_avatar( $comment, 40 ); ?> On <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'twentyten' ), get_comment_date(),  get_comment_time() ); ?></a> <?php 
				printf( __( '%s <span class="says">said:</span>', 'twentyten' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?> <?php edit_comment_link( __( '(Edit this comment)', 'twentyten' ), ' ' ); ?></p>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'twentyten' ); ?></em>
			<br />
		<?php endif; ?>

		
		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?> 
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'twentyten' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'twentyten' ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif; 

/* ------------------------------------------------------------------------ * 
 * // Formatting - Dashboard Widget 
 * ------------------------------------------------------------------------ */ 

	add_filter('wp_feed_cache_transient_lifetime',create_function('$a', 'return 1200;')); 
	
	add_action( 'wp_dashboard_setup', 'seja_dashboard_setup' );
	function seja_dashboard_setup() {
		add_meta_box( 'seja_dashboard_widget', 'Seja Framework', 'seja_dashboard_widget', 'dashboard', 'side', 'high' );
	}
	function seja_dashboard_widget() {
		
		//$seja_current_theme = wp_get_theme();
		//$seja_current_theme->get( 'Name' )
		//$seja_current_theme->get( 'Version' )
		$html = '<p><img src="' . get_bloginfo( 'template_url' ) . '/images/admin/framework.png" width="16" height="12" style="float:left; padding-right:10px; position:relative; top:5px;">You are running the <strong>' . SEJA_THEME_NAME . '</strong> theme.<br>This custom theme is built on the Seja Framework, running version ' . SEJA_THEME_VERSION . '.</p>';
		$html .= '<p>This theme has a number of custom configurations which can be adjusted <strong><a href="' . get_home_url() . '/wp-admin/admin.php?page=seja_template_settings.php">here</a></strong>.<br>There are also a <strong><a href="' . get_home_url() . '/wp-admin/admin.php?page=seja-help-page">brief tutorial</a></strong> on some of the theme\'s features, including the available shortcodes.</p>.';
		
		$html .= '<h3>News Feed</h3>';
		
		//$safe_feed = wp_safe_remote_get( "http://www.presshost.com.au/category/framework/feed/" );
		//$rss = fetch_feed( $safe_feed );
		$rss = fetch_feed( "http://www.presshost.com.au/category/framework/feed/" );

		echo $html;
		
		 if ( is_wp_error($rss) ) {
          if ( is_admin() || current_user_can('manage_options') ) {
               echo '<p>';
               printf(__('<strong>RSS Error</strong>: %s'), $rss->get_error_message());
               echo '</p>';
          }
     return;
}
  
if ( !$rss->get_item_quantity() ) {
     echo '<p>Apparently, there are no updates to show!</p>';
     $rss->__destruct();
     unset($rss);
     return;
}
  
echo "<ul>\n";
  
if ( !isset($items) )
     $items = 5;
  
     foreach ( $rss->get_items(0, $items) as $item ) {
          $publisher = '';
          $site_link = '';
          $link = '';
          $content = '';
          $date = '';
          $link = esc_url( strip_tags( $item->get_link() ) );
          $title = esc_html( $item->get_title() );
          $content = $item->get_content();
          $content = wp_html_excerpt($content, 250) . ' ...';
  
         echo "<li><a class='rsswidget' href='$link'>$title</a>\n<div class='rssSummary'>$content</div>\n";
}
  
echo "</ul>\n";
$rss->__destruct();
unset($rss);
	}

/* ------------------------------------------------------------------------ * 
 * Formatting - Seja Login Logo
 * ------------------------------------------------------------------------ */

		function seja_login_logo() {
			echo '<style type="text/css">
				h1 a { background-image:url('.get_bloginfo('template_directory').'/images/logo-login.gif) !important; width:280px !important; background-size:280px 65px !important; }
			</style>';
		}
		add_action('login_head', 'seja_login_logo');

/* ------------------------------------------------------------------------ * 
 * Formatting - Template Formatting
 * ------------------------------------------------------------------------ */
	
	// new 2.13 - add framework menus to toolbar
	
	function seja_to_toolbar( $wp_admin_bar ) {
	
	$args = array(
		'id'    => 'seja_framework_settings',
		'title' => 'Seja Template',
		'href'  => get_bloginfo('url') . '/wp-admin/admin.php?page=seja_template_settings.php',
		'meta'  => array( 'class' => 'seja-framework-settings seja-toolbar-parent' )
	);
	$wp_admin_bar->add_node( $args );
	
	//help
	$args = array(
		'id'    => 'seja_framework_help',
		'title' => 'Tips and Help',
		'href'  => get_bloginfo('url') . '/wp-admin/admin.php?page=seja-help-page',
		'meta'  => array( 'class' => 'seja-framework-settings seja-toolbar-help' ),
		'parent' => 'seja_framework_settings',
	);
	$wp_admin_bar->add_node( $args );
}
add_action( 'admin_bar_menu', 'seja_to_toolbar', 999 );
		
/* ------------------------------------------------------------------------ * 
 * // END OF SECTION - Formatting
 * ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ * 
 * // SEO Section - Google Analytics
 * ------------------------------------------------------------------------ */
	function seja_google_analytics_footer() {
		$options = get_option('seja_seo_options'); 
			
		if(!empty($options['seja_google_analytics'] ) ) {
			echo($options['seja_google_analytics']);
		}
	}
		add_action('wp_footer', 'seja_google_analytics_footer'); 

/* ------------------------------------------------------------------------ * 
 * // Maintenance Mode
 * ------------------------------------------------------------------------ */	
		
	function seja_maintenace_mode() {
		if ( !current_user_can( 'administrator' ) ) :
			require( get_template_directory() . '/custom/templates/offline-template.php' );
			die;
		endif;
	}
	
	function seja_maintenance_notice() {
		$class = 'notice notice-info';
		$message = __( 'Maintenance Mode is enabled.', 'seja_framework' );
		$url = get_bloginfo( 'url' ) . '/wp-admin/admin.php?page=seja_template_settings.php';

		printf( '<div class="%1$s"><p><a href="' . $url . '">%2$s</a></p></div>', esc_attr( $class ), esc_html( $message ) ); 
	}

	if( SEJA_MAINTENANCE_MODE == '1') :
		add_action( 'admin_notices', 'seja_maintenance_notice' );
		add_action('get_header', 'seja_maintenace_mode');
	endif;
		
/* ------------------------------------------------------------------------ * 
 * // SEO Section - GZIP Compression REMOVED - HERE FOR REFERENCE ONLY
 * ------------------------------------------------------------------------ */
 
 	if( SEJA_GZIP_COMPRESSION == 1 ) :
		// http://wordpress.think-bowl.com/development/safely-update-htaccess-plugin/
		
		function seja_gzip_compression() {
			$htaccess = get_home_path() . '.htaccess'; 
			
			$lines = array();
				$lines[] = '# compress text, html, javascript, css, xml:
							AddOutputFilterByType DEFLATE text/plain
							AddOutputFilterByType DEFLATE text/html
							AddOutputFilterByType DEFLATE text/xml
							AddOutputFilterByType DEFLATE text/css
							AddOutputFilterByType DEFLATE application/xml
							AddOutputFilterByType DEFLATE application/xhtml+xml
							AddOutputFilterByType DEFLATE application/rss+xml
							AddOutputFilterByType DEFLATE application/javascript
							AddOutputFilterByType DEFLATE application/x-javascript
							AddType x-font/otf .otf
							AddType x-font/ttf .ttf
							AddType x-font/eot .eot
							AddType x-font/woff .woff
							AddType image/x-icon .ico
							AddType image/png .png';
							// http://softstribe.com/wordpress/enable-gzip-compression-in-wordpress
	 
			insert_with_markers($htaccess, "Seja GZIP Compression", $lines);
		}
		
		//register_activation_hook( 'seja_seo_gzip', 'seja_gzip_compression' );
	
	endif; 
	
	
 
/* ------------------------------------------------------------------------ * 
 * // Automation - Update Core
 * ------------------------------------------------------------------------ */ 
 	
	if( SEJA_UPDATE_CORE == 1 )
		add_filter( 'allow_major_auto_core_updates', '__return_true' );
		add_filter( 'allow_minor_auto_core_updates', '__return_true' );
 
/* ------------------------------------------------------------------------ * 
 * // Automation - Update Plugins
 * ------------------------------------------------------------------------ */ 
 
 	if( SEJA_UPDATE_PLUGINS == 1 ) 
		add_filter( 'auto_update_plugin', '__return_true' );
 
/* ------------------------------------------------------------------------ * 
 * // Automation - Update Themes
 * ------------------------------------------------------------------------ */ 
 
	if( SEJA_UPDATE_THEMES == 1 ) 
		add_filter( 'auto_update_theme', '__return_true' );
