<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Functions File: The main theme functions file
 *
 * @package WordPress
 * @subpackage Seja_Framework
 *
 * ------------------------------------------------------------------------ * 
 * Include Files (gets the framework functions) DO NOT EDIT OR DELETE THIS
 * ------------------------------------------------------------------------ */
 
	require( get_template_directory() . '/includes/index.php');

/* ------------------------------------------------------------------------ * 
 * Add custom functions below this line
 * ------------------------------------------------------------------------ */


// this is an example of a walker - it can be used to customise the menu 

class seja_walker extends Walker_Nav_Menu {
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		
		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$class_names = ' class="' . esc_attr( $class_names ) . '"';

		$output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '<br /><span class="sub">' . $item->description . '</span>';
		$item_output .= '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args = array(), $item->ID);
	}
}


	// Set and forget definitions)
	define ( 'SEJA_EXCERPT_LENGTH', '40' ); 	/* sets the number of words in the excerpts */
	define ( 'SEJA_REQUIRE_SSL', 'no' );		/* set to yes to force SSL - ONLY USE IF A VALID CERTIFICATE IS INSTALLED */
	//define ( 'SEJA_VISITED_COLOUR', '8a00ff' ); /* enable and adjust if you want a different link colour for visited pages */
	define ( 'SEJA_ADVERTISING_MINLENGTH', '0' ); // set 0 to display at end of post (recommended at least 200)
	define ( 'SEJA_ADVERTISING', '2' ); // 0 = disabled, 1 = posts only, 2 = posts and pages
	


/* ------------------------------------------------------------------------ * 
 * DO NOT DELETE THE PHP CLOSE TAG
 * ------------------------------------------------------------------------ */?>