<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Template Name: Two Column Right
 *
 * A custom page template with Right Sidebar.
 *
 * @package WordPress
 * @subpackage Seja_Framework
 *
 * ------------------------------------------------------------------------ */

get_header(); ?>
<!-- twocolumnright.php -->
<?php seja_layout( array('type' => 'spage', 'option' => 'right' ) ); ?>

<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php seja_the_title( (get_post_meta($post->ID, 'seja_customfield_alternative_title', true) ) ); ?>
		<div class="entry-content">
			<?php the_content(); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'seja_framework' ), 'after' => '</div>' ) ); ?>
			<?php edit_post_link( __( 'Edit', 'seja_framework' ), '<span class="edit-link">', '</span>' ); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-## -->

	<?php comments_template( '', true ); ?>

<?php endwhile; ?>

<?php seja_layout( array('type' => 'epage', 'option' => 'page') ); ?>
<?php get_footer(); ?>