<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Template Name: Scroll Page
 *
 * Use this for pop-up modal style windows or stripped-down Call-To-Action pages
 *
 * @package WordPress
 * @subpackage Seja_Framework
 *
 * ------------------------------------------------------------------------ */
define ( SEJA_PAGE_TYPE, 'scroll-page' ); // for future development

get_header(); ?>
<!-- page-scroll.php -->
<div class="outer-wrapper" id="scroll-page">
		
    
    <?php
	$seja_scrollpage = get_pages( array( 'child_of' => $post->ID, 'sort_column' => 'menu_order', 'sort_order' => 'asc' ) );
	$count = '0';

	foreach( $seja_scrollpage as $page ) {		
		$content = $page->post_content;
		$id = $page->ID;
		$pid = $page->post_name; // trying this instead of id for menu linking
		if ( ! $content ) // Check for empty page
			continue;
		$count ++;
		$content = apply_filters( 'the_content', $content );
	?>
    <div class="scroll-block scroll-block-<?php echo $count; ?> post-<?php echo $id; ?>" id="<?php echo $pid; ?>">
    	<div class="inner-wrapper">
            <h2><?php echo $page->post_title; ?></h2>
            <div class="entry-content">
                <?php echo $content; ?>
            </div>
            <?php edit_post_link( __( 'Edit', 'seja_framework' ), '<span class="edit-link">', '</span>', $id ); ?>
		</div><!-- .inner-wrapper-->
    </div><!-- #<?php echo $pid; ?>-->
    
	<?php
	}	
?>
            
<?php seja_pre_footer(); ?>
<?php get_footer(); ?>