<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * The loop that displays posts.
 *
 * The loop displays the posts and the post content.  See
 * http://codex.wordpress.org/The_Loop to understand it and
 * http://codex.wordpress.org/Template_Tags to understand
 * the tags used in it.
 *
 * This can be overridden in child themes with loop.php or
 * loop-template.php, where 'template' is the loop context
 * requested by a template. For example, loop-index.php would
 * be used if it exists and we ask for the loop with:
 * <code>get_template_part( 'loop', 'index' );</code>
 *
 * @package WordPress
 * @subpackage Seja_Framework
 * 
 * ------------------------------------------------------------------------ */
?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if ( $wp_query->max_num_pages > 1 ) : ?>
	<?php seja_pagination(); ?>
<?php endif; ?>

<?php 
/* ------------------------------------------------------------------------ * 
 * Loop if there are no posts to display, such as an empty archive page
 * ------------------------------------------------------------------------ */

if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title seja-loop-404"><?php _e( 'Not Found', 'seja_framework' ); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'seja_framework' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>

<?php
/* ------------------------------------------------------------------------ * 
 * Loop for Gallery category
 * ------------------------------------------------------------------------ */
	 ?>
<?php while ( have_posts() ) : the_post(); ?>

<?php /* How to display posts of the Gallery format. The gallery category is the old way. */ ?>

	<?php if ( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) ) || in_category( _x( 'gallery', 'gallery category slug', 'seja_framework' ) ) ) : ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<h2 class="entry-title seja-loop-gallery"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'seja_framework' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>

			<div class="entry-meta">
				<?php seja_full_posted_on(); ?>
			</div><!-- .entry-meta -->

			<div class="entry-content">
<?php if ( post_password_required() ) : ?>
				<?php the_content(); ?>
<?php else : ?>
				<?php
					$images = get_children( array( 'post_parent' => $post->ID, 'post_type' => 'attachment', 'post_mime_type' => 'image', 'orderby' => 'menu_order', 'order' => 'ASC', 'numberposts' => 999 ) );
					if ( $images ) :
						$total_images = count( $images );
						$image = array_shift( $images );
						$image_img_tag = wp_get_attachment_image( $image->ID, 'thumbnail' );
				?>
						<div class="gallery-thumb">
							<a class="size-thumbnail" href="<?php the_permalink(); ?>"><?php echo $image_img_tag; ?></a>
						</div><!-- .gallery-thumb -->
						<p><em><?php printf( _n( 'This gallery contains <a %1$s>%2$s photo</a>.', 'This gallery contains <a %1$s>%2$s photos</a>.', $total_images, 'seja_framework' ),
								'href="' . get_permalink() . '" title="' . sprintf( esc_attr__( 'Permalink to %s', 'seja_framework' ), the_title_attribute( 'echo=0' ) ) . '" rel="bookmark"',
								number_format_i18n( $total_images )
							); ?></em></p>
				<?php endif; ?>
						<?php the_excerpt(); ?>
<?php endif; ?>
			</div><!-- .entry-content -->

			<div class="entry-utility">
			<?php if ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) ) : ?>
				<a href="<?php echo get_post_format_link( 'gallery' ); ?>" title="<?php esc_attr_e( 'View Galleries', 'seja_framework' ); ?>"><?php _e( 'More Galleries', 'seja_framework' ); ?></a>
				<span class="meta-sep">|</span>
			<?php elseif ( in_category( _x( 'gallery', 'gallery category slug', 'seja_framework' ) ) ) : ?>
				<a href="<?php echo get_term_link( _x( 'gallery', 'gallery category slug', 'seja_framework' ), 'category' ); ?>" title="<?php esc_attr_e( 'View posts in the Gallery category', 'seja_framework' ); ?>"><?php _e( 'More Galleries', 'seja_framework' ); ?></a>
				<span class="meta-sep">|</span>
			<?php endif; ?>
				<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'seja_framework' ), __( '1 Comment', 'seja_framework' ), __( '% Comments', 'seja_framework' ) ); ?></span>
				<?php edit_post_link( __( 'Edit', 'seja_framework' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
			</div><!-- .entry-utility -->
		</div><!-- #post-## -->



<?php 
/* ------------------------------------------------------------------------ * 
 * Loop for all other pages
 * ------------------------------------------------------------------------ */
 ?>

	<?php else : ?>
    
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        
         <?php if ( is_archive() || is_search() ) : // Only display excerpts for archives and search. ?>
         
        	<div class="excerpt-column-left">
            	<div class="excerpt-entry-meta">
					<?php seja_excerpt_posted_on(); ?>
                </div><!-- .entry-meta -->
                
                <div class="seja-post-thumbnail">
				<?php if ( has_post_thumbnail() ) { ?>
                    <?php the_post_thumbnail( 'thumbnail', 'seja_framework' ); ?>
                <?php } else {
                    echo seja_thumbnail_excerpt();
                }?>
                </div>       
                      
            </div><!--.excerpt-column-left -->  
            
            <div class="excerpt-column-right">
            
                <h2 class="entry-title seja-loop-main"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'seja_framework' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
               
                    <div class="entry-summary">
                        <?php the_excerpt(); ?>
                    </div><!-- .entry-summary -->
                    
 			</div>	
                               
		<?php else : ?>
             
				<h2 class="entry-title seja-loop-main"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'seja_framework' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
                    
                    <div class="entry-meta">
						<?php seja_full_posted_on(); ?>
                    </div><!-- .entry-meta -->
                    
                    <div class="entry-content">
                        <?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'seja_framework' ) ); ?>
                        <?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'seja_framework' ), 'after' => '</div>' ) ); ?>
                    </div><!-- .entry-content -->
                    
		<?php endif; ?>

			<div class="entry-utility clear-excerpt-float">
				<?php if ( count( get_the_category() ) ) : ?>
					<span class="cat-links">
						<?php printf( __( '<span class="%1$s">Posted in</span> %2$s', 'seja_framework' ), 'entry-utility-prep entry-utility-prep-cat-links', get_the_category_list( ', ' ) ); ?>
					</span>
					<span class="meta-sep">|</span>
				<?php endif; ?>
				<?php
					$tags_list = get_the_tag_list( '', ', ' );
					if ( $tags_list ):
				?>
					<span class="tag-links">
						<?php printf( __( '<span class="%1$s">Tagged</span> %2$s', 'seja_framework' ), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list ); ?>
					</span>
					<span class="meta-sep">|</span>
				<?php endif; ?>
				<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'seja_framework' ), __( '1 Comment', 'seja_framework' ), __( '% Comments', 'seja_framework' ) ); ?></span>
				<?php edit_post_link( __( 'Edit', 'seja_framework' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
			</div><!-- .entry-utility -->
		</div><!-- #post-## -->

		<?php comments_template( '', true ); ?>

	<?php endif; // This was the if statement that broke the loop into two parts based on categories. ?>

<?php endwhile; // End the loop. Whew. ?>

<?php

/* ------------------------------------------------------------------------ * 
 * Display the pagination
 * ------------------------------------------------------------------------ */
	if (  $wp_query->max_num_pages > 1 ) :
		seja_pagination();
	endif; 
	
?>
