<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * This creates the custom styles as defined by the Seja Template settings
 *
 * ------------------------------------------------------------------------ */


function seja_header_css_top(){
	$html = '<style>';
	if( SEJA_DEBUG_MODE == '1' ) 
		$html .= '/* Theme is in debug mode - Version ' . SEJA_THEME_VERSION . ' */'; 
	// Template widths
	$html .= '.inner-wrapper,#colophon,#copyright-wrapper{width:' . SEJA_TEMPLATE_WIDTH . 'px;margin:0 auto;}';
	$html .= '@media (max-width:' . SEJA_TEMPLATE_WIDTH . 'px) {.inner-wrapper,#colophon,#copyright-wrapper{width:100%;margin:0;}}';
	if ( SEJA_RESPONSIVE_MENU != 1 ) :
		// responsive menu settings
		$html .= '#navigation nav select{display: none;}';
		$html .= '@media (max-width:' . SEJA_RESPONSIVE_POINT . 'px){#navigation nav ul{display: none;}#navigation nav select{display:inline-block;}}';
	endif;
	// logo image
	$html .= '@media (max-width:' . SEJA_LOGO_WIDTH . '>px){.header-img img{width:100%;height:auto;}}';
	// bullet points
	$bullet_type = array(
		'circle' 			=> '"\f111";top:-2px;font-size:0.4em !important;',
		'large_circle' 		=> '"\f111";',
		'ring' 				=> '"\f10c";',
		'thin_ring' 		=> '"\f1db";',
		'target' 			=> '"\f192";',
		'check_circle' 		=> '"\f05d";',
		'check_ring' 		=> '"\f05d";',
		'info_circle' 		=> '"\f05a";',
		'square' 			=> '"\f0c8";top:-3px;',
		'outline_square'	=> '"\f096";',
		'check_square' 		=> '"\f096";',
		'oc_square' 		=> '"\f046";',
		'plus_square' 		=> '"\f0fe";',
		'triangle_up' 		=> '"\f0d8";',
		'triangle_down' 	=> '"\f0d7";',
		'triangle_left' 	=> '"\f0d9";',
		'triangle_right' 	=> '"\f0da";',
		'tick' 				=> '"\f00c";',
	);
	$html .= '.hentry ul li:before';
	if ( SEJA_WOO_SUPPORT == '1' ) :
		$html .= ',.woo-main .description ul li:before,.woo-main .woocommerce-tabs ul li:before';
	endif;
	$html .= '{color:' . SEJA_BULLET_COLOUR . ';font-family:\'Font Awesome 5 Free\', \'Font Awesome 5 Pro\';padding-right:8px;position:relative;content:' . $bullet_type[ SEJA_BULLET_TYPE ] . '}';
	//Theme colours (h tags, etc.)
	$html .= 'h1,h2,h3,h4,h5,h6,legend,th,address,.entry-title,.entry-title a:link,.entry-title a:visited,h3#comments-title,h3#reply-title,.widget-title{color:' . SEJA_BULLET_COLOUR . ';}';
	// text colours (paragraphs, forms etc.)
	$html .= 'p,ol,ul,dd,pre,td,ins,.comment-body p,.custom-block,.wpcf7-form div {color:' . SEJA_TEXT_COLOUR . ';}';
	// link colours
	$html .= 'a:link';
	if( defined( 'SEJA_VISITED_COLOUR' ) ) :
		$html .= '{color:' . SEJA_LINK_COLOUR . ';}';
		$html .= 'a:visited{color:';
		if( strpos( SEJA_VISITED_COLOUR, '#' ) === false ):
			$html .= '#';
		endif;
		$html .= SEJA_VISITED_COLOUR . ';}';
	else :
		$html .= ',a:visited{color:' . SEJA_LINK_COLOUR . ';}';
	endif;
	//blockquote
	$html .= 'blockquote{border-left:4px solid ' . SEJA_BULLET_COLOUR . ';}';
	// pagination
	$html .= '.pagination span,.pagination a{border:1px solid ' . SEJA_BULLET_COLOUR . ';color:' . SEJA_BULLET_COLOUR . ';}';
	$html .= '.pagination .current{background:' . SEJA_BULLET_COLOUR . ';}';
	// calendar
	$html .= '#wp-calendar tbody a{background:' . SEJA_BULLET_COLOUR . ';}';
	// weather
	$html .= '.seja-current-weather{fill:' . SEJA_BULLET_COLOUR . ';fill-rule:evenodd;clip-rule:evenodd;}';
	// copywrite colours
	$html .= '.copyright,.site-info,.copyright a:link,.copyright a:visited,.site-info a:link,.site-info a:visited{color:' . SEJA_COPYRIGHT_COLOUR . ';}';
	$html .= '.seja-svg{fill:' . SEJA_COPYRIGHT_COLOUR . ';fill-rule:evenodd;clip-rule:evenodd;}';
	$html .= '</style>';
	
	echo $html;
}
function seja_header_css_bottom() {
	//hover colours
	$html = '<style>';
	$html .= 'a:active,a:hover,.entry-title a:active,.entry-title a:hover,.entry-meta a:active,.entry-meta a:hover,.entry-utility a:active,.entry-utility a:hover,.navigation a:active,.navigation a:hover,#comments .comment-meta a:active,#comments .comment-meta a:hover,p.logged-in-as a:active,p.logged-in-as a:hover,.site-info a:active,.site-info a:hover,.copyright a:active,.copyright a:hover{color:' . SEJA_HOVER_COLOUR . ';}';
	$html .= '.pagination a:hover{background:' . SEJA_HOVER_COLOUR . ';border:1px solid ' . SEJA_HOVER_COLOUR . ';}';
	$html .= '#wp-calendar tbody a:hover{background:' . SEJA_HOVER_COLOUR . ';}';
	$html .= '</style>';
	
	echo $html;
}

add_action('wp_head', 'seja_header_css_top', 7);
add_action('wp_head', 'seja_header_css_bottom', 10);