<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework 2.15
 * Main header file
 *
 * ------------------------------------------------------------------------ * 
 * Define Global Variable
 * ------------------------------------------------------------------------ */
	
	$current_id = $post->ID;
	$GLOBALS['current_id'] = $current_id;
	//global $current_id;

/* ------------------------------------------------------------------------ * 
 * Force SSL
 * ------------------------------------------------------------------------ */
	
	if( SEJA_REQUIRE_SSL == 'yes' ) :
		if($_SERVER["HTTPS"] != "on") :
			header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
    		exit();
		endif;
	endif;
		
/* ------------------------------------------------------------------------ * 
 * Mobile Detection
 * ------------------------------------------------------------------------ */
	require( get_template_directory() . '/includes/functions/mobile_detect.php'); 
	$seja_detect = new seja_mobile_detect(); 
	if( $seja_detect->isMobile() ): $GLOBALS['seja_detect_output'] = 'mobile';  //mobile
	elseif( $seja_detect->isTablet() ): $GLOBALS['seja_detect_output'] = 'tablet'; //tablet
	else: $GLOBALS['seja_detect_output'] = 'desktop'; //everything else
	endif;
/* ------------------------------------------------------------------------ * 
 * START OF PAGE
 * ------------------------------------------------------------------------ */ 
 ?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php
/* ------------------------------------------------------------------------ * 
 * META - Charset
 * ------------------------------------------------------------------------ */	?>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<?php 
/* ------------------------------------------------------------------------ * 
 * HEADER - Title
 * ------------------------------------------------------------------------ */
	seja_header_title( $current_id ); ?>
<?php
/* ------------------------------------------------------------------------ * 
 * META - viewport
 * ------------------------------------------------------------------------ */	
 ?>
<meta name="viewport" content="width=device-width, initial-scale=1.0">    
<?php 

/* ------------------------------------------------------------------------ * 
 * HEADER - Adaptive Styles
 * ------------------------------------------------------------------------ */
	 include( 'styles.php' ); 

if( SEJA_PAGE_TYPE != 'lightbox-page' ) : // if it's a lightbox we're skipping to #120

/* ------------------------------------------------------------------------ * 
 * META - Google Verification
 * ------------------------------------------------------------------------ */
	if( defined ( 'SEJA_GOOGLE_VARIFICATION' ) ) echo SEJA_GOOGLE_VARIFICATION;  // perhaps this should be renamed?
/* ------------------------------------------------------------------------ * 
 * META - Description
 * ------------------------------------------------------------------------ */
	seja_meta_description( $current_id );
/* ------------------------------------------------------------------------ * 
 * META - Keywords
 * ------------------------------------------------------------------------ */
	seja_meta_keywords( $current_id );
/* ------------------------------------------------------------------------ * 
 * META - author
 * ------------------------------------------------------------------------ */
 	seja_meta_author();
/* ------------------------------------------------------------------------ * 
 * META - Properties DEPRECIATE - this should be done by an SEO plugin if it's required
 * ------------------------------------------------------------------------ */
 	//echo META_OG_DESC;
/* ------------------------------------------------------------------------ * 
 * META - Twitter DEPRECIATE - as above
 * ------------------------------------------------------------------------ */
 	//echo META_TWITTER_DESC;
/* ------------------------------------------------------------------------ * 
 * HEADER - Favicon and mobile icons
 * ------------------------------------------------------------------------ */ ?>
<link rel="icon" type="image/png" href="<?php bloginfo( 'template_url' ); ?>/images/favicon.png">
<?php 
	if( file_exists ( get_template_directory() . '/images/icon-60.png' ) ) : ?>
<!-- iOS tile icons -->
<link rel="apple-touch-icon" href="<?php bloginfo( 'template_url' ); ?>/images/icon-60.png">
<?php 
	endif; 
	if( file_exists ( get_template_directory() . '/images/icon-76.png' ) ) : 
?>
<link rel="apple-touch-icon" sizes="76x76" href="<?php bloginfo( 'template_url' ); ?>/images/icon-76.png">
<?php 
	endif;
	if( file_exists ( get_template_directory() . '/images/icon-240.png' ) ) : ?>
<link rel="apple-touch-icon" sizes="240x240" href="<?php bloginfo( 'template_url' ); ?>/images/icon-240.png">
<?php 
	endif;
	if( file_exists ( get_template_directory() . '/images/icon304.png' ) ) : ?>
<link rel="apple-touch-icon" sizes="304x304" href="<?php bloginfo( 'template_url' ); ?>/images/icon-304.png">
<?php 
	endif;
	if( file_exists ( get_template_directory() . '/images/icon-540.png' ) ) : ?>
<link rel="apple-touch-icon" sizes="540x540" href="<?php bloginfo( 'template_url' ); ?>/images/icon-540.png">
<?php 
	endif;
	if( file_exists ( get_template_directory() . '/images/icon-144.png' ) ) : ?>
<!-- Windows live tile icon -->
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="msapplication-TileImage" content="<?php bloginfo( 'template_url' ); ?>/images/icon-144.png">
<?php 
	endif;

endif; // end of the lightbox-page section ignore

/* ------------------------------------------------------------------------ * 
 * HEADER - Font links  
 * ------------------------------------------------------------------------ */
 ?>
<link href="<?php bloginfo( 'template_url' ); ?>/css/font-awesome.css" rel="stylesheet" type="text/css">
<link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,800,700' rel='stylesheet' type='text/css'>
<?php
	// custom fonts include
	require( get_template_directory() . '/custom/templates/fonts.php');
	echo "\n";
 /* ------------------------------------------------------------------------ * 
 * HEADER - Stylesheets
 * ------------------------------------------------------------------------ */
?>
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<?php if( SEJA_PAGE_TYPE != 'lightbox-page' ) : // skipping to line #129  ?>
<?php if( SEJA_PARALLAX_USAGE == parallax ) : ?>
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'template_url' ); ?>/css/parallax.css" />
<?php endif;

/* ------------------------------------------------------------------------ * 
 * HEADER - Pingback
 * ------------------------------------------------------------------------ */
 ?>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
/* ------------------------------------------------------------------------ * 
 * HEADER - Javascript
 * ------------------------------------------------------------------------ */
	if ( is_singular() && get_option( 'thread_comments' ) )  
		wp_enqueue_script( 'comment-reply' );
		
/* ------------------------------------------------------------------------ * 
 * HEADER - Scroll Page Javascript
 * ------------------------------------------------------------------------ */		
		if( SEJA_PAGE_TYPE == 'scroll-page' ) :
			
			// do the javascript call for the scroll
			
		endif;

endif; // end of the lightbox-page ignore section


/* ------------------------------------------------------------------------ * 
 * HEADER - wp_head                                               !important 
 * ------------------------------------------------------------------------ */
	wp_head();

	
if( SEJA_PAGE_TYPE != 'lightbox-page' ) : // skipping to line #219 

/* ------------------------------------------------------------------------ * 
 * META - Google Verification
 * ------------------------------------------------------------------------ */
	echo SEJA_GOOGLE_ANALYTICS;

 /* ------------------------------------------------------------------------ * 
 * facebook Pixel
 * ------------------------------------------------------------------------ */ 
 // surely this should be !defined...???
 if( SEJA_FB_PIXEL != '' )  : ?>
<!-- Facebook Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window,document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '<?php echo SEJA_FB_PIXEL; ?>'); 
fbq('track', 'PageView');
<?php // custom element goes in here
if (get_post_meta($post->ID, 'seja_customfield_fb_pixel', true ) ) :
	if (get_post_meta($post->ID, 'seja_customfield_fb_pixel', true ) != '--' ) :
		echo "fbq('track', '" . get_post_meta($post->ID, 'seja_customfield_fb_pixel', true );
		if( get_post_meta($post->ID, 'seja_customfield_fb_pixel', true ) == 'Purchase') :
			echo "', {value: '0.00', currency: 'AUD'});";
		else :
			echo "');"; 
		endif;
	endif;
endif
?>
</script>
<noscript>
<img height="1" width="1" 
src="https://www.facebook.com/tr?id=<?php echo SEJA_FB_PIXEL; ?>&ev=PageView
&noscript=1"/>
</noscript>
<!-- End Facebook Pixel Code -->
 
 <?php endif; // end of the Facebook Pixel code
endif; // end of the lightbox-page ignore  
 /* ------------------------------------------------------------------------ * 
 * HEADER - End of <head>
 * ------------------------------------------------------------------------ */ ?>

</head>
<?php
/* ------------------------------------------------------------------------ * 
 * Body tag styles
 * ------------------------------------------------------------------------ */
 	$body_class = 'device-type-' . $GLOBALS['seja_detect_output'];
	if( SEJA_PARALLAX_USAGE == parallax ): 
		$body_class .= ' has-header-image';
	endif;
	
 
if( SEJA_PAGE_TYPE == 'lightbox-page' ) : ?>  
<body <?php body_class( 'seja-modal' ); ?>>
<?php else: // continue to the end of the page?>
<body <?php body_class( $body_class ); if ( SEJA_TOPLINK == 1 ) : ?> id="top"<?php endif; ?>>

<?php 
/* ------------------------------------------------------------------------ *  
 * HEADER - Facebook Feed tie in
 * ------------------------------------------------------------------------ */
	if(function_exists('seja_facebook_head') ) {
		seja_facebook_head();
	}
/* ------------------------------------------------------------------------ * 
 * STRUCTURE - Site layout 
 * ------------------------------------------------------------------------ */ ?>
<div id="header-shell" class="<?php if( SEJA_PARALLAX_USAGE == parallax ): ?>site-header<?php else : ?>outer-wrapper<?php endif; ?>"<?php if( SEJA_PARALLAX_USAGE == parallax ): ?> role="banner"<?php endif; ?>>
<?php 
	if( SEJA_PARALLAX_USAGE == parallax ) :
		include ( get_template_directory() . '/includes/structure/header/parallex.php' );
		seja_layout( array('type' => 'content') ); 
	endif;
?>
<?php endif; // end of lightbox-page if/else statement ?>