<?php

/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Set all the definitions used across the framework
 *
 * ------------------------------------------------------------------------ */
	
// this is potential future development	
$file = get_template_directory() . '/includes/structure/definitions.php';
	if( is_writable( $file ) ) :
		define ( 'SEJA_DEFINITIONS', 'file' );
	else :
		define ( 'SEJA_DEFINITIONS', 'database' );
	endif;
	
	// the function to create a definition from the database entry
	function seja_dbopt ( $db_call, $definition ) {
		define ( $definition, get_option( $db_call ) );
	}
	
	// fixed definitions and variables
	$url = get_bloginfo( 'template_url' );
	$template_path = get_template_directory();
	$seja_current_theme = wp_get_theme();
	define( 'SEJA_THEME_NAME', $seja_current_theme->get( 'Name' ) );
	define( 'SEJA_THEME_VERSION', $seja_current_theme->get( 'Version' ) );
	define( 'SEJA_CURRENT_VERSION', '30000' );
	
	// depreciated definitions - delete when all calls to them are removed
	define ( 'SEJA_TEMPLATE_TYPE', '1' ); // the old layout (standard / centred / left column menu)
	define ( 'SEJA_HEADER_IMAGE_OPTION', '4' ); // the old header type (type 4 is 'custom')

// 1.1 General Options
	// Template Width
	seja_dbopt( 'seja_template_width', 'SEJA_TEMPLATE_WIDTH' );
	
	// Site Logo
	$this_option = get_option('seja_site_logo'); 
	define ( 'SEJA_SITE_LOGO', $this_option );
	define ( 'SEJA_LOGO_URL', $url . '/images/headers/' . $this_option );
	define ( 'SEJA_LOGO_PATH', $template_path . '/images/headers/' . $this_option );
	define ( 'SEJA_LOGO_EXT', substr( SEJA_LOGO_PATH, -3 ) );
	
	if( file_exists( SEJA_LOGO_PATH ) ) :
	
		if( SEJA_LOGO_EXT == 'svg' ):
	// Site Logo Width
			define ( 'SEJA_LOGO_WIDTH', get_option('seja_logo_width') );
	// Site Logo Height
			define ( 'SEJA_LOGO_HEIGHT', get_option('seja_logo_height') );
		else :
			list($width, $height, $type, $attr) = getimagesize( SEJA_LOGO_URL );
	// Site Logo Width
			define ( 'SEJA_LOGO_WIDTH', $width );
	// Site Logo Height
			define ( 'SEJA_LOGO_HEIGHT', $height );
		endif;
	
	endif;
	
	// Parallax Image
	$this_option = get_option('seja_parallax_file'); 
	define ( 'SEJA_PARALLAX_FILE', $this_option );
	define ( 'SEJA_PARALLAX_URL', $url . '/images/headers/' . $this_option );
	define ( 'SEJA_PARALLAX_PATH', $template_path . '/images/headers/' . $this_option );
	if( file_exists( SEJA_PARALLAX_PATH ) ) :
		list($width, $height, $type, $attr) = getimagesize( SEJA_PARALLAX_URL );
	//Parallax Image Width
		define ( 'SEJA_PARALLAX_WIDTH', $width );
	// Parallax Image Height
		define ( 'SEJA_PARALLAX_HEIGHT', $height );
	endif;
	// Parallax Usage
	seja_dbopt( 'seja_parallax_usage', 'SEJA_PARALLAX_USAGE' );
	// Enable Mobile Menu
	seja_dbopt( 'seja_mobile_menu', 'SEJA_MOBILE_MENU' );
	// Disable Responsive Menu
	seja_dbopt( 'seja_responsive_menu', 'SEJA_RESPONSIVE_MENU' );
	// Responsive Menu Change Point
	seja_dbopt( 'seja_responsive_point', 'SEJA_RESPONSIVE_POINT' );
	// Index Column Position
	seja_dbopt( 'seja_index_columns', 'SEJA_INDEX_COLUMNS' );
	// Single Post Column Position
	seja_dbopt( 'seja_single_columns', 'SEJA_SINGLE_COLUMNS' );
	// Archive and Category Column Position
	seja_dbopt( 'seja_category_columns', 'SEJA_CATEGORY_COLUMNS' );
	// Column Width 
	seja_dbopt( 'seja_column_width', 'SEJA_COLUMN_WIDTH' );	
	// Footer Layout PENDING DEPRECIATION
	seja_dbopt( 'seja_footer_layout', 'SEJA_FOOTER_LAYOUT' );
	// Site offline
	seja_dbopt( 'seja_maintenance_mode', 'SEJA_MAINTENANCE_MODE' );
	// Enable Debug Mode
	seja_dbopt( 'seja_theme_debug', 'SEJA_DEBUG_MODE' );
	// Enable WooCommerce Support
	seja_dbopt( 'seja_woocommerce_support', 'SEJA_WOO_SUPPORT' );
	// Enable Accordion
	seja_dbopt( 'seja_enable_accordion', 'SEJA_ENABLE_ACCORDION' );
	// Enable Scroll to Top
	seja_dbopt( 'seja_enable_toplink', 'SEJA_TOPLINK' );
	// Theme Colour
	seja_dbopt( 'seja_text_colour', 'SEJA_TEXT_COLOUR' );
	// Text Colour
	seja_dbopt( 'seja_link_colour', 'SEJA_LINK_COLOUR' );
	// Link Colour
	seja_dbopt( 'seja_bullet_colour', 'SEJA_BULLET_COLOUR' );
	// Hover Colour
	seja_dbopt( 'seja_hover_colour', 'SEJA_HOVER_COLOUR' );
	// Bullet Style
	seja_dbopt( 'seja_bullet_type', 'SEJA_BULLET_TYPE' );
	// Copyright Colour
	seja_dbopt( 'seja_copyright_colour', 'SEJA_COPYRIGHT_COLOUR' );
	// Auto-Update - WordPress Core
	seja_dbopt( 'seja_update_core', 'SEJA_UPDATE_CORE' );
	// Auto-Update -Plugins
	seja_dbopt( 'seja_update_plugins', 'SEJA_UPDATE_PLUGINS' );
	// Auto-Update - Themes
	seja_dbopt( 'seja_update_themes', 'SEJA_UPDATE_THEMES' );
//1.2 WooCommerce
	seja_dbopt( 'seja_woopage_columns', 'SEJA_WOOPAGE_COLUMNS' );
	seja_dbopt( 'seja_woo_columns', 'SEJA_WOO_COL' );
	seja_dbopt( 'seja_woo_rows', 'SEJA_WOO_ROW' );
	$seja_total_products = SEJA_WOO_COL * SEJA_WOO_ROW;
	define ( 'SEJA_WOO_TOTALPRODUCTS', $seja_total_products );
	seja_dbopt( 'seja_woo_haspadding', 'SEJA_WOO_HASPADDING' );
	seja_dbopt( 'seja_woo_disable_pricerange', 'SEJA_WOO_DISABLE_PRICERANGE' );
	seja_dbopt( 'seja_woo_remove_related', 'SEJA_WOO_REMOVE_RELATED' );
	seja_dbopt( 'seja_woo_remove_additionaltab', 'SEJA_WOO_REMOVE_ADDITIONALTAB' );
	
	
	//1.6 -Depreciated Theme Footer Calls
	/*
	seja_dbopt( 'seja_footer_widget_facebook', 'SEJA_FOOTER_FACEBOOK' );
	seja_dbopt( 'seja_footer_widget_twitter', 'SEJA_FOOTER_TWITTER' );
	seja_dbopt( 'seja_footer_widget_linkedin', 'SEJA_FOOTER_LINKEDIN' );
	seja_dbopt( 'seja_footer_widget_youtube', 'SEJA_FOOTER_YOUTUBE' );
	seja_dbopt( 'seja_footer_widget_instagram', 'SEJA_FOOTER_INSTAGRAM' );
	seja_dbopt( 'seja_footer_widget_instagram', 'SEJA_FOOTER_PINTEREST' );
	seja_dbopt( 'seja_footer_widget_rss', 'SEJA_FOOTER_RSS' );
	seja_dbopt( 'seja_footer_widget_icon', 'SEJA_FOOTER_ICON' );
	*/
// 2.1 - SEO
	seja_dbopt( 'seja_seo_google_varification', 'SEJA_GOOGLE_VARIFICATION' );
	seja_dbopt( 'seja_seo_google_analytics', 'SEJA_GOOGLE_ANALYTICS' );
	seja_dbopt( 'seja_fb_pixel', 'SEJA_FB_PIXEL' );
	seja_dbopt( 'seja_gzip_compression', 'SEJA_GZIP_COMPRESSION' );
	seja_dbopt( 'seja_seo_override', 'SEJA_SEO_OVERRIDE' );
	// 3.1 - Facebook
	seja_dbopt( 'seja_facebook_options_url', 'SEJA_FACEBOOK_URL' );
	seja_dbopt( 'seja_facebook_options_width', 'SEJA_FACEBOOK_WIDTH' );
	seja_dbopt( 'seja_facebook_options_height', 'SEJA_FACEBOOK_HEIGHT' );
	seja_dbopt( 'seja_facebook_options_showfaces', 'SEJA_FACEBOOK_SHOWFACES' );
	seja_dbopt( 'seja_facebook_options_showstream', 'SEJA_FACEBOOK_SHOWSTREAM' );
	seja_dbopt( 'seja_facebook_options_showheader', 'SEJA_FACEBOOK_SHOWHEADER' );
	seja_dbopt( 'seja_facebook_options_colorscheme', 'SEJA_FACEBOOK_COLORSCHEME' );
	seja_dbopt( 'seja_facebook_options_bordercolor', 'SEJA_FACEBOOK_BORDERCOLOR' );
// 3.1 - Google +
	seja_dbopt( 'seja_googleplus_url', 'SEJA_GOOGLEPLUS_URL' );
// 3.4 - YouTube
	seja_dbopt( 'seja_youtube_options_rel', 'SEJA_YOUTUBE_SHORTCODE_REL' );
	seja_dbopt( 'seja_youtube_options_width', 'SEJA_YOUTUBE_SHORTCODE_WIDTH' );
	seja_dbopt( 'seja_youtube_options_height', 'SEJA_YOUTUBE_SHORTCODE_HEIGHT' );
// 3.5 - Weather Widget
	seja_dbopt( 'seja_weather_json_location', 'SEJA_WEATHER_JSON_LOCATION' );
	seja_dbopt( 'seja_weather_json_apparent', 'SEJA_WEATHER_JSON_APPARENT' );
	seja_dbopt( 'seja_weather_json_graph', 'SEJA_WEATHER_JSON_GRAPH' );