<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 2.16
 *
 * Defines the frameworks initial settings so things do not get broken when being 
 * installed. Note: If the seja_options_aready_set option has been set or version is the same, this file 
 * will be ignored (because obviously this file has already run).
 *
 *	Versions are based on Major | Minor x2 | Sub x2 
 *		eg. version 2.4.7 would be 20407 | version 2.14 is 21400
 *
 * ------------------------------------------------------------------------ */
 
if ( ! defined( 'ABSPATH' ) ) { exit; }

	function seja_framework_update_option( $old, $new ) {
	
		$new_value = get_option( $old );
		register_setting( 'seja_general_options', $new  ); 
		add_option ( $new, $new_value );
		delete_option( $old );
		
		//echo '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Updated option ' . $old . ' is now ' . $new . ' (Value is ' . $new_value . ')<br>';
	}
	
	function seja_update_notice() {	
		?>
		<div class="updated notice">
            <p><?php _e( 'Seja Framework has been updated to the latest version<br>Options have been updated and depreciated options removed.', 'seja_framework' ); ?></p>
        </div> <?php 
    }
		
	function seja_install_notice() {	
		?>
		<div class="updated notice">
            <p><?php _e( 'Seja Template has been installed', 'seja_framework' ); ?></p>
        </div> <?php 
       }
		
	// Upgrading from framework 2.13 or earler
if( get_option( 'seja_options_already_set' ) == '1' )/* && ( get_option( 'seja_framework_version' ) < '21400' ) ) */:
		
		// our new 'ignore' and reset option
		//echo SEJA_FRAMEWORK_VERSION;
		if ( get_option( 'seja_framework_version' ) == '' ) :
			update_option( 'seja_framework_version', SEJA_FRAMEWORK_VERSION );
		else:
			add_option ( 'seja_framework_version', SEJA_FRAMEWORK_VERSION );
		endif;
				
		// update the existing options
		seja_framework_update_option( 'seja_general_template_width', 'seja_template_width' );
		seja_framework_update_option( 'seja_header_logo', 'seja_site_logo' );
		seja_framework_update_option( 'seja_header_image_file', 'seja_parallax_file' );
		seja_framework_update_option( 'seja_content_index_columns', 'seja_index_columns' );
		seja_framework_update_option( 'seja_content_single_columns', 'seja_single_columns' );
		seja_framework_update_option( 'seja_content_category_columns', 'seja_category_columns' );
		seja_framework_update_option( 'seja_content_column_width', 'seja_column_width' );
		seja_framework_update_option( 'seja_general_checkfile', 'seja_theme_debug' );
		seja_framework_update_option( 'seja_content_woo_support', 'seja_woocommerce_support' );
		seja_framework_update_option( 'seja_content_accordion_menu', 'seja_enable_accordion' );
		seja_framework_update_option( 'seja_footer_toplink', 'seja_enable_toplink' );
		seja_framework_update_option( 'seja_footer_copyright_colour', 'seja_copyright_colour' );
		seja_framework_update_option( 'seja_general_update_core', 'seja_update_core' );
		seja_framework_update_option( 'seja_general_update_plugins ', 'seja_update_plugins' );
		seja_framework_update_option( 'seja_general_update_themes', 'seja_update_themes' );
		seja_framework_update_option( 'seja_general_debug', 'seja_debug_output' );
		seja_framework_update_option( 'seja_woocommerce_columns', 'seja_woopage_columns' );
		seja_framework_update_option( 'seja_woocommerce_product_col', 'seja_woo_columns' );
		seja_framework_update_option( 'seja_woocommerce_product_row', 'seja_woo_rows' );
		seja_framework_update_option( 'seja_woocommerce_disable_price_range', 'seja_woo_disable_pricerange' );
		// seja_framework_update_option( 'OLD', 'NEW' );
		
		// delete depreciated and dead options
		delete_option( 'seja_options_already_set' );
		delete_option( 'seja_header_debug' ); 		
		delete_option( 'seja_content__debug' ); 
		delete_option( 'seja_footer_debug' ); 
		delete_option( 'seja_content_expandable_menu' ); 
		delete_option( 'seja_database_backup' ); 
		delete_option( 'seja_general_database_backup' ); 
		delete_option( 'seja_general_template_name' ); 
		delete_option( 'seja_gzip_compression' ); 
		delete_option( 'seja_general_woo_support' ); 
		delete_option( 'seja_header_html' ); 
		delete_option( 'seja_hide_unused_widget' );
		delete_option( 'seja_general_hide_unused_widgets' );
		delete_option( 'seja_general_hide_unused_widgets' ); 
		delete_option( 'seja_slidedeck_id' ); 
		delete_option( 'seja_template_name' ); 
		delete_option( 'seja_template_type' ); 
		delete_option( 'seja_theme_options' );
		// the 'never happened' footer widget! 
		delete_option( 'seja_footer_widget_icon' ); 
		delete_option( 'seja_footer_widget_instagram' ); 
		delete_option( 'seja_footer_widget_linkedin' ); 
		delete_option( 'seja_footer_widget_pinterest' ); 
		delete_option( 'seja_footer_widget_rss' ); 
		delete_option( 'seja_footer_widget_twitter' ); 
		delete_option( 'seja_footer_widget_youtube' ); 
		delete_option( 'seja_general_template_type' ); 	
		delete_option( 'seja_header_image' ); 
		// delete_option( $option ); 
		
		add_action ( 'admin_notices', 'seja_update_notice' );

endif;
// if( get_option( 'seja_framework_version' ) == 'xxx' ) : READ THE PSUDO BELOW
				 
/* FUTURE UPDATES 

	Future updates will need to look at what version we're updating from
	1. first future update will be simple (ie. if less-than current version)
	2. subsequent updates will require individual else statements
	NO NO NO NO NO
	LET'S DO THE 2.15+ VERSIONS SEPARATELY (BUT REFERENCE THIS)
	
*/

/* The following is purely an example of update 1

	elseif ( get_option( 'seja_framework_version' ) << SEJA_FRAMEWORK_VERSION ) : 
		// whatever code in here 
	// add_action ( 'admin_notices', 'seja_update_notice' ); 
	// finishes at existing else: statement	
*/

/* The following is purely an example of update 2 (version numbers are (possible future) examples)
	elseif ( get_option( 'seja_framework_version' ) << SEJA_FRAMEWORK_VERSION ) : 
		if ( get_option( 'seja_framework_version' ) << '21700' :
			// version 2.17 updates
		endif; 
		if ( get_option( 'seja_framework_version' ) << '30000'
			// version 3.0 updates
		endif; 
		if ( get_option( 'seja_framework_version' ) << '30101'
			// version 3.1.1 updates
		endif;
	// add_action ( 'admin_notices', 'seja_update_notice' ); 
	// finishes at existing else: statement
	*/        
        
		///https://premium.wpmudev.org/blog/adding-admin-notices/
		//add_action ( 'admin_notices', 'seja_update_notice' );
		
	

// endif
// under version 21400 means this has never run so we're setting up the latest 
if( get_option( 'seja_framework_version' ) < '21399' ) :
	//echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;hi mum&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;version is ' . get_option( 'seja_framework_version' );

	// Add or update or framework version
		if ( get_option( 'seja_framework_version' ) == '' ) :
			update_option( 'seja_framework_version', SEJA_FRAMEWORK_VERSION );
		else:
			add_option ( 'seja_framework_version', SEJA_FRAMEWORK_VERSION );
		endif;
	
	// INSTALL SOME FIRST TIME VARIABLES
	
	// 1.1 General Options
	add_option ( 'seja_template_width', '1200');
	add_option ( 'seja_responsive_point', '800');
	add_option ( 'seja_maintenance_mode', '0');
	add_option ( 'seja_theme_debug', '0');
	add_option ( 'seja_woocommerce_support', '0');
	add_option ( 'seja_enable_accordion', '0');
	add_option ( 'seja_enable_toplink', '0');
	add_option ( 'seja_seo_override', '0' );
	add_option ( 'seja_seo_sitemap' );
	add_option ( 'seja_seo_robots' );
	add_option ( 'seja_bullet_type', 'circle');
	add_option ( 'seja_seo_google_varification' );  // change this name
	add_option ( 'seja_seo_google_analytics' );		// change this name
	add_option ( 'seja_site_logo', 'logo.png');
	add_option ( 'seja_parallax_file', 'parallax.jpg');
	add_option ( 'seja_parallax_usage', 'disable');
	add_option ( 'seja_mobile_menu', '0');
	add_option ( 'seja_responsive_menu', '0');
	add_option ( 'seja_index_columns', 'left');
	add_option ( 'seja_single_columns', 'left');
	add_option ( 'seja_category_columns', 'left');
	add_option ( 'seja_column_width', '25');
	add_option ( 'seja_footer_layout', 'default');
	add_option ( 'seja_bullet_colour', '#476ee5');// now theme colour
	add_option ( 'seja_text_colour', '#414953'); 
	add_option ( 'seja_link_colour', '#0096ff');
	add_option ( 'seja_hover_colour', '#ff9900');	
	add_option ( 'seja_copyright_colour', '#f9e5ae');
	add_option ( 'seja_update_core', '0');
	add_option ( 'seja_update_plugins', '1');
	add_option ( 'seja_update_themes', '1');
	
	//1.2 - WooCommerce
	add_option ( 'seja_woopage_columns', 'left');
	add_option ( 'seja_woo_columns', '4');
	add_option ( 'seja_woo_rows', '4');
	add_option ( 'seja_woo_haspadding', '0');
	add_option ( 'seja_woo_disable_pricerange', '0');
	add_option ( 'seja_woo_remove_related', '0');
	add_option ( 'seja_woo_remove_additionaltab', '0');
	
	
	// 2.1 - SEO DEPRECIATED
	
	
	
	//add_option ( 'seja_gzip_compression' );
	
	// 3.1 - Facebook
	
	add_option ( 'seja_facebook_options_url' );	
	add_option ( 'seja_facebook_options_width', '300' );
	add_option ( 'seja_facebook_options_height' );
	add_option ( 'seja_facebook_options_showfaces' );
	add_option ( 'seja_facebook_options_showstream' );
	add_option ( 'seja_facebook_options_showheader' );
	add_option ( 'seja_facebook_options_colorscheme', 'light' );
	add_option ( 'seja_facebook_options_bordercolor' );
	
	// 3.2 - Twitter
	
	add_option ( 'seja_twitter_options_code' );
	
	// 3.3 - YouTube
	
	add_option ( 'seja_youtube_options_rel' );
	add_option ( 'seja_youtube_options_width', '480' );
	add_option ( 'seja_youtube_options_height', '390' );
	
	// 3.4 Weather
	add_option ( 'seja_weather_options_json_location', 'Perth WA' );
	add_option ( 'seja_weather_options_json_apparent', '0' );
	add_option ( 'seja_weather_options_json_graph', '0' );

/* ------------------------------------------------------------------------ * 
 * Theme Setup - CLEAR WORDPRESS DEFAULTS
 * ------------------------------------------------------------------------ */
 	
	//THIS IS RUNNING WHEN IT SHOULDN'T BE (so I've disabled it until I can revisit)
 	function seja_setup_theme()
		{
			
		// some resources
		// https://developer.wordpress.org/reference/functions/wp_insert_post/
		// http://www.catswhocode.com/blog/wordpress-how-to-insert-data-programmatically
			
			// set options
			$options_array = array(
				'date_format'               => 'd.m.Y',
				'default_pingback_flag'     => '0',
				'default_ping_status'       => 'closed',
				'default_comment_status'    => 'closed',
				'default_post_edit_rows'    => 30,
				'links_updated_date_format' => 'j. F Y, H:i',
				'permalink_structure'       => '/%postname%/',
				'timezone_string'           => 'Australia/Perth',
				'use_smilies'               => '0',
				//'show_on_front'				=> 'page',
				//'page_on_front'				=> '1'
			);
		
			foreach ( $options_array as $setting => $value )
			{
				update_option($setting, $value);
			}
			
			add_action ( 'admin_notices', 'seja_install_notice' ); 
		
			return;
		}
		
		//echo 'Theme has installed';

		//add_action( 'init', 'seja_setup_theme' );	
		
		
			
endif;
// end of option setup	
