<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * 1.1 - General Options
 * ------------------------------------------------------------------------ */


// General page tabs
function seja_menu_theme_display() {
	
	if( isset( $_GET[ 'tab' ] ) ) {  
        $active_tab = $_GET[ 'tab' ];
		$page_number = '1'; 
    } else {
		$active_tab = 'general-options';
		$page_number = '1';
	}

// page starts here
	?>
	<!-- Create a header in the default WordPress 'wrap' container --> 
    <div class="wrap seja-template">
    	<?php screen_icon(); ?>
	    <h2>Theme Settings</h2>
        <h3 class="nav-tab-wrapper">
        	<a href="admin.php?page=seja_template_settings.php&amp;tab=general-options" class="nav-tab <?php echo $active_tab == 'general-options' ? 'nav-tab-active' : ''; ?>">General Options</a>
            <?php if( SEJA_WOO_SUPPORT == '1'): ?>
            <a href="admin.php?page=seja_template_settings.php&amp;tab=woocommerce" class="nav-tab <?php echo $active_tab == 'woocommerce' ? 'nav-tab-active' : ''; ?>">WooCommerce</a>
            <?php endif; ?>
        </h3>
        <?php settings_errors(); ?>
        
        <form method="post" action="options.php">
        <?php 
			// tab 1
			if( $active_tab == 'general-options' ) {
				echo '<div class="seja-settings-twocol">';
				settings_fields( 'seja_general_options' );
            	do_settings_sections( 'seja_general_options' ); 
				echo '</div>';
			}
			// tab 2
			if( $active_tab == 'woocommerce' ) {
				settings_fields( 'seja_woocommerce_options' );
            	do_settings_sections( 'seja_woocommerce_options' ); 
			}
		?>
        <div style="clear:both"></div>
         <?php submit_button(); ?>
      </form> 
	</div>
    <?php if ( SEJA_DEBUG_MODE == '1') : ?>
    <div class="debug-table">
    <h3>TESTING VARIABLES - disable by unchecking 'debug' in General Options</h3>
    <?php if( $active_tab == 'general-options' ) : ?>
    <p><?php 
		if( SEJA_DEFINITIONS == 'file' ) :
			echo 'Files on this server are writeable - This is good.';
		else :
			echo 'Cannot write to Files on this server.';
		endif; ?></p>
    <table cellpadding="2" cellspacing="1" class="debug-table">
      <tr>
      	<td>#name</td>
        <td>DEFINITION</td>
        <td>Output</td>
      </tr>
      <tr>
        <td>Template Width</td>
        <td>SEJA_TEMPLATE_WIDTH</td>
        <td><strong><?php echo SEJA_TEMPLATE_WIDTH; ?></strong></td>
      </tr>
       <tr>
        <td>Responsive Change Point</td>
        <td>SEJA_RESPONSIVE_POINT</td>
        <td><strong><?php echo SEJA_RESPONSIVE_POINT; ?></strong></td>
      </tr>
      <tr>
        <td>Site Offline</td>
        <td>SEJA_MAINTENANCE_MODE</td>
        <td><strong><?php echo  SEJA_MAINTENANCE_MODE; ?></strong></td>
      </tr>
      <tr>
        <td>Debug Theme</td>
        <td>SEJA_DEBUG_MODE</td>
        <td><strong><?php echo  SEJA_DEBUG_MODE; ?></strong></td>
      </tr>
      <tr>
        <td>WooCommerce Support</td>
        <td>SEJA_WOO_SUPPORT</td>
        <td><strong><?php echo SEJA_WOO_SUPPORT; ?></strong></td>
      </tr>
      <tr>
        <td>Accordion Shortcode</td>
        <td>SEJA_ENABLE_ACCORDION</td>
        <td><strong><?php echo SEJA_ENABLE_ACCORDION; ?></strong></td>
      </tr>
      <tr>
        <td>Link to Top</td>
        <td>SEJA_TOPLINK</td>
        <td><strong><?php echo SEJA_TOPLINK; ?></strong></td>
      </tr>
      <tr>
        <td>Override SEO</td>
        <td>SEJA_SEO_OVERRIDE</td>
        <td><strong><?php echo SEJA_SEO_OVERRIDE; ?></strong></td>
      </tr>
       <tr>
        <td>View Sitemap</td>
        <td></td>
        <td><strong><?php echo SEJA_; ?></strong></td>
      </tr>
       <tr>
        <td>Robots.txt</td>
        <td></td>
        <td><strong><?php echo SEJA_; ?></strong></td>
      </tr>
      <tr>
        <td>Bullet Type</td>
        <td>SEJA_BULLET_TYPE</td>
        <td><strong><?php echo SEJA_BULLET_TYPE; ?></strong></td>
      </tr>
      <tr>
        <td>Top Header code</td>
        <td>SEJA_GOOGLE_VARIFICATION</td>
        <td><strong><?php echo SEJA_GOOGLE_VARIFICATION; ?></strong></td>
      </tr>
       <tr>
        <td>Bottom Header code</td>
        <td>SEJA_GOOGLE_ANALYTICS</td>
        <td><strong><?php echo SEJA_GOOGLE_ANALYTICS; ?></strong></td>
      </tr>
      <tr>
        <td>Site Logo</td>
        <td>SEJA_SITE_LOGO</td>
        <td><strong> <?php echo SEJA_SITE_LOGO; ?></strong></td>
      </tr>
      <tr>
        <td align="right">URL</td>
        <td>SEJA_LOGO_URL</td>
        <td><strong<?php 
	  		if( !file_exists( SEJA_LOGO_PATH ) ) :
	  ?> style="color:red;"<?php endif; ?>> <?php echo SEJA_LOGO_URL; ?></strong><?php 
	  		if( !file_exists( SEJA_LOGO_PATH ) ) : ?><br>
            <em>File does not exist</em><?php endif; ?></td>
      </tr>
      <tr>
        <td align="right">Path</td>
        <td>SEJA_LOGO_PATH</td>
        <td><strong<?php 
	  		if( !file_exists( SEJA_LOGO_PATH ) ) :
	  ?> style="color:red;"<?php endif; ?>> <?php echo SEJA_LOGO_PATH; ?></strong><?php 
	  		if( !file_exists( SEJA_LOGO_PATH ) ) : ?><br>
            <em>File does not exist</em><?php endif; ?></td>
      </tr>
      <tr>
        <td align="right">Width</td>
        <td>SEJA_LOGO_WIDTH</td>
        <td><strong><?php echo SEJA_LOGO_WIDTH; ?></strong></td>
      </tr>
      <tr>
        <td align="right">Height</td>
        <td>SEJA_LOGO_HEIGHT</td>
        <td><strong><?php echo SEJA_LOGO_HEIGHT; ?></strong></td>
      </tr>
      <tr>
        <td align="right">File Extension</td>
        <td>SEJA_LOGO_EXT</td>
        <td><strong><?php echo SEJA_LOGO_EXT; ?></strong></td>
      </tr>
      <tr>
        <td>Parallax File</td>
        <td>SEJA_PARALLAX_FILE</td>
        <td><strong><?php echo SEJA_PARALLAX_FILE; ?></strong></td>
      </tr>
      <tr>
        <td align="right">URL</td>
        <td>SEJA_PARALLAX_URL</td>
        <td><strong<?php 
	  		if( !file_exists( SEJA_PARALLAX_PATH ) ) :
	  ?> style="color:red;"<?php endif; ?>><?php echo SEJA_PARALLAX_URL; ?></strong><?php 
	  		if( !file_exists( SEJA_PARALLAX_PATH ) ) : ?><br>
            <em>File does not exist</em><?php endif; ?></td>
      </tr>
      <tr>
        <td align="right">Path</td>
        <td>SEJA_PARALLAX_PATH</td>
        <td><strong<?php 
	  		if( !file_exists( SEJA_PARALLAX_PATH ) ) :
	  ?> style="color:red;"<?php endif; ?>><?php echo SEJA_PARALLAX_PATH; ?></strong><?php 
	  		if( !file_exists( SEJA_PARALLAX_PATH ) ) : ?><br>
            <em>File does not exist</em><?php endif; ?></td>
      </tr>
      <tr>
        <td align="right">Width</td>
        <td>SEJA_PARALLAX_WIDTH</td>
        <td><strong><?php echo SEJA_PARALLAX_WIDTH; ?></strong></td>
      </tr>
      <tr>
        <td align="right">Height</td>
        <td>SEJA_PARALLAX_HEIGHT</td>
        <td><strong><?php echo SEJA_PARALLAX_HEIGHT; ?></strong></td>
      </tr>
      <tr>
        <td align="right">Usage</td>
        <td>SEJA_PARALLAX_USAGE</td>
        <td><strong><?php echo SEJA_PARALLAX_USAGE; ?></strong></td>
      </tr>
      <tr>
        <td>Mobile Menu</td>
        <td>SEJA_MOBILE_MENU</td>
        <td><strong><?php echo SEJA_MOBILE_MENU; ?></strong></td>
      </tr>
      <tr>
        <td>Disable Responsive Menu</td>
        <td>SEJA_RESPONSIVE_MENU</td>
        <td><strong><?php echo SEJA_RESPONSIVE_MENU; ?></strong></td>
      </tr>
     
      <tr>
        <td>Index Page Columns</td>
        <td>SEJA_INDEX_COLUMNS</td>
        <td><strong><?php echo SEJA_INDEX_COLUMNS; ?></strong></td>
      </tr>
      <tr>
        <td>Single Page Columns</td>
        <td>SEJA_SINGLE_COLUMNS</td>
        <td><strong><?php echo SEJA_SINGLE_COLUMNS; ?></strong></td>
      </tr>
      <tr>
        <td>Other Page Columns</td>
        <td>SEJA_CATEGORY_COLUMNS</td>
        <td><strong><?php echo SEJA_CATEGORY_COLUMNS; ?></strong></td>
      </tr>
      <tr>
        <td>Column Width</td>
        <td>SEJA_COLUMN_WIDTH</td>
        <td><strong><?php echo SEJA_COLUMN_WIDTH; ?></strong></td>
      </tr>
      <tr>
        <td>Footer Layout </td>
        <td>SEJA_FOOTER_LAYOUT</td>
        <td><strong><?php echo SEJA_FOOTER_LAYOUT; ?></strong></td>
      </tr>
      <tr>
        <td>Theme Colour</td>
        <td>SEJA_BULLET_COLOUR</td>
        <td><strong><?php echo SEJA_BULLET_COLOUR; ?></strong></td>
      </tr>
      <tr>
        <td>Text Colour</td>
        <td>SEJA_TEXT_COLOUR</td>
        <td><strong><?php echo SEJA_TEXT_COLOUR; ?></strong></td>
      </tr>
      <tr>
        <td>Link Colour</td>
        <td>SEJA_LINK_COLOUR</td>
        <td><strong><?php echo SEJA_LINK_COLOUR; ?></strong></td>
      </tr>
      <tr>
        <td>Hover Colour</td>
        <td>SEJA_HOVER_COLOUR</td>
        <td><strong><?php echo SEJA_HOVER_COLOUR; ?></strong></td>
      </tr>
      
      <tr>
        <td>Copyright Colour</td>
        <td>SEJA_COPYRIGHT_COLOUR</td>
        <td><strong><?php echo SEJA_COPYRIGHT_COLOUR; ?></strong></td>
      </tr>
      <tr>
        <td>Update Core</td>
        <td>SEJA_UPDATE_CORE</td>
        <td><strong><?php echo SEJA_UPDATE_CORE; ?></strong></td>
      </tr>
      <tr>
        <td>Update Plugins</td>
        <td>SEJA_UPDATE_PLUGINS</td>
        <td><strong><?php echo SEJA_UPDATE_PLUGINS; ?></strong></td>
      </tr>
      <tr>
        <td>Update Themes</td>
        <td>SEJA_UPDATE_THEMES</td>
        <td><strong><?php echo SEJA_UPDATE_THEMES; ?></strong></td>
      </tr>
      <tr>
        <td>Framework Version</td>
        <td>SEJA_FRAMEWORK_VERSION</td>
        <td><strong><?php echo SEJA_FRAMEWORK_VERSION; ?></strong></td>
      </tr>
      <tr>
        <td>Test Variable *</td>
        <td>TEST_VARIABLE</td>
        <td><?php echo TEST_VARIABLE; ?></td>
      </tr>
    </table>    
	<p><strong>* </strong><em>Variable not active, but can be used to debug modifications</em></p>
    <?php endif; // active tab ?>
    </div>
	  <?php  endif; // debut mode
 } // end seja_menu_theme_display  

    


/* ------------------------------------------------------------------------ * 
 * Theme Options Page - Field Callbacks 
 * ------------------------------------------------------------------------ */

 
 
	// Template Width
function seja_template_width_callback($args) {
	
	$this_option = get_option('seja_template_width');
		
	?>
    <input name="seja_template_width" type="text" id="seja_template_width" value="<?php echo SEJA_TEMPLATE_WIDTH; ?>" class="regular-text" /><br>
	<label for="seja_template_width"><?php echo $args[0]; ?></label>
	<?php
}
// Responsive Menu Change Point
function seja_responsive_point_callback($args) { 

	$this_option = get_option('seja_responsive_point');
	
	?><input name="seja_responsive_point" type="text" id="seja_responsive_point" value="<?php echo $this_option; ?>" class="regular-text" /><br>
	<label for="seja_responsive_point"> <?php echo $args[0]; ?></label>	
    
	<?php
} 
// Site Offline
	function seja_maintenance_mode_callback($args) {
	
	$this_option = get_option('seja_maintenance_mode'); ?>
    
    <div id="maintenance">
	<p><input type="checkbox" id="seja_maintenance_mode" name="seja_maintenance_mode" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-alt-checkbox"><label for="seja_maintenance_mode"></label>
<strong>Site Offline (Maintenance Mode)</strong><br>
    <em>Puts the site into maintenance mode, and can only be viewed by admin users.</em>

     </p>
    </div> <?php
}
	
	// Enable Debug Mode
function seja_theme_debug_callback($args) {
	
	$this_option = get_option('seja_theme_debug'); ?>
    <div id="debug">
	<p> <input type="checkbox" id="seja_theme_debug" name="seja_theme_debug" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-alt-checkbox"><label for="seja_theme_debug"></label><strong>Enable Debug Mode</strong><br>
    <em>This will show variables in backend, but will also affect the visual appearance of the theme.</em>

     </p>
    </div> <?php

}
 	
	// Enable WooCommerce Support
function seja_woocommerce_support_callback($args) { 
     
	$this_option = get_option('seja_woocommerce_support'); ?>
    
    <input type="checkbox" id="seja_woocommerce_support" name="seja_woocommerce_support" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">  
    <label for="seja_woocommerce_support"></label><?php echo $args[0]; ?>
	      
    <?php
}
	
	// Enable Accordion
function seja_enable_accordion_callback($args) { 
     
	$this_option = get_option('seja_enable_accordion'); ?>
     
    <input type="checkbox" id="seja_enable_accordion" name="seja_enable_accordion" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">  
    <label for="seja_enable_accordion"></label><?php echo $args[0]; ?>  
      
    <?php
}
	
	// Enable Scroll to Top
function seja_enable_toplink_callback($args) {
	
	$this_option = get_option('seja_enable_toplink'); 
	
	?>
    <input type="checkbox" id="seja_enable_toplink" name="seja_enable_toplink" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">  
    <label for="seja_enable_toplink"></label><?php echo $args[0]; ?>
	<p>Creates a floating link to take you back to the top of the page<br>
	This is especially useful in pages with large content or scrolling page style websites.</p>	
	<?php
}
	// Override SEO
function seja_seo_override_callback($args) {
	
	$this_option = get_option('seja_seo_override'); 
	
	?>
    <input type="checkbox" id="seja_seo_override" name="seja_seo_override" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-alt-checkbox">  
    <label for="seja_seo_override"></label><?php echo $args[0]; ?>   
	
	<?php 
}
	// View Sitemap
function seja_seo_sitemap_callback($args) {
	
	$this_option = get_option('seja_seo_sitemap'); 
	
	$sitemap_location = get_bloginfo( 'url' ) . '/sitemap.xml';
	$sitemap_file = get_home_path() . 'sitemap.xml';
	if( file_exists( $sitemap_file ) ) : ?>
		<p>Sitemap is generated automatically and can be viewed here: <a href="<?php echo $sitemap_location; ?>" target="_blank"><?php echo $sitemap_location; ?></a></p><?php 
	else : ?>
		<p>No sitemap is available - This may be due to your operating system, or perhaps you haven't published anything yet.</p> 
		<p>
    <?php 
	endif;
	
}
	// Edit Robots.txt
function seja_seo_robots_callback($args) {
		
	?>
    
    <?php
	$robots_file = get_home_path() . 'robots.txt';
	
	if( file_exists( $robots_file ) ) : 
		$robots_txt = fopen( $robots_file, "r");
		add_thickbox();
	?>
   		<textarea name="seja_robots_txt" rows="5" cols="20" id="seja_robots_txt" class="large-text code" disabled="disabled"><?php echo fread($robots_txt,filesize( $robots_file )); ?></textarea><br>
	<a href="<?php echo bloginfo( 'template_url' ); ?>/includes/functions/seja_robots_txt.php?source=<?php echo get_home_path(); ?>&function=edit&TB_iframe=true&width=600&height=550" class="thickbox">Edit robots.txt file</a>
	
    <?php fclose( $robots_txt ); ?>
	<?php else: ?>
    	
		<?php add_thickbox(); ?>

    	<p><strong>There is no robots.txt file</strong> <a href="<?php bloginfo( 'template_url' ); ?>/includes/functions/seja_robots_txt.php?source=<?php echo get_home_path(); ?>&function=create&TB_iframe=true&width=600&height=550" class="thickbox">Click here to configure</a></p>
  <?php endif;
}
// Bullet Style
function seja_bullet_type_callback($args) {
	
	$this_option = get_option('seja_bullet_type'); ?>
    
    <select name="seja_bullet_type" id="seja_bullet_type" class="large-text code seja-select">
    <optgroup label="Circles">
    <?php seja_dropdown_option( 'circle', 'Small Circle', $this_option );  ?>
    <?php seja_dropdown_option( 'large_circle', 'Large Circle', $this_option );  ?>
    <?php seja_dropdown_option( 'ring', 'Ring', $this_option );  ?>
    <?php seja_dropdown_option( 'thin_ring', 'Thin Ring', $this_option );  ?> 
    <?php seja_dropdown_option( 'target', 'Target', $this_option );  ?>
    <?php seja_dropdown_option( 'check_circle', 'Check Circle', $this_option );  ?>
    <?php seja_dropdown_option( 'check_ring', 'Check Ring', $this_option );  ?>
    <?php seja_dropdown_option( 'info_circle', 'Information Circle', $this_option );  ?>
	</optgroup>
    <optgroup label="Squares">
    <?php seja_dropdown_option( 'square', 'Square', $this_option ); ?>
    <?php seja_dropdown_option( 'outline_square', 'Outline Square', $this_option ); ?>
    <?php seja_dropdown_option( 'check_square', 'Check Square', $this_option ); ?>
    <?php seja_dropdown_option( 'oc_square', 'Outline Check Square', $this_option ); ?>
    <?php seja_dropdown_option( 'plus_square', 'Plus Square', $this_option ); ?>
    </optgroup>
    <optgroup label="Other">
    <?php seja_dropdown_option( 'triangle_up', 'Triangle Up', $this_option ); ?>
    <?php seja_dropdown_option( 'triangle_down', 'Triangle Down', $this_option ); ?>
    <?php seja_dropdown_option( 'triangle_left', 'Triangle Left', $this_option ); ?>
    <?php seja_dropdown_option( 'triangle_right', 'Triangle Right', $this_option ); ?>
    <?php seja_dropdown_option( 'tick', 'Tick', $this_option )  ?>
    </optgroup>
	</select>
    <label for="seja_bullet_type"><?php echo $args[0] ?></label>
	<hr>
    <h3>Header</h3>
	<?php
	
}
function seja_google_varification_callback($args) { 
     
	$this_option = get_option('seja_seo_google_varification'); 
	 
    ?>
    <textarea name="seja_seo_google_varification" rows="5" cols="20" id="seja_seo_google_varification" class="large-text code"><?php echo $this_option; ?></textarea>
    <label for="seja_seo_google_varification"></label>
    <p>Add code to the top of the header<br>Recommended area for Google Verification code</p>
    <?php 
     
} 

function seja_google_analytics_callback($args) { 
     
	$this_option = get_option('seja_seo_google_analytics'); 
     
    ?>
    <textarea name="seja_seo_google_analytics" rows="5" cols="20" id="seja_seo_google_analytics" class="large-text code"><?php echo $this_option ?></textarea>
    <label for="seja_seo_google_analytics"></label> 
    <p>Add code to the bottom of the header<br>Recommended area for Google Analytics code</p>
      
    <?php  
}
	// Site Logo
function seja_site_logo_callback($args) { 

	$this_option = get_option('seja_site_logo');
	
	?><input name="seja_site_logo" type="text" id="seja_site_logo" value="<?php echo $this_option; ?>" class="regular-text" /><br>
	<label for="seja_site_logo"> <?php echo $args[0]; ?></label>
	<p>Upload your logo to <?php bloginfo( 'template_url' ); ?>/images/headers/</p>
	
	<?php
	if( ( SEJA_LOGO_EXT == 'svg' ) && ( ( get_option('seja_logo_width') == '' ) || ( get_option('seja_logo_height') == '' ) ) ):
	?>
    <p style="color:red">Template can not auto-detect image size for SVG graphics. Please add values to fields below</p>
    <?php
	endif;
}
	// Site Logo Width
function seja_logo_width_callback ($args) {
	
	$this_option = get_option('seja_logo_width');
	
	?><input name="seja_logo_width" type="text" id="seja_logo_width" value="<?php echo $this_option; ?>" class="regular-text" /><br>
	<label for="seja_logo_width"> <?php echo $args[0]; ?></label>
    
    <?php
}

	// Site Logo Height
function seja_logo_height_callback ($args) {
	
	$this_option = get_option('seja_logo_height');
	
	?><input name="seja_logo_height" type="text" id="seja_logo_height" value="<?php echo $this_option; ?>" class="regular-text" /><br>
	<label for="seja_logo_height"> <?php echo $args[0]; ?></label>
    
    <?php
}
	
	// Parallax Image
function seja_parallax_file_callback($args) { 

	$this_option = get_option('seja_parallax_file');
	
	?><input name="seja_parallax_file" type="text" id="seja_parallax_file" value="<?php echo $this_option; ?>" class="regular-text" /><br>
	<label for="seja_parallax_file"> <?php echo $args[0]; ?></label>
	<p>Upload your image to <?php bloginfo( 'template_url' ); ?>/images/headers/<br>
This option will only be visible if the Parallax Header Option is selected</p>
	
	<?php
}	
	// Parallax Usage
function seja_parallax_usage_callback($args) { 
     
	$this_option = get_option('seja_parallax_usage');
	
	?>
    <select name="seja_parallax_usage" id="seja_parallax_usage" class="large-text code seja-select">
	<option id="disable" title="disable" value="disable"<?php
		if( ($this_option == 'disable') || ($this_option == '') ) :
			echo ' selected';
		endif;
	?>>Disabled</option>
    <?php seja_dropdown_option( 'parallax', 'Parallax Header', $this_option ); ?>
    <?php seja_dropdown_option( 'banner', 'Banner Image', $this_option ); ?>
	</select>
    <label for="seja_parallax_usage"><?php echo $args[0]; ?></label>'; 
    <p><?php 
    if( SEJA_PARALLAX_USAGE == parallax ): ?>
    This site will have a <span style="color:#f00">parallax header</span>. Any customisations to the header.php file will not be applied.
    <?php 
    endif;   
    if( SEJA_PARALLAX_USAGE == banner ): ?>
    
    The Parallax file will be used as a <span style="color:#f00">banner</span> - you must call the banner in the header file.<br>
    <em>e.g.</em><code>&lt;?php seja_layout( array('type' =&gt; 'banner') );?&gt;</code>

    <?php 
    endif;
    if( SEJA_PARALLAX_USAGE == disable ): ?>
    
    <span style="color:#f00">Parallax image is disabled.</span>
    <?php 
    endif; ?>
    </p>
    <hr>
    <h3> Menus</h3>
    <?php 
	
}
		
	// Enable Mobile Menu
function seja_mobile_menu_callback($args) { 
     
	$this_option = get_option('seja_mobile_menu'); 
	
	?><input type="checkbox" id="seja_mobile_menu" name="seja_mobile_menu" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox"> 
    <label for="seja_mobile_menu"></label><?php echo $args[0]; ?>
    <p>Select this is you wish to use a custom menu for mobile devices.<br>It replaces the responsive menu on mobiles however the menu will continue to shrink according to viewport on tablets and desktop devices.</p>  
	
    <?php
} 

	// Disable Responsive Menu
function seja_responsive_menu_callback($args) { 
     
	$this_option = get_option('seja_responsive_menu'); 
     
    ?><input type="checkbox" id="seja_responsive_menu" name="seja_responsive_menu" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-alt-checkbox">  
    <label for="seja_responsive_menu"></label><?php echo $args[0] ?>
    <p>The responsive menu provides a better user experience in mobile devices, however if you are using a plugin to manage your menu, you may wish to disable this. For more information <a href="admin.php?page=seja-help-page&tab=framework-elements#help-page-mobile-menu">read the following section in the Tips and Help section</a></p>
    <?php 
		// reset the table 
		echo "</table>\n";
		echo '<table class="form-table right-table">'; ?>
    
    <h3>Layouts</h3>
    <?php  
}

	// Index Column Position
function seja_index_columns_callback($args) {
	
	$this_option = get_option('seja_index_columns'); 
	?>

<select name="seja_index_columns" id="seja_index_columns" class="large-text code seja-select">
    <?php seja_dropdown_option( 'left', 'Left Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'right', 'Right Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'single', 'Single (no sidebar)', $this_option ); ?>
	</select>
    <label for="seja_index_columns"><?php echo $args[0]; ?></label>'; 
     
    <?php
}

	// Single Post Column Position 
function seja_single_columns_callback($args) {
	
	$this_option = get_option('seja_single_columns'); 
	
	?>
    <select name="seja_single_columns" id="seja_single_columns" class="large-text code seja-select">
	<?php seja_dropdown_option( 'left', 'Left Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'right', 'Right Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'single', 'Single (no sidebar)', $this_option ); ?>
	</select>
    <label for="seja_single_columns"><?php echo $args[0]; ?></label>
     
    <?php
	
}
 
	// Archive and Category Column Position 
function seja_category_columns_callback($args) {
	
	$this_option = get_option('seja_category_columns'); 
	
	?>
    <select name="seja_category_columns" id="seja_category_columns" class="large-text code seja-select">';
	<?php seja_dropdown_option( 'left', 'Left Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'right', 'Right Sidebar', $this_option ); ?>
    <?php seja_dropdown_option( 'single', 'Single (no sidebar)', $this_option ); ?>
	</select>
    <label for="seja_category_columns"><?php echo $args[0]; ?></label>
     	
	<p>The above settings allow you to layout your Posts while Pages can be adjusted as needed within the editor.<br>
			The sidebar width for ALL content is set below</p>
	<?php
}
 
	// Column Width 
function seja_column_width_callback($args) { 
     
	$this_option = get_option('seja_column_width'); 
     
    ?>
    <select name="seja_column_width" id="seja_column_width" class="large-text code seja-select">
    <?php seja_dropdown_option( '25', '25%', $this_option ); ?>
    <?php seja_dropdown_option( '33', '33%', $this_option ); ?>
    <?php seja_dropdown_option( '50', '50%', $this_option ); ?>
	</select>
    <label for="seja_column_width"><?php echo $args[0]; ?></label>
     
    <?php  
} 

	// Footer Layout PENDING DEPRECIATION
function seja_footer_layout_callback($args) {
	
	$this_option = get_option('seja_footer_layout'); 
		
	?>
    <div id="footer_layout_shell" style="max-width:750px;">
	
    
	<input type="radio" id="seja_footer_layout_default" name="seja_footer_layout" value="default" <?php echo checked('default', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_default"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-default.png">
	</label>
	
	<input type="radio" id="seja_footer_layout_fourcol" name="seja_footer_layout" value="four-column" <?php echo checked('four-column', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_fourcol"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-4col.png">
	</label>
	
	<input type="radio" id="seja_footer_layout_tee" name="seja_footer_layout" value="tee" <?php echo checked('tee', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_tee"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-tee.png">
	</label>
	
	<input type="radio" id="seja_footer_layout_pane" name="seja_footer_layout" value="pane" <?php echo checked('pane', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_pane"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-pane.png">
	</label>
	
	<input type="radio" id="seja_footer_layout_hthree" name="seja_footer_layout" value="horizontal3" <?php echo checked('horizontal3', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_hthree"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-hor3.png">
	</label>
	
	<input type="radio" id="seja_footer_layout_hfour" name="seja_footer_layout" value="horizontal4" <?php echo checked('horizontal4', $this_option, false); ?> class="seja-alt-radio"><label for="seja_footer_layout_hfour"> <img src="<?php bloginfo( 'template_url' ); ?>/images/admin/admin-footer-hor4.png">
	</label>
	
    </div>
    
	<hr style="clear:both">
    <h3>Colours</h3>
    <?php

}	

	// Theme Colour
function seja_bullet_colour_callback($args) {
	
	$this_option = get_option('seja_bullet_colour'); ?>
    
	<input name="seja_bullet_colour" type="text" id="seja_bullet_colour" value="<?php echo $this_option; ?>" class="regular-text seja-colour-pick" />
	<label for="seja_bullet_colour"><?php echo $args[0]; ?></label>
    
    <?php
}
	// Text Colour
function seja_text_colour_callback($args) {
	
	$this_option = get_option('seja_text_colour'); ?>
    
	<input name="seja_text_colour" type="text" id="seja_text_colour" value="<?php echo $this_option; ?>" class="regular-text seja-colour-pick" />
	<label for="seja_text_colour"><?php echo $args[0]; ?></label>
    
    <?php
}
	// Link Colour
function seja_link_colour_callback($args) {
	
	$this_option = get_option('seja_link_colour'); ?>
    
	<input name="seja_link_colour" type="text" id="seja_link_colour" value="<?php echo $this_option; ?>" class="regular-text seja-colour-pick" />
	<label for="seja_link_colour"><?php echo $args[0]; ?></label>
    
    <?php
}
	// Hover Colour
function seja_hover_colour_callback($args) {
	
	$this_option = get_option('seja_hover_colour'); ?>
    
	<input name="seja_hover_colour" type="text" id="seja_hover_colour" value="<?php echo $this_option; ?>" class="regular-text seja-colour-pick" />
	<label for="seja_hover_colour"><?php echo $args[0]; ?></label>
    
    <?php
}
	
	// Copyright Colour
function seja_copyright_colour_callback($args) {
	
	$this_option = get_option('seja_copyright_colour'); ?>
    
	<input name="seja_copyright_colour" type="text" id="seja_copyright_colour" value="<?php echo $this_option; ?>" class="regular-text seja-colour-pick" />
	<label for="seja_copyright_colour"></label>
    <hr>
    <h3>Updates</h3>
    <?php
}

	// Auto-Update - WordPress Core
function seja_update_core_callback($args) {
	
	$this_option = get_option('seja_update_core'); ?>
    
    <div style="border:1px dotted #ccc; background:#e5e5e5; padding:20px; margin-bottom:20px; max-width:700px;"><p><i class="fas fa-exclamation-triangle"></i>
	<strong>IMPORTANT: Read this before adjusting any options below.</strong><br>
	It is recommended that you keep your WordPress install up-to-date at all times and the options below allow the automation of this process, however in some instances it is better to manually update using the <a href="<?php bloginfo( 'url' ); ?>/wp-admin/update-core.php">Updates</a> page</p></div>
	
	<input type="checkbox" id="seja_update_core" name="seja_update_core" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">
    <label for="seja_update_core"></label><?php echo $args[0]; ?>
    <p>Recommended setting: Disabled</p>
	<?php
}

	// Auto-Update -Plugins
function seja_update_plugins_callback($args) {
	
	$this_option = get_option('seja_update_plugins'); ?>
    
    <input type="checkbox" id="seja_update_plugins" name="seja_update_plugins" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">  
    <label for="seja_update_plugins"></label><?php echo $args[0]; ?>
    <p>Recommended setting: Disabled</p>
    <?php
}

	// Auto-Update - Themes
function seja_update_themes_callback($args) {	
	
	$this_option = get_option('seja_update_themes');?>
    
    <input type="checkbox" id="seja_update_themes" name="seja_update_themes" value="1" <?php echo checked(1, $this_option, false); ?> class="seja-checkbox">
    <label for="seja_update_themes"></label><?php echo $args[0]; ?>
	<p>Recommended setting: Disabled<br><em>Theme update only updates other installed themes - This custom theme cannot be automatically updated</em></p>
      
    <?php
} 



