<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * 4.5 - Theme Help - Customising the layout (Developers guide)
 * ------------------------------------------------------------------------ */
 
function seja_developers_content_callback($args) { 
	?>

<div id="accordion">
  <h3>Usage</h3>
  <div> <code>seja_layout( array( 'type' =&gt; 'foo', 'options' =&gt; 'bar') );</code>
    <p>options – multiple options can be used (some may be  required)</p>
    <p><strong>type </strong>(required) – Sets the block<br>
      <strong>id</strong> – Sets an ID for the item being called in the layout type<br>
      <strong>class</strong>- Sets a class for the item  being called – or – defines the sub-type<br>
      <strong>option</strong> – custom call as needed </p>
  </div>
  <h3>Header</h3>
  <div>
    <p>Creates the header inner div (header outer div is fixed)</p>
    <table>
      <tr>
        <td>type</td>
        <td>header</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>id</td>
        <td>user-defined</td>
        <td>Optional (Recommended: &quot;header&quot;)</td>
      </tr>
      <tr>
        <td>class</td>
        <td>Automatic or user-defined</td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Special Notes</h4>
    <p>Class is added automatically and outputs &lsquo;inner-wrapper&rsquo;. If  a user defined class is added, it will replace the default</p>
    <h4>Example</h4>
    <code>seja_layout( array('type' =&gt; 'header', 'id' =&gt; 'header') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div class=&quot;inner-wrapper&quot; id=&quot;header&quot;&gt;</pre>
  </div>
  <h3>Logo</h3>
  <div>
    <p>Gets logo image details from database (can be used as a text  only title) and wraps it in a link to the home page</p>
    <table>
      <tr>
        <td>type</td>
        <td>logo</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>class</td>
        <td>Automatic + user-defined</td>
        <td>Optional</td>
      </tr>
      <tr>
        <td>option</td>
        <td>User defined text </td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Example 1</h4>
    <code>seja_layout(  array('type' =&gt; 'logo') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div class=&quot;header-img&quot;&gt;
   &lt;a href=&quot;template_url&quot;&gt;
      &lt;img src=&quot;LOGO_URL&quot;  width=&quot;LOGO_WIDTH&quot; height=&quot;LOGO_HEIGHT&quot;  alt=&quot;logo&quot;&gt;
   &lt;/a&gt;
&lt;/div&gt;&lt;!--.header-img --&gt; </pre>
    <h4>Example 2</h4>
    <p><em>Alternative (using text and the optional class)</em></p>
    <code>seja_layout(  array('type' =&gt; 'logo' 'option' =&gt; 'text in here', 'class' =&gt; 'user-defined')  );</code>
    <p><em>Output</em></p>
    <pre>&lt;div  class=&quot;header-img user-defined&quot;&gt;
   &lt;a href=&quot;TEMPLATE_URL&quot;&gt;
      &lt;h2&gt;text in here&lt;/h2&gt;
   &lt;/a&gt;
&lt;/div&gt;&lt;!--.header-img --&gt;</pre>
  </div>
  <h3>Header Widget Area</h3>
  <div>
    <p>Inserts the header widget area</p>
    <table>
      <tr>
        <td>type</td>
        <td>hwidget</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>class</td>
        <td>header-contact + user-defined</td>
        <td>Optional</td>
      </tr>
      <tr>
        <td>id</td>
        <td>user-defined</td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout( array('type' =&gt; 'contact', 'class' =&gt; 'user-defined', 'id' =&gt; 'user-defined')  );</code>
    <p><em>Output</em></p>
    <pre>&lt;div class=&quot;header-contact user-defined&quot;  id=&quot;user-defined&quot;&gt;
   &lt;div  class=&quot;widget-area&quot;&gt;
      &lt;ul class=&quot;xoxo  no-bullet&quot;&gt;
         <span class="color:red">WIDGET</span>
      &lt;/ul&gt;
   &lt;/div&gt;
&lt;/div&gt;</pre>
  </div>
  <h3>Navigation / Walker</h3>
  <div>
    <p>Creates the navigation block and menu </p>
    <table>
      <tr>
        <td>type</td>
        <td>navigation</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>type</td>
        <td>walker</td>
        <td>Optional (uses walker menu)</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout( array('type' =&gt; 'navigation') );</code>
    <p><em>or</em></p>
    <code>seja_layout( array('type' =&gt; 'walker') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div id=&quot;navigation&quot;&gt;
   &lt;nav&gt;
      &lt;div  class=&quot;menu-header inner-wrapper&quot;&gt;
         &lt;ul  id=&quot;seja-framework-menu&quot; class=&quot;menu-header&quot;&gt;
            WORDPRESS GENERATED MENU (default or walker)
         &lt;/ul&gt;
      &lt;/div&gt;
   &lt;/nav&gt;
&lt;/div&gt;&lt;!--  #navigation --&gt;</pre>
  </div>
  <h3>Content</h3>
  <div>
    <p>Closes off the header&rsquo;s inner and outer content, then opens  the content-shell</p>
    <table>
      <tr>
        <td>type</td>
        <td>content</td>
        <td>Required</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout( array('type' =&gt; 'content') );</code>
    <p><em>Output</em></p>
    <pre>   &lt;/div&gt;&lt;!-- .inner-wrapper (header block) --&gt;<br>&lt;/div&gt;&lt;!-- .outer-wrapper (header block) --&gt;<br>&lt;div id=&quot;content-shell&quot;&gt;</pre>
  </div>
  <h3>Top Content</h3>
  <div>
    <p>Places the #top-content div. This can be positioned at the end  of the header, or the beginning of the content shell, depending on requirements</p>
    <table>
      <tr>
        <td>type</td>
        <td>top-content</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>option</td>
        <td>$current_id</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>class</td>
        <td>User-defined</td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout(  array('type' =&gt; 'top-content', 'option' =&gt; $current_id), 'class' =&gt; 'user-defined'  );</code>
    <p><em>Output</em></p>
    <pre>&lt;div  id=&quot;top-content-block&quot; class=&quot;user-defined&quot;&gt;
   WORDPRESS CONTENT
&lt;/div&gt;</pre>
  </div>
  <h3>Start of Page</h3>
  <div>
    <p>The main template opening call</p>
    <table>
      <tr>
        <td>type</td>
        <td>spage</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>option</td>
        <td>left</td>
        <td>Optional</td>
      </tr>
      <tr>
        <td>option</td>
        <td>right</td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Example 1</h4>
    <code>seja_layout(  array('type' =&gt; 'spage') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div  id=&quot;content&quot; class=&quot;inner-wrapper&quot;&gt;
   &lt;div  class=&quot;single-column&quot;&gt;</pre>
    <h4>Example 2</h4>
    <code>seja_layout( array('type'  =&gt; 'spage', 'option' =&gt; 'left') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div  id=&quot;content&quot; class=&quot;inner-wrapper&quot;&gt;
   &lt;div class=&quot;colmask two-left-WIDTH&quot;&gt;
      &lt;div  class=&quot;colmid&quot;&gt;
         &lt;div  class=&quot;colleft&quot;&gt;
            &lt;div  class=&quot;col1&quot;&gt;</pre>
    <h4>Example 3</h4>
    <code>seja_layout(  array('type' =&gt; 'spage', 'option' =&gt; 'right') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div  id=&quot;content&quot; class=&quot;inner-wrapper&quot;&gt;
   &lt;div class=&quot;colmask two-right-WIDTH&quot;&gt;
      &lt;div  class=&quot;colmid&quot;&gt;
         &lt;div  class=&quot;colleft&quot;&gt;
            &lt;div  class=&quot;col1&quot;&gt;</pre>
  </div>
  <h3>End of Page</h3>
  <div>
    <p>Creates the header inner div (header outer div is fixed)</p>
    <table>
      <tr>
        <td>type</td>
        <td>epage</td>
        <td>Required</td>
      </tr>
      <tr>
        <td>option</td>
        <td>blog</td>
        <td>Optional</td>
      </tr>
      <tr>
        <td>option</td>
        <td>page</td>
        <td>Optional</td>
      </tr>
    </table>
    <h4>Example 1</h4>
    <code>seja_layout(  array('type' =&gt; 'epage' ) );</code>
    <p><em>Output</em></p>
    <pre>         &lt;/div&gt;&lt;!-- end col --&gt;
      &lt;div  style=&quot;clear:both&quot;&gt;&lt;/div&gt;
   &lt;div  id=&quot;back-to-top&quot;&gt;&lt;a href=&quot;#top&quot; class=&quot;hashlink&quot;&gt;Top&lt;/a&gt;&lt;/div&gt;
&lt;/div&gt;&lt;!-- .content --&gt;</pre>
    <h4>Example 2</h4>
    <code>seja_layout(  array('type' =&gt; 'epage', 'option' =&gt; 'blog') );</code>
    <p><em>or</em></p>
    <code>seja_layout(  array('type' =&gt; 'epage', 'option' =&gt; 'page') );</code>
    <p><em>Output</em></p>
    <pRE>                  &lt;/div&gt;&lt;!--  end col --&gt;
                  &lt;div  class=&quot;col2&quot;&gt;
                     SIDEBAR (PAGE / BLOG)
                  &lt;/div&gt;&lt;!--  end col 2 --&gt;
               &lt;/div&gt;&lt;!--.colleft--&gt;
            &lt;/div&gt;&lt;!--  .colmid--&gt;
         &lt;/div&gt;&lt;!--.colmask--&gt;
      &lt;div  style=&quot;clear:both&quot;&gt;&lt;/div&gt;
   &lt;div  id=&quot;back-to-top&quot;&gt;&lt;a href=&quot;#top&quot;  class=&quot;hashlink&quot;&gt;Top&lt;/a&gt;&lt;/div&gt;
&lt;/div&gt;&lt;!-- .content --&gt;</pre>
  </div>
  <h3>Start of Footer</h3>
  <div>
    <p>Close off the content and start the footer</p>
    <table>
      <tr>
        <td>type</td>
        <td>sfoot</td>
        <td>Required</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout(  array('type' =&gt; 'sfoot' ) );</code>
    <p><em>Output</em></p>
    <pre>&lt;/div&gt;&lt;!--  end #content-shell --&gt;
&lt;div id=&quot;footer-shell&quot;&gt;
   &lt;div id=&quot;footer&quot;&gt;</pre>
  </div>
  <h3>Footer Widget Area</h3>
  <div>
    <p>Creates the colophon and footer widgets</p>
    <table>
      <tr>
        <td>type</td>
        <td>fwidget</td>
        <td>Required</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout(  array('type' =&gt; 'fwidget' ) );</code>
    <p><em>Output</em></p>
    <pre>&lt;div id=&quot;colophon&quot;  class=&quot;layout-type-DYNAMIC&quot;&gt;
   &lt;div id=&quot;footer&quot;&gt;
      DYNAMIC WIDGET AREAS IF SET IN DASHBOARD > APPEARANCE > WIDGETS
      &lt;div id=&quot;first&quot; class=&quot;widget-area&quot;&gt;
         &lt;ul class=&quot;xoxo&quot;&gt;
            WIDGET
         &lt;/ul&gt;
      &lt;/div&gt;&lt;!-- end #first .widget-area --&gt;
      &lt;div id=&quot;second&quot; class=&quot;widget-area&quot;&gt;
         &lt;ul class=&quot;xoxo&quot;&gt;
            WIDGET
         &lt;/ul&gt;
      &lt;/div&gt;&lt;!-- end #second .widget-area --&gt;
      &lt;div id=&quot;third&quot; class=&quot;widget-area&quot;&gt;
         &lt;ul class=&quot;xoxo&quot;&gt;
            WIDGET
         &lt;/ul&gt;
      &lt;/div&gt;&lt;!-- end #third .widget-area --&gt;
      FOURTH WIDGET AREA IF SET IN SEJA TEMPLATE
      &lt;div id=&quot;fourth&quot; class=&quot;widget-area&quot;&gt;
         &lt;ul class=&quot;xoxo&quot;&gt;
            WIDGET
         &lt;/ul&gt;
      &lt;/div&gt;&lt;!-- end #fourth .widget-area --&gt;
   &lt;/div&gt;
&lt;/div&gt;&lt;!-- end #colophon  --&gt;</pre>
  </div>
  <h3>Copyright</h3>
  <div>
    <p>Closes off the header&rsquo;s inner and outer content, then opens  the content-shell</p>
    <table>
      <tr>
        <td>type</td>
        <td>copyright</td>
        <td>Required</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout(  array('type' =&gt; 'copyright') );</code>
    <p><em>Output</em></p>
    <pre>&lt;div id=&quot;copyright-wrapper&quot;&gt;
   &lt;div class=&quot;site-info&quot;&gt;
      &lt;a href=&quot;HOME PAGE&quot;  title=&quot;SITE NAME&quot; rel=&quot;home&quot;&gt;&amp;copy; YEAR SITE  NAME&lt;/a&gt;
   &lt;/div&gt;&lt;!-- end #site-info  --&gt;
   &lt;div class=&quot;copyrght&quot;&gt;
      &lt;a href=&quot;http://wordpress.org/&quot;  title=&quot;Semantic Personal Publishing Platform&quot;&gt;
         &lt;svg&gt;WORDPRESS  LOGO&lt;/svg&gt;
      &lt;/a&gt;
      &lt;a href=&quot;https://www.seja-design.com.au/&quot;  title=&quot;WordPress Design Perth | Wordpress Perth&quot;&gt;
         &lt;svg&gt;SEJA  LOGO&lt;/svg
      &lt;/a&gt;
   &lt;/div&gt;
&lt;/div&gt;&lt;!-- end #copyright-wrapper --&gt;</pre>
  </div>
  <h3>End of Footer</h3>
  <div>
    <p>Creates the header inner div (header outer div is fixed)</p>
    <table>
      <tr>
        <td>type</td>
        <td>efoot</td>
        <td>Required</td>
      </tr>
    </table>
    <h4>Example</h4>
    <code>seja_layout( array('type' =&gt; 'efoot') );</code>
    <p><em>Output</em></p>
    <pre>            &lt;/div&gt;&lt;!-- end #footer  --&gt;
         &lt;/div&gt;&lt;!-- end  #footer-shell --&gt;
      WORDPRESS FOOTER
   &lt;/body&gt;
&lt;/html&gt;&lt;!-- end of seja framework page --&gt;</pre>
  </div>
</div>
<?php

}
function seja_developers_header_callback($args) { 
?>
<h4>Left logo, Right contact, Lower menu (Old Default)</h4>
<code>seja_layout( array('type' => 'header', 'id' => 'header' ) );<br>
seja_layout( array('type' => 'logo') );<br>
seja_layout( array('type' => 'contact') );<br>
seja_layout( array('type' => 'navigation') );
</code>
<h4>100% Banner image</h4>
<code>seja_layout( array('type' => 'header', 'id' => 'header' ) );<br>
seja_layout( array('type' => 'banner') );<br>
seja_layout( array('type' => 'logo') );<br>
seja_layout( array('type' => 'navigation') );
</code>
<h4>Parallax (Based on 2017 theme)</h4>
<p>Set the Parallax image useage as 'Parallax Header' in Theme Settings.<br>
  Do not add anything else to the header.php file, any customisations will not be applied.</p>
<h4>Custom</h4>
<p>Edit the order of the layout calls as required, or rewrite the HTML directly.</p>
<?php } ?>
