<?php 
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 2.16
 *
 * Framework base includes file
 *
 * Versions are based on Major | Minor x2 | Sub x2 
 *		eg. version 2.4.7 would be 20407 | version 2.14 is 21400
 *
 * ------------------------------------------------------------------------ */
 
 if ( ! defined( 'ABSPATH' ) ) { exit; }
 	
	// first define our file locations for the various includes here
	define ( 'SEJA_FRAMEWORK', get_template_directory() . '/includes' );
	// framework version
	define ( 'SEJA_FRAMEWORK_VERSION', '21600' );
	
	// Definitions - Sets our themes definitions
	require( SEJA_FRAMEWORK . '/structure/definitions.php' );
	
	// pre-setup - only runs once
	$check_update = get_option( 'seja_framework_version' );
	
	
	if( empty( $check_update ) ) $check_update = '1';
	if ( $check_update < SEJA_FRAMEWORK_VERSION )
		require( SEJA_FRAMEWORK . '/structure/dashboard/template_initial.php' );
	
	// Seja Template - The Dashboard Settings pages
	require( SEJA_FRAMEWORK . '/structure/dashboard/settings.php' );
	
	// Page layout - literally the seja_layout function
	require( SEJA_FRAMEWORK . '/functions/layouts.php' );
	
	// Page layout - Custom Fields
	require( SEJA_FRAMEWORK . '/functions/customfields.php' );
	
	// Shortcodes
	require( SEJA_FRAMEWORK . '/functions/shortcodes.php' );
	
	// TinyMCE Styles
	require( SEJA_FRAMEWORK . '/functions/tinymce.php' );
	
	// All other default functions
	require( SEJA_FRAMEWORK . '/functions/general.php' );
	
	// woocommerce
	if ( SEJA_WOO_SUPPORT == '1' )
		require( SEJA_FRAMEWORK . '/functions/woocommerce.php' );
		
	// Custom functions file TO BE DEPRECIATED - customisations at root level
	//require( get_template_directory() . '/includes/custom/functions.php' );
?>