<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * WooCommerce customisations
 * ------------------------------------------------------------------------ */
if ( ! defined( 'ABSPATH' ) ) { exit; }


add_theme_support( 'woocommerce' ); 

/* ------------------------------------------------------------------------ * 
 * Formatting - Main structure
 * ------------------------------------------------------------------------ */

		// This section adapts WooCommerce to our framework
		remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
		remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
		
		add_action('woocommerce_before_main_content', 'seja_woo_theme_start', 10);
		add_action('woocommerce_after_main_content', 'seja_woo_theme_end', 10);

		function seja_woo_theme_start() {
			
			// creates the start of the woo template
			
			$seja_woo_custom_class = '';
			$seja_woo_catalogue = '';
			
			if( get_post_meta( $GLOBALS['current_id'], 'seja_woo_custom_class', true ) != '' ) 
			
			$seja_woo_custom_class = ' ' . get_post_meta( $GLOBALS['current_id'], 'seja_woo_custom_class', true );
			
			if( get_post_meta( $GLOBALS['current_id'], 'seja_woo_catalogue', true ) == 'yes' ) 
			$seja_woo_catalogue = ' catalogue-mode';
			
			//print_r( get_post_meta( $GLOBALS['current_id'] ) );
			
			$html = '<!-- shop include -->';
			$html .= '<div id="content" class="inner-wrapper';
			if( SEJA_WOOPAGE_COLUMNS == 'slideout' ) :
				// add in the css class
				$html .= ' slideout-sidebar';
			endif;
			$html .= '">';
			if( SEJA_WOOPAGE_COLUMNS == 'slideout' ) :
				$html .= '<div class="colmask two-fixed">';
			else :
				$html .= '<div class="colmask two-' . SEJA_WOOPAGE_COLUMNS . '-' . SEJA_COLUMN_WIDTH . '">';
			endif;	
			$html .= '<div class="colmid">';
			$html .= '<div class="colleft">';
			$html .= '<div class="col1 no-slider">
			';
			$html .= '<div class="woo-main' . $seja_woo_custom_class . $seja_woo_catalogue . '">';
			
			echo $html;
		}

		
		function seja_woo_theme_end() {
			
			// close the main column, add the sidebar, then close the template
			$html = '</div>';
			$html .= '</div> <!-- end main column -->';
			if( SEJA_WOOPAGE_COLUMNS == 'slideout' ) :			
				$html .= '<input type="checkbox" id="slide" name="" value="">';
				$html .= '<label for="slide" class="toggle"><i class="fas fa-shopping-cart"></i></label>';
				
			endif;	
			$html .= '<div class="col2">';
			if( SEJA_WOOPAGE_COLUMNS == 'slideout' ) :
			
			endif;
			
			echo $html;
			get_sidebar( 'shop' ); 
			
			$html = '';
			if( SEJA_WOOPAGE_COLUMNS == 'slideout' ) :
				$html .= '<div style="clear:both"></div>';
			endif;
			$html .= '</div> <!-- end col -->';
			
			$html .= '</div> <!--.colleft-->';
			$html .= '</div> <!-- .colmid-->';
			$html .= '</div>';
			$html .= '<div style="clear:both"></div>';
			$html .= '</div>';
			
			echo $html;
		}

		
/* ------------------------------------------------------------------------ * 
 * Backend - Add BSB for bank transfers
 * ------------------------------------------------------------------------ */		
		// correct the lack of 'BSB' for bank transfers
		function seja_woo_bacs_ibn($translation, $text, $domain) {
			if ($domain == 'woocommerce') {
				switch ($text) {
					case 'Sort Code':
						$translation = 'BSB';
						break;
				}

			}

		 
			return $translation;
		}

		add_filter('gettext', 'seja_woo_bacs_ibn', 10, 3);

/* ------------------------------------------------------------------------ * 
 * Formatting - Number of products per row / Number of rows
 * ------------------------------------------------------------------------ */
		
		// Set number of products per row
		if (!function_exists('seja_prod_columns')) {
			function seja_prod_columns() {
				return SEJA_WOO_COL;
			}

		}

		add_filter('loop_shop_columns', 'seja_prod_columns');
		
		// Set number of products per page
		add_filter( 'loop_shop_per_page', create_function( '$cols', 'return SEJA_WOO_TOTALPRODUCTS;' ), 20 );
		
		// change the default display thumbnail
		add_action( 'init', 'custom_fix_thumbnail' );
		function custom_fix_thumbnail() {
			add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
			function custom_woocommerce_placeholder_img_src( $src ) {
				$src = get_template_directory_uri() . '/images/shop-placeholder.png';
				return $src;
			}

		}

		
/* ------------------------------------------------------------------------ * 
 * Formatting - Register CSS
 * ------------------------------------------------------------------------ */		
		// add our custom css using a function to force it to display after the plugin's stylesheet
		function register_seja_woocommerce_css() {
		
			$woocom_css = get_template_directory_uri() . '/css/woocommerce.css';
			wp_enqueue_style( 'seja-woocommerce', $woocom_css, __FILE__);
		}

		
		add_action('wp_enqueue_scripts', 'register_seja_woocommerce_css', 20);
		
		
/* ------------------------------------------------------------------------ * 
 * Disable Variable Product Price Range
 * ------------------------------------------------------------------------ */		
		
	if( SEJA_WOO_DISABLE_PRICERANGE == '1' ) :
		add_filter( 'woocommerce_variable_sale_price_html', 'seja_variation_price_format', 10, 2 );
		add_filter( 'woocommerce_variable_price_html', 'seja_variation_price_format', 10, 2 );
		function seja_variation_price_format( $price, $product ) {
		 
		// Main Price
		$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
		$price = $prices[0] !== $prices[1] ? sprintf( __( 'From: %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
		 
		// Sale Price
		$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
		sort( $prices );
		$saleprice = $prices[0] !== $prices[1] ? sprintf( __( 'From: %1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
		 
		if ( $price !== $saleprice ) {
		$price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
		}

		return $price;
		}

	
		/* end Disable Variable Product Price Range $$$-$$$  */
	endif;
	
/* ------------------------------------------------------------------------ * 
 * Disable Related Products
 * ------------------------------------------------------------------------ */	
 
 	if( SEJA_WOO_REMOVE_RELATED == '1' ) :
	
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
		
	endif;
	
/* ------------------------------------------------------------------------ * 
 * Disable Additional Information tab
 * ------------------------------------------------------------------------ */	
 
 	if( SEJA_WOO_REMOVE_ADDITIONALTAB  == '1' ) :
	
		add_filter( 'woocommerce_product_tabs', 'seja_remove_product_tabs', 98 );
 
		function seja_remove_product_tabs( $tabs ) {
			unset( $tabs['additional_information'] ); 
			return $tabs;
		}

		
	endif;
	
/* ------------------------------------------------------------------------ * 
 * Custom Fields
 * ------------------------------------------------------------------------ */

	
	function woo_add_custom_general_fields() {

	  global $woocommerce, $post;
	  echo '<div class="options_group">';
	  
	  // Custom fields will be created here...
	  woocommerce_wp_text_input( 
			array( 
				'id'          => 'seja_woo_custom_class', 
				'label'       => __( 'Custom Class', 'woocommerce' ), 
				'placeholder' => 'Custom Class',
				'desc_tip'    => 'true',
				'description' => __( 'Add a custom Product Class here.', 'woocommerce' ) 
			)			
		);
		woocommerce_wp_checkbox( 
			array( 
				'id'            => 'seja_woo_catalogue', 
				'wrapper_class' => 'show_if_simple', 
				'label'         => __('Catalogue Only Item', 'woocommerce' ), 
				'description'   => __( 'Hides the Add to Cart form', 'woocommerce' ) 
			)
		);
	  
	  echo '</div>';
		
	}

	
	function woo_add_custom_general_fields_save( $post_id ){
	
	// Text Field
		$woocommerce_text_field = $_POST['seja_woo_custom_class'];
		if( !empty( $woocommerce_text_field ) )
			update_post_meta( $post_id, 'seja_woo_custom_class', esc_attr( $woocommerce_text_field ) );
			
		$woocommerce_checkbox = isset( $_POST['seja_woo_catalogue'] ) ? 'yes' : 'no';
			update_post_meta( $post_id, 'seja_woo_catalogue', $woocommerce_checkbox );
	}


	add_action( 'woocommerce_product_options_general_product_data', 'woo_add_custom_general_fields' );
	add_action( 'woocommerce_process_product_meta', 'woo_add_custom_general_fields_save' );
	
	
/* ------------------------------------------------------------------------ * 
 * Sort Alphabetically
 * ------------------------------------------------------------------------ */
	
	add_filter( 'woocommerce_get_catalog_ordering_args', 'custom_woocommerce_get_catalog_ordering_args' );

	function custom_woocommerce_get_catalog_ordering_args( $args ) {
		$orderby_value = isset( $_GET['orderby'] ) ? woocommerce_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
	
		if ( 'alphabetical' == $orderby_value ) {
			$args['orderby'] = 'title';
			$args['order'] = 'ASC';
		}

	
		return $args;
	}

	
	add_filter( 'woocommerce_default_catalog_orderby_options', 'custom_woocommerce_catalog_orderby' );
	add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );
	
	function custom_woocommerce_catalog_orderby( $sortby ) {
		$sortby['alphabetical'] = __( 'Alphabetical' );
		return $sortby;
	}

	
/* ------------------------------------------------------------------------ * 
 * Gridlist toggle button
 * ------------------------------------------------------------------------ */	
 
	function seja_gridlist_toggle_button() {

		?>
			<nav class="seja-gridlist-toggle">
				<a href="#" id="grid" title="<?php _e('Grid view', 'woocommerce-grid-list-toggle'); ?>"><i class="fas fa-th" aria-hidden="true"></i> <em><?php _e( 'Grid view', 'woocommerce-grid-list-toggle' ); ?></em></a><a href="#" id="list" title="<?php _e('List view', 'woocommerce-grid-list-toggle'); ?>"><i class="fas fa-list" aria-hidden="true"></i> <em><?php _e( 'List view', 'woocommerce-grid-list-toggle' ); ?></em></a>
			</nav>
		<?php
	}

	
	function seja_gridlist_set_default_view() {
		$default = get_option( 'wc_glt_default' );
		?>
		<script>
			if (jQuery.cookie( 'gridcookie' ) == null) {
				jQuery( 'ul.products' ).addClass( '<?php echo $default; ?>' );
				jQuery( '.gridlist-toggle #<?php echo $default; ?>' ).addClass( 'active' );
			}

		</script>
		<?php
	}

	function seja_gridlist_buttonwrap_open() {
		echo '<div class="gridlist-buttonwrap">';
	}

	function seja_gridlist_buttonwrap_close() {
		echo '</div>';
	}

	function seja_gridlist_hr() {
		echo '<hr>';
	}

	function gridlist_cat_desc( $category ) {
		global $woocommerce;
		echo '<div itemprop="description">';
			echo $category->description;
			echo '</div>';
	}

	
	add_option( 'wc_glt_default', 'grid' );							
	add_action( 'woocommerce_before_shop_loop', 'seja_gridlist_toggle_button', 10);
	add_action( 'woocommerce_after_shop_loop_item', 'seja_gridlist_buttonwrap_open', 9);
	add_action( 'woocommerce_after_shop_loop_item', 'seja_gridlist_buttonwrap_close', 11);
	add_action( 'woocommerce_after_shop_loop_item', 'seja_gridlist_hr', 30);
	add_action( 'woocommerce_after_subcategory', 'gridlist_cat_desc');
	add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_single_excerpt', 5);
	add_action( 'wp_footer', 'seja_gridlist_set_default_view');
	wp_register_script( 'seja_woo_jq', get_template_directory_uri() . '/js/seja-woocommerce.js', 'jquery' );
	
	/* this appears to be working, but I won't know until I try it on a fresh site. A copy of the remainding script from the plugin is found in the S:\Onedrive\assets\framework directory */