<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * Formatting - TinyMCE Start of section
 * ------------------------------------------------------------------------ */
 
 if ( ! defined( 'ABSPATH' ) ) { exit; }
 
		function sejaMCE_button() {
			   if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
					 return;
			   }
			   if ( get_user_option('rich_editing') == 'true' ) {
					 add_filter( 'mce_external_plugins', 'add_plugin' );
					 add_filter( 'mce_buttons', 'register_button' );
			   }
		}
		
		add_action('init', 'sejaMCE_button');
		
/* ------------------------------------------------------------------------ * 
 * Formatting - TinyMCE Kitchensink
 * ------------------------------------------------------------------------ */
		
		function seja_force_kitch_sink_on(){
		  set_user_setting('hidetb', 1);
		}
		
		add_action('auth_redirect', 'seja_force_kitch_sink_on');
		
/* ------------------------------------------------------------------------ * 
 * Formatting - TinyMCE Top row and External plugins
 * ------------------------------------------------------------------------ */
		
		function register_button( $buttons ) {
			
		  array_push( $buttons, "|", "youtube", "facebook", "divanchor", "clearfloat", "mosaic" );
		 return $buttons;
		}
		
		// call to external javascript file to get buttons to work
		function add_plugin( $plugin_array ) {
		   $plugin_array['mylink'] = get_bloginfo( 'template_url' ) . '/js/seja-tinymce.js';		
		   return $plugin_array;
		}
		
		
/* ------------------------------------------------------------------------ * 
 * Formatting - TinyMCE Styles
 * ------------------------------------------------------------------------ */

add_filter( 'tiny_mce_before_init', 'my_mce_before_init' );
		
		function my_mce_before_init( $settings ) {
		
			$style_formats = array(
				array(
				'title' => 'Formatting',
				'icon' => 'seja-write',
				'items' => array(
					array(
						'title' => 'Button',
						'selector' => 'a',
						'classes' => 'button',
						'icon' => 'seja-button'
					),
					array(
						'title' => 'Subtitle',
						'block' => 'h2',
						'classes' => 'subtitle',
						'icon' => 'seja-subtitle'
					),
					array(
						'title' => 'Highlight',
						'inline' => 'span',
						'classes' => 'highlight',
						'icon' => 'seja-highlight'
					),
					array(
						'title' => 'Alt Colour',
						'inline' => 'span',
						'classes' => 'alt-colour',
						'icon' => 'seja-altcol'
					),
					array(
						'title' => 'Blockquote',
						'block' => 'blockquote',
						'icon' => 'seja-blockquote'
					),
					array(
						'title' => 'Smooth Scroll',
						'selector' => 'a',
						'classes' => 'scroll',
						'icon' => 'seja-scroll'
					),
					array(
						'title' => 'Lightbox',
						'selector' => 'a',
						'classes' => 'lbp_secondary',
						'icon' => 'seja-lightbox'
					)
				)
			),
			array(
				'title' => ' 1/2 Layout',
				'icon' => 'seja-layout50',
				'items' => array(
					array(
						'title' => 'Left Column',
						'block' => 'div',
						'classes' => 'block50 first-block',
						'wrapper' => true,
						'icon' => 'seja-layout50'
					),				
					array(
						'title' => 'Right Column',
						'block' => 'div',
						'classes' => 'block50 last-block',
						'wrapper' => true,
						'icon' => 'seja-layout50'
					)
				)
			),
			array(
				'title' => ' 1/3 Layout',
				'icon' => 'seja-layout33',
				'items' => array(
					array(
						'title' => 'Left Column',
						'block' => 'div',
						'classes' => 'block33 first-block',
						'wrapper' => true,
						'icon' => 'seja-layout33'
					),				
					array(
						'title' => 'Center Column',
						'block' => 'div',
						'classes' => 'block33 middle-block',
						'wrapper' => true,
						'icon' => 'seja-layout33'
					),
					array(
						'title' => 'Right Column',
						'block' => 'div',
						'classes' => 'block33 last-block',
						'wrapper' => true,
						'icon' => 'seja-layout33'
					)
				)
			),
			array(
				'title' => ' 1/4 Layout',
				'icon' => 'seja-layout25',
				'items' => array(
					array(
						'title' => 'First Column',
						'block' => 'div',
						'classes' => 'block25 first-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					),				
					array(
						'title' => 'Second Column',
						'block' => 'div',
						'classes' => 'block25 second-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					),
					array(
						'title' => 'Third Column',
						'block' => 'div',
						'classes' => 'block25 third-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					),
					array(
						'title' => 'Fourth Column',
						'block' => 'div',
						'classes' => 'block25 last-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					)
				)
			),
			array(
				'title' => ' Other Layouts',
				'icon' => 'seja-layout100',
				'items' => array(
					array(
						'title' => 'Clear Float',
						'selector' => 'p, h2, h3, h4, h5',
						'classes' => 'clear',
						'wrapper' => true,
						'icon' => 'seja-clearfloat'
					),
					array(
						'title' => 'Full Width (Use to reset floats)',
						'block' => 'div',
						'classes' => 'block100',
						'wrapper' => true,
						'icon' => 'seja-layout100'
					),
					array(
						'title' => 'Custom Block',
						'block' => 'div',
						'classes' => 'custom-block',
						'wrapper' => true,
						'icon' => 'seja-layoutcustom'
					),
					array(
						'title' => 'Hyperlink Block',
						'block' => 'div',
						'classes' => 'link-div',
						'wrapper' => true,
						'icon' => 'seja-layoutlink'
					),
					array(
						'title' => '2/3 Left column',
						'block' => 'div',
						'classes' => 'block66 first-block',
						'wrapper' => true,
						'icon' => 'seja-layout33'
					),
					array(
						'title' => '2/3 Layout Right column',
						'block' => 'div',
						'classes' => 'block66 last-block',
						'wrapper' => true,
						'icon' => 'seja-layout33'
					),
					array(
						'title' => '3/4 Left column',
						'block' => 'div',
						'classes' => 'block75 first-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					),
					array(
						'title' => '3/4 Right Column',
						'block' => 'div',
						'classes' => 'block75 last-block',
						'wrapper' => true,
						'icon' => 'seja-layout25'
					)
				)
			)
		);
			$settings['toolbar2'] = 'strikethrough,underline,alignjustify,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help,hr,|,styleselect ';		
			$settings['style_formats'] = json_encode( $style_formats );
		
			return $settings;
		
		}