<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Shortcode functions - START OF SECTION 
 *
 * ------------------------------------------------------------------------ */
if ( ! defined( 'ABSPATH' ) ) { exit; }
	
	// deal with the autop issue
	remove_filter( 'the_content', 'wpautop' );
	add_filter( 'the_content', 'wpautop' , 99 );
	add_filter( 'the_content', 'shortcode_unautop', 100 );

/* ------------------------------------------------------------------------ * 
 * Shortcode - jQuery Accordion 
 * ------------------------------------------------------------------------ */

		function seja_accordion($atts, $content = null) {
			extract(shortcode_atts(array(
				'id' => 'accordion',
				'title' => 'Don\'t forget to add a name to this block using \'title="whatever you want the title to be"\'.',
				'class' => 'block',
				'titleclass' => 'null',
				), $atts));
			
			// start the accordion
			if( $class == 'first' ) :
				$start_accordian = '<dl class="accordion" id="' . $id . '">'; 
			else:
				$start_accordian = '';
			endif;
			
			// title class
			if ( $titleclass != 'null' ) :
				$title_class = ' class="' . $titleclass . '">';
			endif;
			
			//end the accordion
			if( $class == 'last' ) :
				$end_accordian = '</dd></dl>'; 
			else:
				$end_accordian = '</dd>';
			endif;
			
			//$content = wpautop(trim($content)); DEPRECIATED - AUTOP
			return $start_accordian . '<dt' . $title_class . '><span>' . $title . '</span></dt>
		<dd class="' . $class . '">'. $content . $end_accordian;
		}
		
		
		function seja_accordion_footer() {
				echo("<script type=\"text/javascript\">
		(function($) {
			
		  var allPanels = $('.accordion > dd').hide();
			
		  $('.accordion > dt > span').click(function() {
			if ($(this).hasClass('selected')) {
					   $(this).removeClass('selected');
					   $(this).parent().next().slideUp();
				  } else {
					   $('#accordion dt span').removeClass('selected');
					   $(this).addClass('selected');
					   $('#accordion dd').slideUp();
					   $(this).parent().next().slideDown();
				  }
			return false;
		  });
		
		})(jQuery);
		</script>");
			}
		
				
		if ( SEJA_ENABLE_ACCORDION  == '1') :
			add_action('wp_footer', 'seja_accordion_footer');
		endif;
		
		add_shortcode('accordion', 'seja_accordion');

/* ------------------------------------------------------------------------ * 
 * Shortcode - Anchor Div
 * ------------------------------------------------------------------------ */
		function seja_anchortext($atts, $content = null) {
			extract(shortcode_atts(array(
				'name' => 'next',
				), $atts));
			
			return "<div id=\"" . $name . "\"></div>
			";
		}
		add_shortcode('anchor', 'seja_anchortext');

/* ------------------------------------------------------------------------ * 
 * Shortcode - Clear Float
 * ------------------------------------------------------------------------ */
		function clear_float($atts) {
			extract(shortcode_atts(array(
				'clear' => 'both',
				), $atts));
			
			return "<br style=\"clear:" . $clear . "\">";
		}
		add_shortcode('clearfloat', 'clear_float');


/* ------------------------------------------------------------------------ * 
 * Shortcode - Inline Menu
 * ------------------------------------------------------------------------ */
function seja_list_menu($atts, $content = null) {
	extract(shortcode_atts(array(
		'menu'            => '',
		'container'       => 'div',
		'container_class' => '',

		'container_id'    => '',
		'menu_class'      => 'menu',
		'menu_id'         => '',
		'echo'            => true,
		'fallback_cb'     => 'wp_page_menu',
		'before'          => '',
		'after'           => '',
		'link_before'     => '',
		'link_after'      => '',
		'depth'           => 0,
		'walker'          => '',
		'theme_location'  => ''),
		$atts));

	return wp_nav_menu( array(
		'menu'            => $menu,
		'container'       => $container,
		'container_class' => $container_class,
		'container_id'    => $container_id,
		'menu_class'      => $menu_class,
		'menu_id'         => $menu_id,
		'echo'            => false,
		'fallback_cb'     => $fallback_cb,
		'before'          => $before,
		'after'           => $after,
		'link_before'     => $link_before,
		'link_after'      => $link_after,
		'depth'           => $depth,
		'walker'          => $walker,
		'theme_location'  => $theme_location));
}
//Create the shortcode
add_shortcode("inlinemenu", "seja_list_menu");

/* ------------------------------------------------------------------------ * 
 * Shortcode - Separator 
 *             (Generally not needed on most themes - Replaces <hr> as <div>) 
 * ------------------------------------------------------------------------ */
		function seja_separator($atts, $content = null) {
			extract(shortcode_atts(array(
				'null' => '',
				), $atts));
		
			return "<div class=\"separator\"></div>";
		}
		add_shortcode('separator', 'seja_separator');

/* ------------------------------------------------------------------------ * 
 * Shortcode - Facebook 1 - Like Button DEPRECIATED 2.10
 * ------------------------------------------------------------------------ */
		function seja_facebook_like($atts) {
			extract(shortcode_atts(array(
				'layout' => 'standard',
				'width' => '450',
				'height' => '25',
				'faces' => 'false',
				'colorscheme' => 'light',
				'action' => 'like',
				), $atts));
		
			return '<iframe src="http://www.facebook.com/plugins/like.php?href=' . urlencode(get_permalink($post->ID)) . '&amp;layout=' . $layout . '&amp;show_faces=' . $faces . '&amp;width=' . $width . '&amp;action=' . $action . '&amp;colorscheme=' . $colorscheme . '" scrolling="no" frameborder="0" allowTransparency="true" style="border:none; overflow:hidden; width:' . $width . 'px; height:' . $height . 'px"></iframe>';
		}
		add_shortcode('facebook', 'seja_facebook_like');

/* ------------------------------------------------------------------------ * 
 * Shortcode - Facebook 2 - News Feed
 * ------------------------------------------------------------------------ */
		
	$this_option = get_option('seja_facebook_options_url');
	if(!empty($this_option ) ) {
	
		//add facebook to top of page
		function seja_facebook_head() {
			echo('<div id="fb-root"></div>');
			echo('<script>(function(d, s, id) {');
			echo('  var js, fjs = d.getElementsByTagName(s)[0];');
			echo('  if (d.getElementById(id)) return;');
			echo('  js = d.createElement(s); js.id = id;');
			echo('  js.src = "//connect.facebook.net/en_GB/all.js#xfbml=1&appId=152745141428416";');
			echo('  fjs.parentNode.insertBefore(js, fjs);');
			echo('}(document, \'script\', \'facebook-jssdk\'));</script>');
		}
		
		// create shortcode
		function seja_facebook_feed($atts) {
			
			//$options = get_option('seja_facebook_options');
			
			/*extract(shortcode_atts(array(
				'url' => $options['seja_facebook_url'],
				'width' => $options['seja_facebook_width'],
				'height' => $options['seja_facebook_height'],
				'faces' => $options['seja_facebook_showfaces'],
				'colour' => $options['seja_facebook_colourscheme'],
				'datastream' => $options['seja_facebook_showstream'],
				'border' => $options['seja_facebook_bordercolour'],
				'header' => $options['seja_facebook_showheader'],
				), $atts));*/
				
				
			extract(shortcode_atts(array(
				'url' => SEJA_FACEBOOK_URL,
				'width' => SEJA_FACEBOOK_WIDTH,
				'height' => SEJA_FACEBOOK_HEIGHT,
				'faces' => SEJA_FACEBOOK_SHOWFACES,
				'colour' => SEJA_FACEBOOK_COLORSCHEME,
				'datastream' => SEJA_FACEBOOK_SHOWSTREAM,
				'border' => SEJA_FACEBOOK_BORDERCOLOR,
				'header' => SEJA_FACEBOOK_SHOWHEADER,
				), $atts));
				
			// define the checkbox returns
			if($faces == '1') : $faces = 'true'; else : $faces = 'false'; endif;
			if($datastream == '1') : $datestream = 'true'; else : $datestream = 'false'; endif;
			if($header == '1') : $header = 'true'; else : $header = 'false'; endif;
			
			if(!empty ($height ) ) :
				$height_output = ' data-height = "' . $height . '" ';
			endif;
		
			return '<div class="fb-like-box" data-href="' . $url . '" data-width="' . $width . '"' . $height_output . ' data-show-faces="' . $faces . '" data-colorscheme="' . $colour . '" data-stream="' . $datestream . '" data-border-color="' . $border . '" data-header="' . $header . '">&nbsp;</div>';
			
		} // end of facebook_feed function
		
		add_shortcode('facebookfeed', 'seja_facebook_feed');
		
	} // end if

/* ------------------------------------------------------------------------ * 
 * Shortcode - Google +
 * ------------------------------------------------------------------------ */
		function seja_google_plusone_head() {
		  echo '<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>';
		}
		function seja_google_plusone($atts) {
			extract(shortcode_atts(array(
				'' => '',
				), $atts));
			return "<div id=\"google-plus1\"><g:plusone></g:plusone></div>";
		}
		
		add_action('wp_head', 'seja_google_plusone_head');
		add_shortcode('googleplusone', 'seja_google_plusone');

/* ------------------------------------------------------------------------ * 
 * Shortcode - Twitter 
 * ------------------------------------------------------------------------ */
		function twitter_feed($atts) {
				
			$this_option = get_option('seja_twitter_options_code');	
				
			extract(shortcode_atts(array(
				'iframe' => $this_option
			), $atts));	
						
				return $iframe;
		}
		add_shortcode('twitter', 'twitter_feed');

/* ------------------------------------------------------------------------ * 
 * Shortcodes - YouTube
 * ------------------------------------------------------------------------ */
		function seja_youtube_embed($atts) {
						
			extract(shortcode_atts(array(
				'video' => '',
				'title' => '',
				'rel' => SEJA_YOUTUBE_SHORTCODE_REL,
				'width' => SEJA_YOUTUBE_SHORTCODE_WIDTH,
				'height' => SEJA_YOUTUBE_SHORTCODE_HEIGHT,
				), $atts));
		
		if ( $rel == '1' ) : $rel = ''; else : $rel = '?rel=0'; endif;
		if ( empty( $title ) ) : $title = '&nbsp;'; endif;
		
			return '<div class="youtube-block"><h3>' . $title . '</h3><iframe title="YouTube video player" class="youtube-player" width="' . $width . '" height="' . $height . '" src="http://www.youtube.com/embed/' . $video . $rel . '" frameborder="0" allowFullScreen></iframe></div>';
		}
		add_shortcode('youtube', 'seja_youtube_embed');
		
		
/* ------------------------------------------------------------------------ * 
 * Shortcodes - Post Excerpt Widget
 * ------------------------------------------------------------------------ */
 
	function seja_post_excerpt_widget($atts) {
					
			extract(shortcode_atts(array(
				'number' => '1',
				'limit' => '', // we may use this later
				), $atts));
			
		 query_posts('showposts=' . $number);
            	$html = '';
            while ( have_posts() ) : the_post(); 
				$title = the_title('<div class="widget-post-excerpt"><h3>', '</h3>', FALSE); 
				$html .= $title . get_the_excerpt() . '</div>';
            endwhile; 
			
			return $html;
	}

	add_shortcode('post_excerpt', 'seja_post_excerpt_widget');
	
/* ------------------------------------------------------------------------ * 
 * Shortcodes - HTML Include
 * ------------------------------------------------------------------------ */

	function seja_php_include_html($atts) {
					
			extract(shortcode_atts(array(
				'url' => '',
				), $atts));
			
			//$url = ABSPATH .  $url;
			$url = get_template_directory() . '/includes/html/' . $url;
			
			if( file_exists( $url ) ) :
				require_once ( $url );
								
			else :
			
				return false;
			
			endif;
	}

	add_shortcode('include_html', 'seja_php_include_html');
	
	
/* ------------------------------------------------------------------------ * 
 * Shortcodes - Weather widget
 * ------------------------------------------------------------------------ */	
	
	
	function seja_current_temperature_shortcode($atts, $content = null) {
						
		extract(shortcode_atts(array(
			'location' => '',
			'apparent' => '',
			'icon' => 'mono',
			'graph' => '' // future development
			), $atts));	
						
		$array = array(
			array (
				'location' => 'Adelaide SA', 
				'short_loc' => 'Adelaide', 
				'url' => 'http://www.bom.gov.au/fwo/IDS60801/IDS60801.94672.json'
			),
			array (
				'location' => 'Albany WA', 
				'short_loc' => 'Albany', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94802.json'
			),
			array (
				'location' => 'Albury VIC', 
				'short_loc' => 'Albury', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.95896.json'
			),
			array (
				'location' => 'Alice Springs NT', 
				'short_loc' => 'Alice Springs', 
				'url' => 'http://www.bom.gov.au/fwo/IDD60801/IDD60801.94326.json'
			),
			array (
				'location' => 'Ballarat VIC', 
				'short_loc' => 'Ballarat', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.94852.json'
			),
			array (
				'location' => 'Bendigo VIC' , 
				'short_loc' => 'Bendigo', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.94855.json'
			),
			array (
				'location' => 'Brisbane QLD', 
				'short_loc' => 'Brisbane', 
				'url' => 'http://www.bom.gov.au/fwo/IDQ60801/IDQ60801.94578.json'
			),
			array (
				'location' => 'Broome WA', 
				'short_loc' => 'Broome', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94203.json'
			),
			array (
				'location' => 'Bunbury WA', 
				'short_loc' => 'Bunbury', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94604.json'
			),
			array (
				'location' => 'Cairns QLD', 
				'short_loc' => 'Cairns', 
				'url' => 'http://www.bom.gov.au/fwo/IDQ60801/IDQ60801.94287.json'
			),
			array (
				'location' => 'Canberra ACT', 
				'short_loc' => 'Canberra', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60903/IDN60903.94926.json'
			),
			array (
				'location' => 'Ceduna SA', 
				'short_loc' => 'Ceduna', 
				'url' => 'http://www.bom.gov.au/fwo/IDS60801/IDS60801.94653.json'
			),
			array (
				'location' => 'Coolangatta NSW', 
				'short_loc' => 'Coolangatta', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94592.json'
			),
			array (
				'location' => 'Darwin NT', 
				'short_loc' => 'Darwin', 
				'url' => 'http://reg.bom.gov.au/fwo/IDD60901/IDD60901.94120.json'
			),
			array (
				'location' => 'Esperance WA', 
				'short_loc' => 'Esperance', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94638.json'
			),
			array (
				'location' => 'Essendon VIC', 
				'short_loc' => 'Essendon', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.95866.json'
			),
			array (
				'location' => 'Geelong VIC', 
				'short_loc' => 'Geelong', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.94857.json'
			),
			array (
				'location' => 'Gold Coast QLD', 
				'short_loc' => 'Gold Coast', 
				'url' => 'http://www.bom.gov.au/fwo/IDQ60801/IDQ60801.94580.json'
			),
			array (
				'location' => 'Hobart TAS', 
				'short_loc' => 'Hobart', 
				'url' => 'http://www.bom.gov.au/fwo/IDT60801/IDT60801.94970.json'
			),
			array (
				'location' => 'Kalgoorlie-Boulder WA', 
				'short_loc' => 'Kalgoorlie Boulder', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94637.json'
			),
			array (
				'location' => 'Launceston TAS', 
				'short_loc' => 'Launceston', 
				'url' => 'http://www.bom.gov.au/fwo/IDT60801/IDT60801.94969.json'
			),
			array (
				'location' => 'Melbourne VIC', 
				'short_loc' => 'Melbourne', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.94866.json'
			),
			array (
				'location' => 'Mildura VIC', 
				'short_loc' => 'Mildura', 
				'url' => 'http://www.bom.gov.au/fwo/IDV60801/IDV60801.94693.json'
			),
			array (
				'location' => 'Mount Isa QLD', 
				'short_loc' => 'Mt Isa', 
				'url' => 'http://www.bom.gov.au/fwo/IDQ60801/IDQ60801.94332.json'
			),
			array (
				'location' => 'Newcastle NSW', 
				'short_loc' => 'Newcastle', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94781.json'
			),
			array (
				'location' => 'Parramatta NSW',
				'short_loc' => 'Parramatta', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94764.json'
			),
			array (
				'location' => 'Penrith NSW', 
				'short_loc' => 'Penrith', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94763.json'
			),
			array (
				'location' => 'Perth WA', 
				'short_loc' => 'Perth', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94610.json'
			),
			array (
				'location' => 'Sydney NSW', 
				'short_loc' => 'Sydney', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94767.json'
			),
			array (
				'location' => 'Tamworth NSW', 
				'short_loc' => 'Tamworth', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.95762.json'
			),
			array (
				'location' => 'Townsville QLD', 
				'short_loc' => 'Townsville', 
				'url' => 'http://www.bom.gov.au/fwo/IDQ60801/IDQ60801.94294.json'
			),
			array (
				'location' => 'Wagga Wagga NSW', 
				'short_loc' => 'Wagga Wagga', 
				'url' => 'http://www.bom.gov.au/fwo/IDN60801/IDN60801.94910.json'
			),
			array (
				'location' => 'York WA', 
				'short_loc' => 'York', 
				'url' => 'http://www.bom.gov.au/fwo/IDW60801/IDW60801.94623.json')  
		);
		
		foreach ( $array as $object ) {
			if ( SEJA_WEATHER_JSON_LOCATION == $object['location'] ) :
				$json =  file_get_contents($object['url']);
				$short_location = $object['short_loc'];
			endif;
		}
		$json = json_decode ( $json, TRUE );
		
		$bom_location = $json['observations']['data'][0]['name'];
		$bom_actual = $json['observations']['data'][0]['air_temp'];
		$bom_apparent = $json['observations']['data'][0]['apparent_t'];
		// the following is an example of archived temperature (for the future graph) going back one hour (30 minutes each)
		// should be able to loop this...
		$bom_t1 = $json['observations']['data'][1]['air_temp'];
		$bom_t2 = $json['observations']['data'][2]['air_temp'];
		//print_r ($json);
		
		// weather icon (currently hard coded but maybe we will allow size adjustments in future versions
		$weather_icon_w = '30'; // full size is 150px
		$weather_icon_h = '40'; // full size is 200px
		
		if ( $bom_actual < '4.9' ) : 
			$gauge = 'gauge-low';
			$gauge_svg = '<path class="seja-icon-colour" d="M95.66,25.535h20.393c2.064,0,3.734-1.67,3.734-3.732c0-2.064-1.67-3.735-3.734-3.735H95.66 c-2.064,0-3.734,1.67-3.734,3.735C91.926,23.865,93.596,25.535,95.66,25.535z"/><path class="seja-icon-colour" d="M116.053,39.946H95.66c-2.064,0-3.734,1.67-3.734,3.732c0,2.063,1.67,3.735,3.734,3.735h20.393 c2.064,0,3.734-1.672,3.734-3.735C119.787,41.616,118.117,39.946,116.053,39.946z"/><path class="seja-icon-colour" d="M116.053,62.131H95.66c-2.064,0-3.734,1.67-3.734,3.732c0,2.062,1.67,3.732,3.734,3.732h20.393 c2.064,0,3.734-1.671,3.734-3.732C119.787,63.801,118.117,62.131,116.053,62.131z"/><path class="seja-icon-colour" d="M116.053,83.445H95.66c-2.064,0-3.734,1.672-3.734,3.735c0,2.06,1.67,3.731,3.734,3.731h20.393 c2.064,0,3.734-1.672,3.734-3.731C119.787,85.117,118.117,83.445,116.053,83.445z"/><path class="seja-icon-colour" d="M116.053,105.663H95.66c-2.064,0-3.734,1.67-3.734,3.732c0,2.063,1.67,3.733,3.734,3.733h20.393 c2.064,0,3.734-1.671,3.734-3.733C119.787,107.333,118.117,105.663,116.053,105.663z"/><path class="seja-icon-colour" d="M85.916,119.333V27.088H85.83C84.869,15.605,75.249,6.583,63.517,6.583 c-12.372,0-22.398,10.03-22.398,22.401v90.349c-10.868,7.247-18.03,19.615-18.03,33.658c0,22.328,18.101,40.428,40.429,40.428 c22.329,0,40.428-18.1,40.428-40.428C103.945,138.948,96.785,126.58,85.916,119.333z M63.517,14.596 c7.945,0,14.385,6.441,14.385,14.388l0.036,80.411H49.097l0.033-80.411C49.13,21.037,55.57,14.596,63.517,14.596z"/>';
		endif;
		
		if ( ( $bom_actual < '14.9' ) && ( $bom_actual > '5' ) ) :
			$gauge = 'gauge-low';
			$gauge_svg = '<path class="seja-icon-colour" d="M95.525,25.535h20.395c2.063,0,3.732-1.67,3.732-3.732c0-2.064-1.67-3.735-3.732-3.735H95.525 c-2.063,0-3.734,1.67-3.734,3.735C91.791,23.865,93.463,25.535,95.525,25.535z"/><path class="seja-icon-colour" d="M115.92,39.946H95.525c-2.063,0-3.734,1.67-3.734,3.732c0,2.063,1.672,3.735,3.734,3.735h20.395 c2.063,0,3.732-1.672,3.732-3.735C119.652,41.616,117.982,39.946,115.92,39.946z"/><path class="seja-icon-colour" d="M115.92,62.131H95.525c-2.063,0-3.734,1.67-3.734,3.732c0,2.062,1.672,3.732,3.734,3.732h20.395 c2.063,0,3.732-1.671,3.732-3.732C119.652,63.801,117.982,62.131,115.92,62.131z"/><path class="seja-icon-colour" d="M115.92,83.445H95.525c-2.063,0-3.734,1.672-3.734,3.735c0,2.06,1.672,3.731,3.734,3.731h20.395 c2.063,0,3.732-1.672,3.732-3.731C119.652,85.117,117.982,83.445,115.92,83.445z"/> <path class="seja-icon-colour" d="M115.92,105.663H95.525c-2.063,0-3.734,1.67-3.734,3.732c0,2.063,1.672,3.733,3.734,3.733h20.395 c2.063,0,3.732-1.671,3.732-3.733C119.652,107.333,117.982,105.663,115.92,105.663z"/> <path class="seja-icon-colour" d="M85.781,119.333V87.177V27.088h-0.084C84.734,15.605,75.114,6.583,63.382,6.583 c-12.371,0-22.399,10.03-22.399,22.401v90.349c-10.868,7.247-18.03,19.615-18.03,33.658c0,22.328,18.1,40.428,40.429,40.428 c22.331,0,40.428-18.1,40.428-40.428C103.811,138.948,96.648,126.58,85.781,119.333z M63.382,14.596 c7.944,0,14.388,6.441,14.388,14.388l0.023,58.193H48.971l0.023-58.193C48.995,21.037,55.437,14.596,63.382,14.596z"/>';
		endif;
		if ( ( $bom_actual < '24.9' ) && ( $bom_actual > '15' ) ) :
			$gauge = 'gauge-medlow';
			$gauge_svg = '<path class="seja-icon-colour" d="M95.924,25.535h20.393c2.063,0,3.732-1.67,3.732-3.732c0-2.064-1.67-3.735-3.732-3.735H95.924c-2.064,0-3.736,1.67-3.736,3.735C92.188,23.865,93.859,25.535,95.924,25.535z"/><path class="seja-icon-colour" d="M116.316,39.946H95.924c-2.064,0-3.736,1.67-3.736,3.732c0,2.063,1.672,3.735,3.736,3.735h20.393c2.063,0,3.732-1.672,3.732-3.735C120.049,41.616,118.379,39.946,116.316,39.946z"/><path class="seja-icon-colour" d="M116.316,62.131H95.924c-2.064,0-3.736,1.67-3.736,3.732c0,2.062,1.672,3.732,3.736,3.732h20.393c2.063,0,3.732-1.671,3.732-3.732C120.049,63.801,118.379,62.131,116.316,62.131z"/><path class="seja-icon-colour" d="M116.316,83.445H95.924c-2.064,0-3.736,1.672-3.736,3.735c0,2.06,1.672,3.731,3.736,3.731h20.393c2.063,0,3.732-1.672,3.732-3.731C120.049,85.117,118.379,83.445,116.316,83.445z"/><path class="seja-icon-colour" d="M116.316,105.663H95.924c-2.064,0-3.736,1.67-3.736,3.732c0,2.063,1.672,3.733,3.736,3.733h20.393c2.063,0,3.732-1.671,3.732-3.733C120.049,107.333,118.379,105.663,116.316,105.663z"/><path class="seja-icon-colour" d="M86.178,119.333V27.088h-0.086C85.131,15.605,75.512,6.583,63.779,6.583c-12.372,0-22.398,10.03-22.398,22.401v90.349c-10.869,7.247-18.03,19.615-18.03,33.658c0,22.328,18.1,40.428,40.428,40.428s40.428-18.1,40.428-40.428C104.207,138.948,97.047,126.58,86.178,119.333z M63.779,14.596c7.945,0,14.385,6.441,14.385,14.388l0.017,36.88H49.377l0.015-36.88C49.392,21.037,55.833,14.596,63.779,14.596z"/>';
		endif;
		if ( ( $bom_actual < '34.9' ) && ( $bom_actual > '25' ) ) :
			$gauge = 'gauge-med';
			$gauge_svg = '<path class="seja-icon-colour" d="M96.219,25.535h20.395c2.061,0,3.734-1.67,3.734-3.732c0-2.064-1.674-3.735-3.734-3.735H96.219 c-2.063,0-3.736,1.67-3.736,3.735C92.482,23.865,94.156,25.535,96.219,25.535z"/><path class="seja-icon-colour" d="M116.613,39.946H96.219c-2.063,0-3.736,1.67-3.736,3.732c0,2.063,1.674,3.735,3.736,3.735h20.395 c2.061,0,3.734-1.672,3.734-3.735C120.348,41.616,118.674,39.946,116.613,39.946z"/><path class="seja-icon-colour" d="M116.613,62.131H96.219c-2.063,0-3.736,1.67-3.736,3.732c0,2.062,1.674,3.732,3.736,3.732h20.395 c2.061,0,3.734-1.671,3.734-3.732C120.348,63.801,118.674,62.131,116.613,62.131z"/><path class="seja-icon-colour" d="M116.613,83.445H96.219c-2.063,0-3.736,1.672-3.736,3.735c0,2.06,1.674,3.731,3.736,3.731h20.395 c2.061,0,3.734-1.672,3.734-3.731C120.348,85.117,118.674,83.445,116.613,83.445z"/><path class="seja-icon-colour" d="M116.613,105.663H96.219c-2.063,0-3.736,1.67-3.736,3.732c0,2.063,1.674,3.733,3.736,3.733h20.395 c2.061,0,3.734-1.671,3.734-3.733C120.348,107.333,118.674,105.663,116.613,105.663z"/><path class="seja-icon-colour" d="M86.475,119.333V27.088h-0.084C85.426,15.605,75.807,6.583,64.075,6.583 c-12.371,0-22.399,10.03-22.399,22.401v90.349c-10.868,7.247-18.03,19.615-18.03,33.658c0,22.328,18.103,40.428,40.429,40.428 c22.331,0,40.431-18.1,40.431-40.428C104.506,138.948,97.342,126.58,86.475,119.333z M64.075,14.596 c7.946,0,14.388,6.441,14.388,14.388l0.006,14.694H49.684l0.006-14.694C49.69,21.037,56.13,14.596,64.075,14.596z"/>';
		endif;
		if ( $bom_actual > '35' ) : 
			$gauge = 'gauge-high' ;
			$gauge_svg = '<path class="seja-icon-colour" d="M96.219,25.535h20.393c2.063,0,3.734-1.67,3.734-3.732c0-2.064-1.672-3.735-3.734-3.735H96.219 c-2.064,0-3.734,1.67-3.734,3.735C92.484,23.865,94.154,25.535,96.219,25.535z"/> <path class="seja-icon-colour" d="M116.611,39.946H96.219c-2.064,0-3.734,1.67-3.734,3.732c0,2.063,1.67,3.735,3.734,3.735h20.393 c2.063,0,3.734-1.672,3.734-3.735C120.346,41.616,118.674,39.946,116.611,39.946z"/> <path class="seja-icon-colour" d="M116.611,62.131H96.219c-2.064,0-3.734,1.67-3.734,3.732c0,2.062,1.67,3.732,3.734,3.732h20.393 c2.063,0,3.734-1.671,3.734-3.732C120.346,63.801,118.674,62.131,116.611,62.131z"/> <path class="seja-icon-colour" d="M116.611,83.445H96.219c-2.064,0-3.734,1.672-3.734,3.735c0,2.06,1.67,3.731,3.734,3.731h20.393 c2.063,0,3.734-1.672,3.734-3.731C120.346,85.117,118.674,83.445,116.611,83.445z"/> <path class="seja-icon-colour" d="M116.611,105.663H96.219c-2.064,0-3.734,1.67-3.734,3.732c0,2.063,1.67,3.733,3.734,3.733h20.393 c2.063,0,3.734-1.671,3.734-3.733C120.346,107.333,118.674,105.663,116.611,105.663z"/> <path class="seja-icon-colour" d="M86.475,119.333V27.088h-0.088C85.428,15.605,75.806,6.583,64.076,6.583c-12.373,0-22.4,10.03-22.4,22.401 v90.349c-10.869,7.247-18.028,19.615-18.028,33.658c0,22.328,18.101,40.428,40.429,40.428c22.329,0,40.426-18.1,40.426-40.428 C104.502,138.948,97.342,126.58,86.475,119.333z M64.076,14.596c5.327,0,9.966,2.902,12.452,7.207H51.621 C54.108,17.499,58.749,14.596,64.076,14.596z"/>';
		endif;
				
		$html = '<div class="seja-current-weather ' . $gauge;
		if ( SEJA_WEATHER_JSON_APPARENT == '1' ) :
			$html .= ' has-apparent';
		endif;
		$html .= '"><div class="seja-weather-graph"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="' . $weather_icon_w . 'px" height="' . $weather_icon_w . 'px" viewBox="0 0 150 200" enable-background="new 0 0 150 200" xml:space="preserve"><g>' . $gauge_svg . '</g></svg></div><div class="seja-weather-output"><p>' . $bom_actual . '&deg;C';
		if ( SEJA_WEATHER_JSON_APPARENT == '1' ) :
			$html .= ' <span class="small">(feels like ' . $bom_apparent . '&deg;C)</span>';
		endif;
		$html .= '</p></div><div class="seja-weather-location"><h2>' . $short_location . '</h2></div></div>';
		
		return $html;
	/*	
		echo 'This is the current output -<br />
location is ' . $bom_location . ' (' . $short_location . ')<br />
actual temp is ' . $bom_actual . '&deg;C<br />
it feels like ' .$bom_apparent . '&deg;C<br />
<br />
last hour was ' . $bom_t1 . '&deg;C<br />
before that was ' . $bom_t2 .  '&deg;C';
	*/
  }
  add_shortcode('current_temp', 'seja_current_temperature_shortcode');
	
/* ------------------------------------------------------------------------ * 
 * Shortcodes - Widget in Page
 * ------------------------------------------------------------------------ */
	
	function seja_page_widget($atts) {
    
    global $wp_widget_factory; 
    
    extract(shortcode_atts(array(
        'widget_name' => FALSE
    ), $atts));
    
    $widget_name = wp_specialchars($widget_name);
    
    if (!is_a($wp_widget_factory->widgets[$widget_name], 'WP_Widget')):
        $wp_class = 'WP_Widget_'.ucwords(strtolower($class));
        
        if (!is_a($wp_widget_factory->widgets[$wp_class], 'WP_Widget')):
            return '<p>'.sprintf(__("%s: Widget class not found. Make sure this widget exists and the class name is correct"),'<strong>'.$class.'</strong>').'</p>';
        else:
            $class = $wp_class;
        endif;
    endif;
    
    ob_start();
    the_widget($widget_name, $instance, array('widget_id'=>'arbitrary-instance-'.$id,
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '',
        'after_title' => ''
    ));
    $output = ob_get_contents();
    ob_end_clean();
    return $output;
    
}
add_shortcode('pagewidget','seja_page_widget'); 

/* ------------------------------------------------------------------------ * 
 * END OF SECTION - Shortcodes
 * ------------------------------------------------------------------------ */
 
 /* new shortcode for 2.10 - currently beta; things may change */
 
 /* This shortcode is designed to act as a wrapper for alternative content on scrolling content pages (ie. the homepage template).
 	It has two variables, 'id' used as the #id for the wrapping div and 'after_id' which is the #id for the following div. If
	the after_id is left blank it is assumed that there is no following item and the content flows to the footer. I've not yet 
	tested this so I may need to reformat the returning div's */
 
 function seja_multiblock_shortcode($atts, $content = null) {
						
		extract(shortcode_atts(array(
			'id' => '',
			'after_id' => 'end',
			), $atts));
		
		// adding after_id="end" will terminate the block so that it is the last (even number of blocks)
		$end = '';
		// otherwise, after_id="xxxxx" will name the starting id of the next block (odd number of blocks)
		if( $after_id != 'end' )	
		$end = '<div id="' . $after_id . '" class="full-width-column">
			<div class="inner-wrapper">
			<div class="hentry">
			<div class="entry-content">';

		return sprintf(
            '</div>
			</div>
			</div>
			</div>
			<div id="' . $id . '" class="full-width-column alt-bg">
			<div class="inner-wrapper">
			<div class="hentry">
			<div class="entry-content">' .
			$content . '
			</div>
			</div>
			</div>
			</div>' . $end);
	}
	add_shortcode('multiblock', 'seja_multiblock_shortcode');