<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * Configure robots.txt thickbox modal page
 *
 * ------------------------------------------------------------------------ */

?>
<!DOCTYPE html>
<!--[if IE 8]>
<html xmlns="http://www.w3.org/1999/xhtml" class="ie8 wp-toolbar"  lang="en-AU">
<![endif]-->
<!--[if !(IE 8) ]><!-->
<html xmlns="http://www.w3.org/1999/xhtml" class="wp-toolbar"  lang="en-AU">
<!--<![endif]-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,800,700' rel='stylesheet' type='text/css'>
<style>
html {
	background:#f1f1f1;
}
body {	
	width:96%;
	font-family: 'Open Sans', sans-serif;
	color: #444;
    font-size: 16px;
    line-height: 1.4em;
	margin:0;
	padding:2%;
}
h2 {
	font-size: 23px;
    font-weight: 400;
    line-height: 29px;
    margin: 0;
    padding: 9px 15px 4px 0;
}
input[type="text"], input[type="radio"], input[type="checkbox"], select, textarea {
    background-color: rgb(255, 255, 255);
    border: 1px solid rgb(221, 221, 221);
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.07) inset;
    color: rgb(50, 55, 60);
    outline: 0 none;
    transition: border-color 50ms ease-in-out 0s;
}
input, textarea {
    box-sizing: border-box;
}
textarea {
	width:90%;
	min-height:300px;
}
label {
	display:inline-block;
}
.code, code {
    font-family: Consolas,Monaco,monospace;
    unicode-bidi: embed;
}
.error {
	color:#f00;
}
</style>
</head>
<body>
<?php

/* ------------------------------------------------------------------------ * 
 * Define our variables
 * ------------------------------------------------------------------------ */
$robots_file = $_GET['source'] . 'robots.txt';
$sitemap_file = $_GET['source'] . 'sitemap.xml';
$function = $_GET['function'];
$error_message = '';
$message = '';
$status = '';
?>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>?source=<?php echo $_GET['source']; ?>&function=<?php echo $_GET['function']; ?>" method="post">

<?php

/* ------------------------------------------------------------------------ * 
 * Delete robots.txt
 * ------------------------------------------------------------------------ */

if( isset( $_POST['delete'] ) && ( $_POST['delete'] == 'Delete robots.txt' ) ) :

		unlink( $robots_file );
		?>
        
        <h2>Robots.txt file deleted</h2>
        <p class="error">File will still appear in the parent window (SEO Settings) until you refresh the page.</p>
        <?php
		$function = 'create';
endif;
// end of part 5 

/* ------------------------------------------------------------------------ * 
 * Process auto-configure form and create robots.txt
 * ------------------------------------------------------------------------ */
if( isset($_POST['submit']) && ($_POST['submit'] == 'Create' ) ) :
		
		//create the file
		$robots_txt = fopen( $robots_file, 'w' ) or die('unable to create robots.txt file');
		// create the file content
		$write_robots = "# Generated by Seja Framework\r";
		$write_robots .= "\n";
		$write_robots .= "User-Agent: *\r";
		$write_robots .= "\n";
		
		if( !empty( $_POST['base'] ) && ( $_POST['base'] == '2' ) ) :
			$write_robots .= "Disallow: /wp-admin/\r";
			$write_robots .= "\n";
			$write_robots .= "Disallow: /wp-includes/\r";
			$write_robots .= "\n";
			$write_robots .= "Disallow: /xmlrpc.php\r";
		else :
			$write_robots .= "Disallow:\r";
		endif;
		if( !empty ( $_POST['sitemap'] ) && ( $_POST['sitemap'] == '1' ) ) :
			if(file_exists( $sitemap_file ) ) :
				$write_robots .= "\r\n";
				$write_robots .= "\r\n";
				$write_robots .= "Sitemap: " . $sitemap_file;
			else :
				$error_message = '<p class="error">You have requested a link to your sitemap, however we cannot find one on the server<br>Sitemaps will auto-generate on Linux based systems but only after pages or posts have been created.</p><p>If you wish to add the sitemap to the robots.txt file at a future date you can copy and paste this line of code in:</p><code></code><p>Alternatively, you can delete the sitemap and re-run this file generator.</p>';
			endif; 
		endif; 
			
		// write the new robots file 
		fwrite( $robots_txt, $write_robots );
		$message = '<p><span class="error">Note:</span> The robots.txt file has been created, however it will not show up in the parent window (SEO Settings) until you refresh the page</p>';
		$status = 'has been created';
		$function = 'edit';
		
endif;




/* ------------------------------------------------------------------------ * 
 * Update an existing robots.txt file
 * ------------------------------------------------------------------------ */

if( isset($_POST['update']) && ($_POST['update'] == 'Update robots.txt' ) ) :
		
		$robots_txt = fopen( $robots_file, 'w' );
		//echo $_POST['seja_robots_txt'];
		fwrite( $robots_txt, $_POST['seja_robots_txt'] );
		
		$status = 'has been updated';
		$function = 'edit';
	
endif;	
// end part 4


/* ------------------------------------------------------------------------ * 
 * Display robots.txt file (after create or update)
 * ------------------------------------------------------------------------ */

if( $function == 'edit' ) :

		$robots_txt = fopen( $robots_file, "r");
		?>
    	<h2>Robots txt file <?php echo $status; ?></h2>


			<p><textarea name="seja_robots_txt" rows="5" cols="20" id="seja_robots_txt" class="large-text code"><?php echo fread($robots_txt,filesize( $robots_file )); ?></textarea></p>
            <?php echo $message; ?>
			<p><input type="submit" name="update" value="Update robots.txt"> &nbsp; <input type="submit" name="delete" value="Delete robots.txt" class="warning"></p>

		<?php echo $error_message; ?>
		 
		<?php fclose( $robots_txt );

endif; 
	// end part 4



/* ------------------------------------------------------------------------ * 
 * Display auto-create options if there is no robots.txt file found
 * ------------------------------------------------------------------------ */

if( $function == 'create') : ?>
<h2>Create Robots txt file</h2>

  <p>
    <input type="radio" id="basic" name="base" value="1" />
    <label for="basic">Basic text (recommended)</label>
    <br>
    <input type="radio" id="restrictive" name="base" value="2" />
    <label for="restrictive">Restrictive (Blocks admin and include directories)</label>
  </p>
  <p>
    <input type="checkbox" id="sitemap" name="sitemap" value="1" />
    <label for="sitemap">Link to your sitemap (optional)</label>
  </p>
  <p>
    <input type="submit" name="submit" value="Create" id="submit" />
  </p>

<?php endif; ?>
</form>
</body>
</html>