<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 * 
 * Custom Fields based on http://sltaylor.co.uk/blog/control-your-own-wordpress-custom-fields/
 * ------------------------------------------------------------------------ */
if ( ! defined( 'ABSPATH' ) ) { exit; }

if ( !class_exists('myCustomFields') ) {

	class myCustomFields {

		var $prefix = 'seja_customfield_'; 
		var $customFields =	array(
			array(
				"name"			=> "meta_description",
				"title"			=> "Meta - Description",
				"description"	=> "Edit meta description for this entry",
				"type"			=> "text",
				"scope"			=>	array( "post", "page" ),
				"css"           => "seo meta-description",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "meta_keywords",
				"title"			=> "Meta - Keywords",
				"description"	=> "Edit meta keywords for this entry (use a comma to seperate each)",
				"type"			=> "text",
				"scope"			=>	array( "post", "page" ),
				"css"           => "seo meta-keywords",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "additional_title",
				"title"			=> "Header Title",
				"description"	=> "Replace default &lt;title&gt; tag with user-defined text",
				"type"			=> "text",
				"scope"			=>	array( "post", "page" ),
				"css"           => "seo title-tag",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "alternative_title",
				"title"			=> "Alternative Page Title",
				"description"	=> "Add a page title here if you want to include custom formatting - IMPORTANT: This replaces the default page title BUT you should still include it as other WordPress features need to hook into this",
				"type"			=> "text",
				"scope"			=>	array( "page" ),
				"css"           => "customisation alt-page-title",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "advertising",
				"title"			=> "Disable Insert Content",
				"description"	=> "Disable auto-inserted content (such as adwords)",
				"type"			=> "checkbox",
				"scope"			=>	array( "page" ),
				"css"           => "customisation advertising",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "fb_pixel",
				"title"			=> "Facebook Pixel Option",
				"description"	=> "Select a custom facebook Pixel option for this page",
				"type"			=> "dropdown",
				"scope"			=>	array( "page" ),
				"option"		=>  array( "--", "ViewContent", "Search", "AddToCart", "AddToWishlist", "InitiateCheckout", "AddPaymentInfo", "Purchase", "Lead", "CompleteRegistration" ),
				"css"           => "customisation fb-pixel",
				"capability"	=> "edit_pages"
			),		
			array(
				"name"			=> "sidebar_text_1",
				"title"			=> "Top Content Block",
				"description"	=> "If you write content in here, it will appear at the top of the page, between the header and the title",
				"type"			=>	"wysiwyg",
				"scope"			=>	array( "page" ),
				"css"           => "formatting top-content-block",
				"capability"	=> "edit_pages"
			),
			array(
				"name"			=> "sidebar_text_2",
				"title"			=> "Custom Sidebar text",
				"description"	=> "Add text to the sidebar on a post by post basis - You must activate the widget for this to work",
				"type"			=>	"wysiwyg",
				"scope"			=>	array( "page"),
				"css"           => "formatting sidebar-text",
				"capability"	=> "edit_pages"
			)
		);
		
		// should be able to add an if statement here

		// Remove the default Custom Fields meta box
		function seja_remove_default_fields( $type, $context, $post ) {
			foreach ( array( 'normal', 'advanced', 'side' ) as $context ) {
				remove_meta_box( 'postcustom', 'post', $context );
				remove_meta_box( 'postcustom', 'page', $context );
			}
		}
		//Create the new Custom Fields meta box
		
		function createCustomFields() {
			if ( function_exists( 'add_meta_box' ) ) {
				
				// locate the parent id from the current editor post
				$var  = wp_get_post_parent_id( $_GET[ 'post' ] );
				// if the parent isn't a scroll page, display the meta-boxes
				if ( get_page_template_slug( $var ) != 'page-scroll.php' ) : 
   					add_meta_box( 'seja-custom-meta', 'Custom Fields', array( &$this, 'displayCustomFields' ), 'page', 'normal', 'high' );
				endif;
				
				add_meta_box( 'seja-custom-meta', 'Custom Fields', array( &$this, 'displayCustomFields' ), 'post', 'normal', 'high' );
			}
		}
		/**
		* Display the new Custom Fields meta box
		*/
		function displayCustomFields() {
			global $post;
			?>
			<div class="form-wrap seja-custom-fields">
				<?php
				wp_nonce_field( 'my-custom-fields', 'my-custom-fields_wpnonce', false, true );
				foreach ( $this->customFields as $customField ) {
					// Check scope
					$scope = $customField[ 'scope' ];
					$output = false;
					foreach ( $scope as $scopeItem ) {
						switch ( $scopeItem ) {
							case "post": {
								// Output on any post screen
								if ( basename( $_SERVER['SCRIPT_FILENAME'] )=="post-new.php" || $post->post_type=="post" )
									$output = true;
								break;
							}
							case "page": {
								// Output on any page screen
								if ( basename( $_SERVER['SCRIPT_FILENAME'] )=="page-new.php" || $post->post_type=="page" )
									$output = true;
								break;
							}
						}
						if ( $output ) break;
					}
					// Check capability
					if ( !current_user_can( $customField['capability'], $post->ID ) )
						$output = false;
					// Output if allowed
					if ( $output ) { ?>
						<div class="form-field form-required <?php echo( $customField[ 'css' ] ); ?>">
							<?php
							switch ( $customField[ 'type' ] ) {
								case "checkbox": {
									// Checkbox
									echo '<label for="' . $this->prefix . $customField[ 'name' ] .'" style="display:inline;"><b>' . $customField[ 'title' ] . '</b></label>&nbsp;&nbsp;';
									echo '<input type="checkbox" name="' . $this->prefix . $customField['name'] . '" id="' . $this->prefix . $customField['name'] . '" value="yes"';
									if ( get_post_meta( $post->ID, $this->prefix . $customField['name'], true ) == "yes" )
										echo ' checked="checked"';
									echo '" style="width: auto;" />';
									break;
								}								
								case "dropdown": {
                                	// dropdown
                                    echo '<label for="' . $this->prefix . $customField[ 'name' ] .'"></label>&nbsp;&nbsp;';
                                    echo '<select name="' . $this->prefix . $customField[ 'name' ] . '" id="' . $this->prefix . $customField['name'] . '">';
									// options
									$dropdown_option =  $customField[ 'option' ];
									foreach ( $dropdown_option as $value) {
										echo '<option value="' . $value . '"';
										if ( get_post_meta( $post->ID, $this->prefix . $customField['name'], true ) == $value )
											echo ' selected="selected"';
										echo '>' . $value . '</option>';
									}
									echo '</select>';
                                	break;
                                }
								case "textarea": {
									// Text area
									echo '<label for="' . $this->prefix . $customField[ 'name' ] .'"><b>' . $customField[ 'title' ] . '</b></label>';
									echo '<textarea name="' . $this->prefix . $customField[ 'name' ] . '" id="' . $this->prefix . $customField[ 'name' ] . '" columns="30" rows="5">' . htmlspecialchars( get_post_meta( $post->ID, $this->prefix . $customField[ 'name' ], true ) ) . '</textarea>';

									break;
								}
								case "wysiwyg": {
									// Text area
									echo '<label for="' . $this->prefix . $customField[ 'name' ] .'"><b>' . $customField[ 'title' ] . '</b></label>';									
									$content = get_post_meta( $post->ID, $this->prefix . $customField[ 'name' ], true );
									$editor_id = $this->prefix . $customField[ 'name' ];
									
									wp_editor( $content, $editor_id );
									break;
								}
								default: {
									// Plain text field
									echo '<label for="' . $this->prefix . $customField[ 'name' ] .'"><b>' . $customField[ 'title' ] . '</b></label>';
									echo '<input type="text" name="' . $this->prefix . $customField[ 'name' ] . '" id="' . $this->prefix . $customField[ 'name' ] . '" value="' . htmlspecialchars( get_post_meta( $post->ID, $this->prefix . $customField[ 'name' ], true ) ) . '" />';
									break;
								}
							}
							?>
							<?php if ( $customField[ 'description' ] ) echo '<p>' . $customField[ 'description' ] . '</p>'; ?>
						</div>
					<?php
					}
				} ?>
			</div>
			<?php
		}
		/**
		* Save the new Custom Fields values
		*/
		function saveCustomFields( $post_id, $post ) {
			if( isset( $_POST[ 'my-custom-fields_wpnonce' ] ) ) :
				if ( !wp_verify_nonce( $_POST[ 'my-custom-fields_wpnonce' ], 'my-custom-fields' ) )
					return;
			endif;
			if ( !current_user_can( 'edit_post', $post_id ) )
				return;
			if ( $post->post_type != 'page' && $post->post_type != 'post' )
				return;
			foreach ( $this->customFields as $customField ) {
				if ( current_user_can( $customField['capability'], $post_id ) ) {
					if ( isset( $_POST[ $this->prefix . $customField['name'] ] ) && trim( $_POST[ $this->prefix . $customField['name'] ] ) ) {
						$value = $_POST[ $this->prefix . $customField['name'] ];
						// Auto-paragraphs for any WYSIWYG
						if ( $customField['type'] == "wysiwyg" ) $value = wpautop( $value );
						update_post_meta( $post_id, $this->prefix . $customField[ 'name' ], $value );
					} else {
						delete_post_meta( $post_id, $this->prefix . $customField[ 'name' ] );
					}
				}
			}
		}
		
		function __construct() {
			add_action( 'admin_menu', array( &$this, 'createCustomFields' ) );
			add_action( 'save_post', array( &$this, 'saveCustomFields' ), 1, 2 );
			//add_action( 'do_meta_boxes', array( &$this, 'seja_remove_default_fields' ), 10, 3 );
		}


	} // End Class

} // End if class exists statement

// Instantiate the class
if ( class_exists('myCustomFields') ) {
	$myCustomFields_var = new myCustomFields();
}
?>