<?php
/* ------------------------------------------------------------------------ *
 * Seja Framework Version 3.0
 *
 * The template for displaying Comments.
 *
 * @package WordPress
 * @subpackage Seja_Framework
 
 * ------------------------------------------------------------------------ */
?>
<?php 
if( comments_open() ): ?>
    <div id="comments">
		<?php if ( post_password_required() ) : ?>
            <p class="nopassword">
				<?php _e( 'This post is password protected. Enter the password to view any comments.', 'seja_framework' ); ?>
             </p>
	</div><!-- #comments -->
                <?php 
            return;
        endif; // end post password required
        ?>
        <?php if ( have_comments() ) : ?>
            <h3 id="comments-title">
				<?php
                printf( _n( 'One Response to %2$s', '%1$s Responses to %2$s', get_comments_number(), 'seja_framework' ),
                number_format_i18n( get_comments_number() ), '<em>' . get_the_title() . '</em>' );
                ?>
            </h3>
            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there navigatable comments? ?>
                <div class="navigation">
                    <div class="nav-previous">
						<?php previous_comments_link( __( '<span class="meta-nav">&larr;</span> Older Comments', 'seja_framework' ) ); ?>
                    </div>
                    <div class="nav-next">
						<?php next_comments_link( __( 'Newer Comments <span class="meta-nav">&rarr;</span>', 'seja_framework' ) ); ?>
                    </div>
                </div><!-- .navigation -->
            <?php endif; // check for comment navigation ?>
            <ol class="commentlist">
				<?php wp_list_comments( array( 'callback' => 'seja_comment' ) ); ?>
            </ol>
            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there navigatable comments? ?>
                <div class="navigation">
                    <div class="nav-previous">
						<?php previous_comments_link( __( '<span class="meta-nav">&larr;</span> Older Comments', 'seja_framework' ) ); ?>
                    </div>
                    <div class="nav-next">
						<?php next_comments_link( __( 'Newer Comments <span class="meta-nav">&rarr;</span>', 'seja_framework' ) ); ?>
                    </div>
                </div><!-- .navigation -->
            <?php endif; // check for comment navigation ?>
        <?php endif; // end have_comments() ?>
        <?php comment_form(); ?>
    </div><!-- #comments -->
<?php endif; // end comments_open
